/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.pcap.util;

import nl.sidnlabs.pcap.PcapReaderUtil;

public class ICMPv4Util {
    public static final int ICMP_TYPE_OFFSET = 0;
    public static final int ICMP_CODE_OFFSET = 1;
    public static final int ICMP_REST_OF_HDR_OFFSET = 4;
    public static final int ICMP_REST_OF_HDR_LEN = 4;
    public static final int ICMP_DATA_OFFSET = 8;
    public static final int ICMP_HDR_LEN = 8;
    public static final int ICMP_ECHO_REQUEST_ID_OFFSET = 4;
    public static final int ICMP_ECHO_REQUEST_SEQ_OFFSET = 6;
    public static final int ICMP_ECHO_REQUEST_PAYLOAD_OFFSET = 8;

    private ICMPv4Util() {
    }

    public static short decodeType(byte[] packetData) {
        return PcapReaderUtil.readUnsignedByte(packetData, 0);
    }

    public static short decodeCode(byte[] packetData) {
        return PcapReaderUtil.readUnsignedByte(packetData, 1);
    }

    public static byte[] extractRestOfHeader(byte[] packetData) {
        byte[] data = new byte[4];
        System.arraycopy(packetData, 4, data, 0, 4);
        return data;
    }

    public static byte[] extractPayload(byte[] packetData) {
        int length = packetData.length - 8;
        byte[] data = new byte[length];
        System.arraycopy(packetData, 8, data, 0, length);
        return data;
    }

    public static byte[] extractEchoRequestPayload(byte[] packetData) {
        byte[] data = new byte[packetData.length - 8];
        System.arraycopy(packetData, 8, data, 0, data.length);
        return data;
    }
}

