/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.pcap.packet;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import nl.sidnlabs.pcap.packet.SequencePayload;

public class FlowData {
    private long lastSequence;
    private long lastSize;
    private Set<SequencePayload> payloads = new HashSet<SequencePayload>();

    public void addPayload(SequencePayload p) {
        this.payloads.add(p);
        this.lastSequence = p.getSeq();
        this.lastSize = p.size();
    }

    public int size() {
        return this.payloads.size();
    }

    public List<SequencePayload> getSortedPayloads() {
        return this.payloads.stream().sorted().collect(Collectors.toList());
    }

    public List<SequencePayload> getPayloads() {
        return this.payloads.stream().collect(Collectors.toList());
    }

    public boolean isMinPayloadAvail() {
        for (SequencePayload p : this.payloads) {
            if (p.size() <= 2) continue;
            return true;
        }
        return false;
    }

    public long getNextExpectedSequence() {
        return this.lastSequence + this.lastSize;
    }

    public int getBytesAvail() {
        int sum = 0;
        for (SequencePayload p : this.payloads) {
            sum += p.size();
        }
        return sum;
    }

    public long getLastSequence() {
        return this.lastSequence;
    }

    public long getLastSize() {
        return this.lastSize;
    }

    public void setLastSequence(long lastSequence) {
        this.lastSequence = lastSequence;
    }

    public void setLastSize(long lastSize) {
        this.lastSize = lastSize;
    }

    public void setPayloads(Set<SequencePayload> payloads) {
        this.payloads = payloads;
    }
}

