/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.pcap.decoder;

import nl.sidnlabs.pcap.PcapReaderUtil;
import nl.sidnlabs.pcap.decoder.DNSDecoder;
import nl.sidnlabs.pcap.decoder.Decoder;
import nl.sidnlabs.pcap.packet.DNSPacket;
import nl.sidnlabs.pcap.packet.Packet;
import nl.sidnlabs.pcap.util.UDPUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UDPDecoder
implements Decoder {
    private static final Logger log = LogManager.getLogger(UDPDecoder.class);
    private DNSDecoder dnsDecoder;
    private int packetCounter = 0;
    private int reqCounter = 0;
    private int respCounter = 0;

    public UDPDecoder(DNSDecoder dnsDecoder) {
        this.dnsDecoder = dnsDecoder;
    }

    @Override
    public Packet reassemble(Packet packet, byte[] packetData) {
        ++this.packetCounter;
        packet.setSrcPort(PcapReaderUtil.convertShort(packetData, 0));
        packet.setDstPort(PcapReaderUtil.convertShort(packetData, 2));
        if (!this.isDNS(packet)) {
            if (log.isDebugEnabled()) {
                log.debug("Packet is not a DNS packet: " + String.valueOf(packet));
            }
            return Packet.NULL;
        }
        byte[] packetPayload = this.decode(packetData);
        if (packetPayload.length == 0) {
            if (log.isDebugEnabled()) {
                log.debug("No valid DNS packet found: " + String.valueOf(packet));
            }
            return Packet.NULL;
        }
        if (packet.getDstPort() == 53) {
            ++this.reqCounter;
        } else {
            ++this.respCounter;
        }
        packet.setLen(packetData.length);
        packet.setPayloadLength(UDPUtil.getUdpLen(packetData));
        return this.dnsDecoder.decode((DNSPacket)packet, packetPayload, 0, packetPayload.length);
    }

    public byte[] decode(byte[] packetData) {
        int payloadLength = packetData.length - 8;
        return PcapReaderUtil.readPayload(packetData, 8, payloadLength);
    }

    @Override
    public void printStats() {
        log.info("------------- UDP Decoder Stats --------------------------");
        log.info("Packets: {}", (Object)this.packetCounter);
        log.info("Requests: {}", (Object)this.reqCounter);
        log.info("Responses: {}", (Object)this.respCounter);
    }

    @Override
    public void reset() {
        this.packetCounter = 0;
        this.reqCounter = 0;
        this.respCounter = 0;
        this.dnsDecoder.reset();
    }

    public DNSDecoder getDnsDecoder() {
        return this.dnsDecoder;
    }

    public int getPacketCounter() {
        return this.packetCounter;
    }

    public int getReqCounter() {
        return this.reqCounter;
    }

    public int getRespCounter() {
        return this.respCounter;
    }

    public void setDnsDecoder(DNSDecoder dnsDecoder) {
        this.dnsDecoder = dnsDecoder;
    }

    public void setPacketCounter(int packetCounter) {
        this.packetCounter = packetCounter;
    }

    public void setReqCounter(int reqCounter) {
        this.reqCounter = reqCounter;
    }

    public void setRespCounter(int respCounter) {
        this.respCounter = respCounter;
    }
}

