/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.pcap.packet;

import java.net.InetAddress;
import nl.sidnlabs.pcap.packet.Datagram;
import nl.sidnlabs.pcap.packet.TCPFlow;

public class Packet {
    public static final Packet NULL = new Packet();
    public static final Packet LAST = new Packet();
    private byte[] data;
    private int ipStart;
    private String filename;
    protected int len;
    protected long tsMilli;
    protected long ipId;
    protected int ttl;
    protected int ipVersion;
    protected int ipHeaderLen;
    protected byte protocol;
    protected String src;
    protected String dst;
    protected InetAddress srcAddr;
    protected InetAddress dstAddr;
    protected long fragOffset;
    protected boolean fragmented;
    protected boolean lastFragment;
    protected boolean doNotFragment;
    protected int reassembledFragments;
    protected boolean fragmentFlagM;
    protected int reassembledTCPFragments;
    protected int srcPort;
    protected int dstPort;
    protected int tcpflow;
    protected int tcpHeaderLen;
    protected long tcpSeq;
    protected long tcpAck;
    protected boolean tcpFlagNs;
    protected boolean tcpFlagCwr;
    protected boolean tcpFlagEce;
    protected boolean tcpFlagUrg;
    protected boolean tcpFlagAck;
    protected boolean tcpFlagPsh;
    protected boolean tcpFlagRst;
    protected boolean tcpFlagSyn;
    protected boolean tcpFlagFin;
    protected int tcpWindowSize;
    private int totalLength;
    protected int payloadLength;
    protected int tcpHandshakeRTT = -1;
    private TCPFlow flow;
    private TCPFlow reverseFlow;

    public Packet() {
    }

    public Packet(byte protocol) {
        this.protocol = protocol;
    }

    public TCPFlow getFlow() {
        if (this.flow == null) {
            this.flow = new TCPFlow(this.src, this.srcPort, this.dst, this.dstPort, this.protocol);
        }
        return this.flow;
    }

    public TCPFlow getReverseFlow() {
        if (this.reverseFlow == null) {
            this.reverseFlow = new TCPFlow(this.dst, this.dstPort, this.src, this.srcPort, this.protocol);
        }
        return this.reverseFlow;
    }

    public Datagram getDatagram() {
        return new Datagram(this.getSrc(), this.getDst(), this.getIpId(), String.valueOf(this.getProtocol()), this.getTsMilli());
    }

    public boolean isIPv4() {
        return this.getIpVersion() == 4;
    }

    public boolean isIPv6() {
        return this.getIpVersion() == 6;
    }

    public long nextAck() {
        return this.tcpSeq + (long)this.payloadLength;
    }

    public byte[] getData() {
        return this.data;
    }

    public int getIpStart() {
        return this.ipStart;
    }

    public String getFilename() {
        return this.filename;
    }

    public int getLen() {
        return this.len;
    }

    public long getTsMilli() {
        return this.tsMilli;
    }

    public long getIpId() {
        return this.ipId;
    }

    public int getTtl() {
        return this.ttl;
    }

    public int getIpVersion() {
        return this.ipVersion;
    }

    public int getIpHeaderLen() {
        return this.ipHeaderLen;
    }

    public byte getProtocol() {
        return this.protocol;
    }

    public String getSrc() {
        return this.src;
    }

    public String getDst() {
        return this.dst;
    }

    public InetAddress getSrcAddr() {
        return this.srcAddr;
    }

    public InetAddress getDstAddr() {
        return this.dstAddr;
    }

    public long getFragOffset() {
        return this.fragOffset;
    }

    public boolean isFragmented() {
        return this.fragmented;
    }

    public boolean isLastFragment() {
        return this.lastFragment;
    }

    public boolean isDoNotFragment() {
        return this.doNotFragment;
    }

    public int getReassembledFragments() {
        return this.reassembledFragments;
    }

    public boolean isFragmentFlagM() {
        return this.fragmentFlagM;
    }

    public int getReassembledTCPFragments() {
        return this.reassembledTCPFragments;
    }

    public int getSrcPort() {
        return this.srcPort;
    }

    public int getDstPort() {
        return this.dstPort;
    }

    public int getTcpflow() {
        return this.tcpflow;
    }

    public int getTcpHeaderLen() {
        return this.tcpHeaderLen;
    }

    public long getTcpSeq() {
        return this.tcpSeq;
    }

    public long getTcpAck() {
        return this.tcpAck;
    }

    public boolean isTcpFlagNs() {
        return this.tcpFlagNs;
    }

    public boolean isTcpFlagCwr() {
        return this.tcpFlagCwr;
    }

    public boolean isTcpFlagEce() {
        return this.tcpFlagEce;
    }

    public boolean isTcpFlagUrg() {
        return this.tcpFlagUrg;
    }

    public boolean isTcpFlagAck() {
        return this.tcpFlagAck;
    }

    public boolean isTcpFlagPsh() {
        return this.tcpFlagPsh;
    }

    public boolean isTcpFlagRst() {
        return this.tcpFlagRst;
    }

    public boolean isTcpFlagSyn() {
        return this.tcpFlagSyn;
    }

    public boolean isTcpFlagFin() {
        return this.tcpFlagFin;
    }

    public int getTcpWindowSize() {
        return this.tcpWindowSize;
    }

    public int getTotalLength() {
        return this.totalLength;
    }

    public int getPayloadLength() {
        return this.payloadLength;
    }

    public int getTcpHandshakeRTT() {
        return this.tcpHandshakeRTT;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public void setIpStart(int ipStart) {
        this.ipStart = ipStart;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void setLen(int len) {
        this.len = len;
    }

    public void setTsMilli(long tsMilli) {
        this.tsMilli = tsMilli;
    }

    public void setIpId(long ipId) {
        this.ipId = ipId;
    }

    public void setTtl(int ttl) {
        this.ttl = ttl;
    }

    public void setIpVersion(int ipVersion) {
        this.ipVersion = ipVersion;
    }

    public void setIpHeaderLen(int ipHeaderLen) {
        this.ipHeaderLen = ipHeaderLen;
    }

    public void setProtocol(byte protocol) {
        this.protocol = protocol;
    }

    public void setSrc(String src) {
        this.src = src;
    }

    public void setDst(String dst) {
        this.dst = dst;
    }

    public void setSrcAddr(InetAddress srcAddr) {
        this.srcAddr = srcAddr;
    }

    public void setDstAddr(InetAddress dstAddr) {
        this.dstAddr = dstAddr;
    }

    public void setFragOffset(long fragOffset) {
        this.fragOffset = fragOffset;
    }

    public void setFragmented(boolean fragmented) {
        this.fragmented = fragmented;
    }

    public void setLastFragment(boolean lastFragment) {
        this.lastFragment = lastFragment;
    }

    public void setDoNotFragment(boolean doNotFragment) {
        this.doNotFragment = doNotFragment;
    }

    public void setReassembledFragments(int reassembledFragments) {
        this.reassembledFragments = reassembledFragments;
    }

    public void setFragmentFlagM(boolean fragmentFlagM) {
        this.fragmentFlagM = fragmentFlagM;
    }

    public void setReassembledTCPFragments(int reassembledTCPFragments) {
        this.reassembledTCPFragments = reassembledTCPFragments;
    }

    public void setSrcPort(int srcPort) {
        this.srcPort = srcPort;
    }

    public void setDstPort(int dstPort) {
        this.dstPort = dstPort;
    }

    public void setTcpflow(int tcpflow) {
        this.tcpflow = tcpflow;
    }

    public void setTcpHeaderLen(int tcpHeaderLen) {
        this.tcpHeaderLen = tcpHeaderLen;
    }

    public void setTcpSeq(long tcpSeq) {
        this.tcpSeq = tcpSeq;
    }

    public void setTcpAck(long tcpAck) {
        this.tcpAck = tcpAck;
    }

    public void setTcpFlagNs(boolean tcpFlagNs) {
        this.tcpFlagNs = tcpFlagNs;
    }

    public void setTcpFlagCwr(boolean tcpFlagCwr) {
        this.tcpFlagCwr = tcpFlagCwr;
    }

    public void setTcpFlagEce(boolean tcpFlagEce) {
        this.tcpFlagEce = tcpFlagEce;
    }

    public void setTcpFlagUrg(boolean tcpFlagUrg) {
        this.tcpFlagUrg = tcpFlagUrg;
    }

    public void setTcpFlagAck(boolean tcpFlagAck) {
        this.tcpFlagAck = tcpFlagAck;
    }

    public void setTcpFlagPsh(boolean tcpFlagPsh) {
        this.tcpFlagPsh = tcpFlagPsh;
    }

    public void setTcpFlagRst(boolean tcpFlagRst) {
        this.tcpFlagRst = tcpFlagRst;
    }

    public void setTcpFlagSyn(boolean tcpFlagSyn) {
        this.tcpFlagSyn = tcpFlagSyn;
    }

    public void setTcpFlagFin(boolean tcpFlagFin) {
        this.tcpFlagFin = tcpFlagFin;
    }

    public void setTcpWindowSize(int tcpWindowSize) {
        this.tcpWindowSize = tcpWindowSize;
    }

    public void setTotalLength(int totalLength) {
        this.totalLength = totalLength;
    }

    public void setPayloadLength(int payloadLength) {
        this.payloadLength = payloadLength;
    }

    public void setTcpHandshakeRTT(int tcpHandshakeRTT) {
        this.tcpHandshakeRTT = tcpHandshakeRTT;
    }

    public void setFlow(TCPFlow flow) {
        this.flow = flow;
    }

    public void setReverseFlow(TCPFlow reverseFlow) {
        this.reverseFlow = reverseFlow;
    }
}

