/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.pcap.packet;

import com.google.common.collect.ComparisonChain;
import nl.sidnlabs.pcap.decoder.ChainBuffer;
import nl.sidnlabs.pcap.packet.TCPFlow;

public class SequencePayload
implements Comparable<SequencePayload> {
    private long seq;
    private byte[] bytes;
    private ChainBuffer buffer;
    private long time;
    private long nextSequence;

    public SequencePayload() {
    }

    public SequencePayload(long seq, byte[] bytes, long time, TCPFlow flow) {
        this.seq = seq;
        this.bytes = bytes;
        this.time = time;
        this.nextSequence = seq + (long)bytes.length;
    }

    public boolean hasBuffer() {
        return this.buffer != null;
    }

    public int size() {
        if (this.hasBuffer()) {
            return this.buffer.readableBytes();
        }
        return this.bytes.length;
    }

    @Override
    public int compareTo(SequencePayload o) {
        return ComparisonChain.start().compare(this.seq, o.seq).result();
    }

    public boolean linked(SequencePayload o) {
        if (this.nextSequence == o.seq) {
            return true;
        }
        return o.getNextSequence() == this.seq;
    }

    public String toString() {
        return "SequencePayload [seq=" + this.seq + ", time=" + this.time + ", nextSequence=" + this.nextSequence + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.nextSequence ^ this.nextSequence >>> 32);
        result = 31 * result + (int)(this.seq ^ this.seq >>> 32);
        result = 31 * result + (int)(this.time ^ this.time >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SequencePayload other = (SequencePayload)obj;
        if (this.nextSequence != other.nextSequence) {
            return false;
        }
        if (this.seq != other.seq) {
            return false;
        }
        return this.time == other.time;
    }

    public long getSeq() {
        return this.seq;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public ChainBuffer getBuffer() {
        return this.buffer;
    }

    public long getTime() {
        return this.time;
    }

    public long getNextSequence() {
        return this.nextSequence;
    }

    public void setSeq(long seq) {
        this.seq = seq;
    }

    public void setBytes(byte[] bytes) {
        this.bytes = bytes;
    }

    public void setBuffer(ChainBuffer buffer) {
        this.buffer = buffer;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public void setNextSequence(long nextSequence) {
        this.nextSequence = nextSequence;
    }
}

