/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.pcap;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import lombok.Generated;
import nl.sidnlabs.pcap.PcapReaderUtil;
import nl.sidnlabs.pcap.decoder.DNSDecoder;
import nl.sidnlabs.pcap.decoder.ICMPDecoder;
import nl.sidnlabs.pcap.decoder.IPDecoder;
import nl.sidnlabs.pcap.decoder.TCPDecoder;
import nl.sidnlabs.pcap.decoder.UDPDecoder;
import nl.sidnlabs.pcap.packet.FlowData;
import nl.sidnlabs.pcap.packet.Packet;
import nl.sidnlabs.pcap.packet.TCPFlow;
import org.apache.commons.codec.binary.Hex;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PcapReader {
    @Generated
    private static final Logger log = LogManager.getLogger(PcapReader.class);
    public static final int DNS_PORT = 53;
    public static final long MAGIC_NUMBER = -1582119980L;
    public static final int HEADER_SIZE = 24;
    public static final int PCAP_HEADER_LINKTYPE_OFFSET = 20;
    public static final int PACKET_HEADER_SIZE = 16;
    public static final int TIMESTAMP_OFFSET = 0;
    public static final int TIMESTAMP_MICROS_OFFSET = 4;
    public static final int CAP_LEN_OFFSET = 8;
    public static final int ETHERNET_HEADER_SIZE = 14;
    public static final int ETHERNET_TYPE_OFFSET = 12;
    public static final int ETHERNET_TYPE_IP = 2048;
    public static final int ETHERNET_TYPE_IPV6 = 34525;
    public static final int ETHERNET_TYPE_8021Q = 33024;
    public static final int SLL_HEADER_SIZE = 16;
    public static final int SLL_V2_HEADER_SIZE = 20;
    public static final int PROTOCOL_FRAGMENTED = -1;
    private DataInputStream is;
    private LinkType linkType;
    private boolean caughtEOF = false;
    private boolean reverseHeaderByteOrder = false;
    private IPDecoder ipDecoder = null;
    private boolean partial;

    public PcapReader(DataInputStream is, IPDecoder ipDecoder, boolean tcpEnabled, boolean partial) throws IOException {
        this.is = is;
        this.partial = partial;
        if (ipDecoder != null) {
            this.ipDecoder = ipDecoder;
        } else {
            DNSDecoder dnsDecoder = new DNSDecoder(false, partial);
            TCPDecoder tcpDecoder = null;
            if (tcpEnabled) {
                tcpDecoder = new TCPDecoder(dnsDecoder);
            }
            this.ipDecoder = new IPDecoder(tcpDecoder, new UDPDecoder(dnsDecoder), new ICMPDecoder());
        }
        byte[] pcapHeader = new byte[24];
        if (!this.readBytes(pcapHeader)) {
            if (this.caughtEOF) {
                log.warn("Skipping empty file");
                return;
            }
            throw new IOException("Couldn't read PCAP header");
        }
        if (!this.validateMagicNumber(pcapHeader)) {
            throw new IOException("Not a PCAP file (Couldn't find magic number)");
        }
        this.linkType = this.getLinkType(PcapReaderUtil.convertInt(pcapHeader, 20, this.reverseHeaderByteOrder));
        if (this.linkType == null) {
            throw new IOException("Unsupported link type");
        }
    }

    public Stream<Packet> stream() {
        Iterable valueIterable = () -> new PacketIterator();
        return StreamSupport.stream(valueIterable.spliterator(), false);
    }

    public Iterable<Packet> iter() {
        return () -> new PacketIterator();
    }

    private Packet nextPacket() {
        byte[] pcapPacketHeader = new byte[16];
        if (!this.readBytes(pcapPacketHeader)) {
            log.debug("Reached end of file, or zero-length file?");
            return null;
        }
        long packetSize = PcapReaderUtil.convertInt(pcapPacketHeader, 8, this.reverseHeaderByteOrder);
        byte[] packetData = new byte[(int)packetSize];
        if (!this.readBytes(packetData)) {
            return Packet.NULL;
        }
        int ipStart = this.findIPStart(packetData);
        if (ipStart == -1) {
            if (log.isDebugEnabled()) {
                log.debug("Invalid IP packet: {}", (Object)Hex.encodeHexString((byte[])packetData));
            }
            return Packet.NULL;
        }
        long packetTimestampSecs = PcapReaderUtil.convertInt(pcapPacketHeader, 0, this.reverseHeaderByteOrder);
        long packetTimestampMicros = PcapReaderUtil.convertInt(pcapPacketHeader, 4, this.reverseHeaderByteOrder);
        Packet decodedPacket = this.ipDecoder.decode(packetData, ipStart, packetTimestampSecs, packetTimestampMicros, this.partial);
        return decodedPacket;
    }

    protected boolean validateMagicNumber(byte[] pcapHeader) {
        if (PcapReaderUtil.convertInt(pcapHeader) == -1582119980L) {
            return true;
        }
        if (PcapReaderUtil.convertInt(pcapHeader, true) == -1582119980L) {
            this.reverseHeaderByteOrder = true;
            return true;
        }
        return false;
    }

    protected LinkType getLinkType(long linkTypeVal) {
        switch ((int)linkTypeVal) {
            case 0: {
                return LinkType.NULL;
            }
            case 1: {
                return LinkType.EN10MB;
            }
            case 101: {
                return LinkType.RAW;
            }
            case 108: {
                return LinkType.LOOP;
            }
            case 113: {
                return LinkType.LINUX_SLL;
            }
            case 276: {
                return LinkType.LINUX_SLL_V2;
            }
        }
        log.error("Unknown PCAP Linklayer type: " + linkTypeVal);
        return null;
    }

    protected int findIPStart(byte[] packet) {
        int start = -1;
        switch (this.linkType.ordinal()) {
            case 0: {
                return 4;
            }
            case 1: {
                start = 14;
                int etherType = PcapReaderUtil.convertShort(packet, 12);
                if (etherType == 33024) {
                    etherType = PcapReaderUtil.convertShort(packet, 16);
                    start += 4;
                }
                if (etherType != 2048 && etherType != 34525) break;
                return start;
            }
            case 2: {
                return 0;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 16;
            }
            case 5: {
                return 20;
            }
        }
        return -1;
    }

    protected boolean readBytes(byte[] buf) {
        try {
            if (this.is.read(buf, 0, buf.length) < buf.length) {
                return false;
            }
        }
        catch (EOFException e) {
            this.caughtEOF = true;
            return false;
        }
        catch (IOException e) {
            log.error("Error while reading " + buf.length + " bytes from buffer");
            return false;
        }
        return true;
    }

    public void setTcpFlows(Map<TCPFlow, FlowData> flows) {
        if (this.ipDecoder.getTcpReader() != null && this.ipDecoder.getTcpReader() instanceof TCPDecoder) {
            ((TCPDecoder)this.ipDecoder.getTcpReader()).setFlows(flows);
        }
    }

    protected static enum LinkType {
        NULL,
        EN10MB,
        RAW,
        LOOP,
        LINUX_SLL,
        LINUX_SLL_V2;

    }

    private class PacketIterator
    implements Iterator<Packet> {
        private Packet next;

        private PacketIterator() {
        }

        private void fetchNext() {
            if (this.next == null) {
                do {
                    try {
                        this.next = PcapReader.this.nextPacket();
                    }
                    catch (Exception e) {
                        log.error("PCAP decode error: ", (Throwable)e);
                        this.next = Packet.NULL;
                    }
                } while (this.next == Packet.NULL);
            }
        }

        @Override
        public boolean hasNext() {
            this.fetchNext();
            return this.next != null;
        }

        @Override
        public Packet next() {
            this.fetchNext();
            if (this.next == null) {
                throw new NoSuchElementException("No more packets to decode");
            }
            try {
                Packet packet = this.next;
                return packet;
            }
            finally {
                this.next = null;
            }
        }

        @Override
        public void remove() {
        }
    }
}

