/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.pcap.packet;

import java.net.InetAddress;
import lombok.Generated;
import nl.sidnlabs.pcap.packet.Datagram;
import nl.sidnlabs.pcap.packet.TCPFlow;

public class Packet {
    public static final Packet NULL = new Packet();
    private byte[] data;
    private int ipStart;
    protected int len;
    protected long tsMilli;
    protected long ipId;
    protected int ttl;
    protected int ipVersion;
    protected int ipHeaderLen;
    protected byte protocol;
    protected String src;
    protected String dst;
    protected InetAddress srcAddr;
    protected InetAddress dstAddr;
    protected long fragOffset;
    protected boolean fragmented;
    protected boolean lastFragment;
    protected boolean doNotFragment;
    protected int reassembledFragments;
    protected boolean fragmentFlagM;
    protected int reassembledTCPFragments;
    protected int srcPort;
    protected int dstPort;
    protected int tcpflow;
    protected int tcpHeaderLen;
    protected long tcpSeq;
    protected long tcpAck;
    protected boolean tcpFlagNs;
    protected boolean tcpFlagCwr;
    protected boolean tcpFlagEce;
    protected boolean tcpFlagUrg;
    protected boolean tcpFlagAck;
    protected boolean tcpFlagPsh;
    protected boolean tcpFlagRst;
    protected boolean tcpFlagSyn;
    protected boolean tcpFlagFin;
    protected int tcpWindowSize;
    private int totalLength;
    protected int payloadLength;
    protected int tcpHandshakeRTT = -1;
    private TCPFlow flow;
    private TCPFlow reverseFlow;

    public Packet() {
    }

    public Packet(byte protocol) {
        this.protocol = protocol;
    }

    public TCPFlow getFlow() {
        if (this.flow == null) {
            this.flow = new TCPFlow(this.src, this.srcPort, this.dst, this.dstPort, this.protocol);
        }
        return this.flow;
    }

    public TCPFlow getReverseFlow() {
        if (this.reverseFlow == null) {
            this.reverseFlow = new TCPFlow(this.dst, this.dstPort, this.src, this.srcPort, this.protocol);
        }
        return this.reverseFlow;
    }

    public Datagram getDatagram() {
        return new Datagram(this.getSrc(), this.getDst(), this.getIpId(), String.valueOf(this.getProtocol()), this.getTsMilli());
    }

    public boolean isIPv4() {
        return this.getIpVersion() == 4;
    }

    public boolean isIPv6() {
        return this.getIpVersion() == 6;
    }

    public long nextAck() {
        return this.tcpSeq + (long)this.payloadLength;
    }

    @Generated
    public byte[] getData() {
        return this.data;
    }

    @Generated
    public int getIpStart() {
        return this.ipStart;
    }

    @Generated
    public int getLen() {
        return this.len;
    }

    @Generated
    public long getTsMilli() {
        return this.tsMilli;
    }

    @Generated
    public long getIpId() {
        return this.ipId;
    }

    @Generated
    public int getTtl() {
        return this.ttl;
    }

    @Generated
    public int getIpVersion() {
        return this.ipVersion;
    }

    @Generated
    public int getIpHeaderLen() {
        return this.ipHeaderLen;
    }

    @Generated
    public byte getProtocol() {
        return this.protocol;
    }

    @Generated
    public String getSrc() {
        return this.src;
    }

    @Generated
    public String getDst() {
        return this.dst;
    }

    @Generated
    public InetAddress getSrcAddr() {
        return this.srcAddr;
    }

    @Generated
    public InetAddress getDstAddr() {
        return this.dstAddr;
    }

    @Generated
    public long getFragOffset() {
        return this.fragOffset;
    }

    @Generated
    public boolean isFragmented() {
        return this.fragmented;
    }

    @Generated
    public boolean isLastFragment() {
        return this.lastFragment;
    }

    @Generated
    public boolean isDoNotFragment() {
        return this.doNotFragment;
    }

    @Generated
    public int getReassembledFragments() {
        return this.reassembledFragments;
    }

    @Generated
    public boolean isFragmentFlagM() {
        return this.fragmentFlagM;
    }

    @Generated
    public int getReassembledTCPFragments() {
        return this.reassembledTCPFragments;
    }

    @Generated
    public int getSrcPort() {
        return this.srcPort;
    }

    @Generated
    public int getDstPort() {
        return this.dstPort;
    }

    @Generated
    public int getTcpflow() {
        return this.tcpflow;
    }

    @Generated
    public int getTcpHeaderLen() {
        return this.tcpHeaderLen;
    }

    @Generated
    public long getTcpSeq() {
        return this.tcpSeq;
    }

    @Generated
    public long getTcpAck() {
        return this.tcpAck;
    }

    @Generated
    public boolean isTcpFlagNs() {
        return this.tcpFlagNs;
    }

    @Generated
    public boolean isTcpFlagCwr() {
        return this.tcpFlagCwr;
    }

    @Generated
    public boolean isTcpFlagEce() {
        return this.tcpFlagEce;
    }

    @Generated
    public boolean isTcpFlagUrg() {
        return this.tcpFlagUrg;
    }

    @Generated
    public boolean isTcpFlagAck() {
        return this.tcpFlagAck;
    }

    @Generated
    public boolean isTcpFlagPsh() {
        return this.tcpFlagPsh;
    }

    @Generated
    public boolean isTcpFlagRst() {
        return this.tcpFlagRst;
    }

    @Generated
    public boolean isTcpFlagSyn() {
        return this.tcpFlagSyn;
    }

    @Generated
    public boolean isTcpFlagFin() {
        return this.tcpFlagFin;
    }

    @Generated
    public int getTcpWindowSize() {
        return this.tcpWindowSize;
    }

    @Generated
    public int getTotalLength() {
        return this.totalLength;
    }

    @Generated
    public int getPayloadLength() {
        return this.payloadLength;
    }

    @Generated
    public int getTcpHandshakeRTT() {
        return this.tcpHandshakeRTT;
    }

    @Generated
    public void setData(byte[] data) {
        this.data = data;
    }

    @Generated
    public void setIpStart(int ipStart) {
        this.ipStart = ipStart;
    }

    @Generated
    public void setLen(int len) {
        this.len = len;
    }

    @Generated
    public void setTsMilli(long tsMilli) {
        this.tsMilli = tsMilli;
    }

    @Generated
    public void setIpId(long ipId) {
        this.ipId = ipId;
    }

    @Generated
    public void setTtl(int ttl) {
        this.ttl = ttl;
    }

    @Generated
    public void setIpVersion(int ipVersion) {
        this.ipVersion = ipVersion;
    }

    @Generated
    public void setIpHeaderLen(int ipHeaderLen) {
        this.ipHeaderLen = ipHeaderLen;
    }

    @Generated
    public void setProtocol(byte protocol) {
        this.protocol = protocol;
    }

    @Generated
    public void setSrc(String src) {
        this.src = src;
    }

    @Generated
    public void setDst(String dst) {
        this.dst = dst;
    }

    @Generated
    public void setSrcAddr(InetAddress srcAddr) {
        this.srcAddr = srcAddr;
    }

    @Generated
    public void setDstAddr(InetAddress dstAddr) {
        this.dstAddr = dstAddr;
    }

    @Generated
    public void setFragOffset(long fragOffset) {
        this.fragOffset = fragOffset;
    }

    @Generated
    public void setFragmented(boolean fragmented) {
        this.fragmented = fragmented;
    }

    @Generated
    public void setLastFragment(boolean lastFragment) {
        this.lastFragment = lastFragment;
    }

    @Generated
    public void setDoNotFragment(boolean doNotFragment) {
        this.doNotFragment = doNotFragment;
    }

    @Generated
    public void setReassembledFragments(int reassembledFragments) {
        this.reassembledFragments = reassembledFragments;
    }

    @Generated
    public void setFragmentFlagM(boolean fragmentFlagM) {
        this.fragmentFlagM = fragmentFlagM;
    }

    @Generated
    public void setReassembledTCPFragments(int reassembledTCPFragments) {
        this.reassembledTCPFragments = reassembledTCPFragments;
    }

    @Generated
    public void setSrcPort(int srcPort) {
        this.srcPort = srcPort;
    }

    @Generated
    public void setDstPort(int dstPort) {
        this.dstPort = dstPort;
    }

    @Generated
    public void setTcpflow(int tcpflow) {
        this.tcpflow = tcpflow;
    }

    @Generated
    public void setTcpHeaderLen(int tcpHeaderLen) {
        this.tcpHeaderLen = tcpHeaderLen;
    }

    @Generated
    public void setTcpSeq(long tcpSeq) {
        this.tcpSeq = tcpSeq;
    }

    @Generated
    public void setTcpAck(long tcpAck) {
        this.tcpAck = tcpAck;
    }

    @Generated
    public void setTcpFlagNs(boolean tcpFlagNs) {
        this.tcpFlagNs = tcpFlagNs;
    }

    @Generated
    public void setTcpFlagCwr(boolean tcpFlagCwr) {
        this.tcpFlagCwr = tcpFlagCwr;
    }

    @Generated
    public void setTcpFlagEce(boolean tcpFlagEce) {
        this.tcpFlagEce = tcpFlagEce;
    }

    @Generated
    public void setTcpFlagUrg(boolean tcpFlagUrg) {
        this.tcpFlagUrg = tcpFlagUrg;
    }

    @Generated
    public void setTcpFlagAck(boolean tcpFlagAck) {
        this.tcpFlagAck = tcpFlagAck;
    }

    @Generated
    public void setTcpFlagPsh(boolean tcpFlagPsh) {
        this.tcpFlagPsh = tcpFlagPsh;
    }

    @Generated
    public void setTcpFlagRst(boolean tcpFlagRst) {
        this.tcpFlagRst = tcpFlagRst;
    }

    @Generated
    public void setTcpFlagSyn(boolean tcpFlagSyn) {
        this.tcpFlagSyn = tcpFlagSyn;
    }

    @Generated
    public void setTcpFlagFin(boolean tcpFlagFin) {
        this.tcpFlagFin = tcpFlagFin;
    }

    @Generated
    public void setTcpWindowSize(int tcpWindowSize) {
        this.tcpWindowSize = tcpWindowSize;
    }

    @Generated
    public void setTotalLength(int totalLength) {
        this.totalLength = totalLength;
    }

    @Generated
    public void setPayloadLength(int payloadLength) {
        this.payloadLength = payloadLength;
    }

    @Generated
    public void setTcpHandshakeRTT(int tcpHandshakeRTT) {
        this.tcpHandshakeRTT = tcpHandshakeRTT;
    }

    @Generated
    public void setFlow(TCPFlow flow) {
        this.flow = flow;
    }

    @Generated
    public void setReverseFlow(TCPFlow reverseFlow) {
        this.reverseFlow = reverseFlow;
    }
}

