/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.pcap.packet;

import lombok.Generated;

public class TcpHandshake {
    private HANDSHAKE_STATE state;
    private long synTs;
    private long ackTs;
    private long clientSynSeq;
    private long serverSynSeq;
    private long serverAckSeq;
    private long clientAckSeq;

    public TcpHandshake(long clientSynSeq) {
        this.state = HANDSHAKE_STATE.SYN_RECV;
        this.clientSynSeq = clientSynSeq;
    }

    public int rtt() {
        return (int)(this.ackTs - this.synTs);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.ackTs ^ this.ackTs >>> 32);
        result = 31 * result + (int)(this.clientAckSeq ^ this.clientAckSeq >>> 32);
        result = 31 * result + (int)(this.clientSynSeq ^ this.clientSynSeq >>> 32);
        result = 31 * result + (int)(this.serverAckSeq ^ this.serverAckSeq >>> 32);
        result = 31 * result + (int)(this.serverSynSeq ^ this.serverSynSeq >>> 32);
        result = 31 * result + (this.state == null ? 0 : this.state.hashCode());
        result = 31 * result + (int)(this.synTs ^ this.synTs >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TcpHandshake other = (TcpHandshake)obj;
        if (this.ackTs != other.ackTs) {
            return false;
        }
        if (this.clientAckSeq != other.clientAckSeq) {
            return false;
        }
        if (this.clientSynSeq != other.clientSynSeq) {
            return false;
        }
        if (this.serverAckSeq != other.serverAckSeq) {
            return false;
        }
        if (this.serverSynSeq != other.serverSynSeq) {
            return false;
        }
        if (this.state != other.state) {
            return false;
        }
        return this.synTs == other.synTs;
    }

    @Generated
    public TcpHandshake() {
    }

    @Generated
    public HANDSHAKE_STATE getState() {
        return this.state;
    }

    @Generated
    public long getSynTs() {
        return this.synTs;
    }

    @Generated
    public long getAckTs() {
        return this.ackTs;
    }

    @Generated
    public long getClientSynSeq() {
        return this.clientSynSeq;
    }

    @Generated
    public long getServerSynSeq() {
        return this.serverSynSeq;
    }

    @Generated
    public long getServerAckSeq() {
        return this.serverAckSeq;
    }

    @Generated
    public long getClientAckSeq() {
        return this.clientAckSeq;
    }

    @Generated
    public void setState(HANDSHAKE_STATE state) {
        this.state = state;
    }

    @Generated
    public void setSynTs(long synTs) {
        this.synTs = synTs;
    }

    @Generated
    public void setAckTs(long ackTs) {
        this.ackTs = ackTs;
    }

    @Generated
    public void setClientSynSeq(long clientSynSeq) {
        this.clientSynSeq = clientSynSeq;
    }

    @Generated
    public void setServerSynSeq(long serverSynSeq) {
        this.serverSynSeq = serverSynSeq;
    }

    @Generated
    public void setServerAckSeq(long serverAckSeq) {
        this.serverAckSeq = serverAckSeq;
    }

    @Generated
    public void setClientAckSeq(long clientAckSeq) {
        this.clientAckSeq = clientAckSeq;
    }

    public static enum HANDSHAKE_STATE {
        SYN_RECV,
        SYN_ACK_SENT,
        ACK_RECV;

    }
}

