/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.pcap.decoder;

import lombok.Generated;
import nl.sidnlabs.dnslib.message.Message;
import nl.sidnlabs.dnslib.message.util.NetworkData;
import nl.sidnlabs.pcap.packet.DNSPacket;
import nl.sidnlabs.pcap.packet.Packet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DNSDecoder {
    @Generated
    private static final Logger log = LogManager.getLogger(DNSDecoder.class);
    private boolean allowFail;
    private boolean partial;
    private int messageDecodeError;
    private int messageCounter;
    private NetworkData networkData;

    public DNSDecoder(boolean allowFail) {
        this(allowFail, false);
    }

    public DNSDecoder(boolean allowFail, boolean partial) {
        this.allowFail = allowFail;
        this.partial = partial;
    }

    public Packet decode(Packet packet, byte[] payload, int offset, int length) {
        block5: {
            DNSPacket dnsPacket = (DNSPacket)packet;
            try {
                if (this.networkData == null) {
                    this.networkData = new NetworkData(payload, offset, length);
                } else {
                    this.networkData.update(payload, offset, length);
                }
                dnsPacket.pushMessage(new Message(this.networkData, this.partial, this.allowFail));
                ++this.messageCounter;
            }
            catch (Exception e) {
                if (this.allowFail) break block5;
                if (log.isDebugEnabled()) {
                    log.debug("Error decoding, maybe corrupt packet? " + String.valueOf(dnsPacket), (Throwable)e);
                }
                ++this.messageDecodeError;
            }
        }
        return packet;
    }

    public void reset() {
        this.messageDecodeError = 0;
        this.messageCounter = 0;
    }

    public void printStats() {
        log.info("---------------- DNS decoder stats -----------------------");
        log.info("Messages: {}", (Object)this.messageCounter);
        log.info("Errors: {}", (Object)this.messageDecodeError);
    }

    @Generated
    public boolean isAllowFail() {
        return this.allowFail;
    }

    @Generated
    public boolean isPartial() {
        return this.partial;
    }

    @Generated
    public int getMessageDecodeError() {
        return this.messageDecodeError;
    }

    @Generated
    public int getMessageCounter() {
        return this.messageCounter;
    }

    @Generated
    public NetworkData getNetworkData() {
        return this.networkData;
    }

    @Generated
    public void setAllowFail(boolean allowFail) {
        this.allowFail = allowFail;
    }

    @Generated
    public void setPartial(boolean partial) {
        this.partial = partial;
    }

    @Generated
    public void setMessageDecodeError(int messageDecodeError) {
        this.messageDecodeError = messageDecodeError;
    }

    @Generated
    public void setMessageCounter(int messageCounter) {
        this.messageCounter = messageCounter;
    }

    @Generated
    public void setNetworkData(NetworkData networkData) {
        this.networkData = networkData;
    }
}

