/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.pcap.decoder;

import nl.sidnlabs.dnslib.message.Message;
import nl.sidnlabs.dnslib.message.util.NetworkData;
import nl.sidnlabs.pcap.packet.DNSPacket;
import nl.sidnlabs.pcap.packet.Packet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DNSDecoder {
    private static final Logger log = LogManager.getLogger(DNSDecoder.class);
    private boolean allowFail;
    private int dnsDecodeError;
    private int messageCounter;

    public DNSDecoder(boolean allowFail) {
        this.allowFail = allowFail;
    }

    public Packet decode(Packet packet, byte[] payload) {
        block3: {
            DNSPacket dnsPacket = (DNSPacket)packet;
            try {
                dnsPacket.pushMessage(new Message(new NetworkData(payload), true, this.allowFail));
                ++this.messageCounter;
            }
            catch (Exception e) {
                if (this.allowFail) break block3;
                if (log.isDebugEnabled()) {
                    log.debug("Error decoding, maybe corrupt packet? " + dnsPacket, (Throwable)e);
                }
                ++this.dnsDecodeError;
            }
        }
        return packet;
    }

    public void reset() {
        this.dnsDecodeError = 0;
        this.messageCounter = 0;
    }

    public boolean isAllowFail() {
        return this.allowFail;
    }

    public int getDnsDecodeError() {
        return this.dnsDecodeError;
    }

    public int getMessageCounter() {
        return this.messageCounter;
    }

    public void setAllowFail(boolean allowFail) {
        this.allowFail = allowFail;
    }

    public void setDnsDecodeError(int dnsDecodeError) {
        this.dnsDecodeError = dnsDecodeError;
    }

    public void setMessageCounter(int messageCounter) {
        this.messageCounter = messageCounter;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DNSDecoder)) {
            return false;
        }
        DNSDecoder other = (DNSDecoder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isAllowFail() != other.isAllowFail()) {
            return false;
        }
        if (this.getDnsDecodeError() != other.getDnsDecodeError()) {
            return false;
        }
        return this.getMessageCounter() == other.getMessageCounter();
    }

    protected boolean canEqual(Object other) {
        return other instanceof DNSDecoder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAllowFail() ? 79 : 97);
        result = result * 59 + this.getDnsDecodeError();
        result = result * 59 + this.getMessageCounter();
        return result;
    }

    public String toString() {
        return "DNSDecoder(allowFail=" + this.isAllowFail() + ", dnsDecodeError=" + this.getDnsDecodeError() + ", messageCounter=" + this.getMessageCounter() + ")";
    }
}

