/*
 * Decompiled with CFR 0.152.
 */
package nl.stokpop.scheduler;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import nl.stokpop.eventscheduler.EventScheduler;
import nl.stokpop.eventscheduler.EventSchedulerBuilder;
import nl.stokpop.eventscheduler.api.EventLogger;
import nl.stokpop.eventscheduler.api.EventSchedulerSettings;
import nl.stokpop.eventscheduler.api.EventSchedulerSettingsBuilder;
import nl.stokpop.eventscheduler.api.SchedulerExceptionHandler;
import nl.stokpop.eventscheduler.api.SchedulerExceptionType;
import nl.stokpop.eventscheduler.api.TestContext;
import nl.stokpop.eventscheduler.api.TestContextBuilder;
import nl.stokpop.eventscheduler.exception.EventCheckFailureException;
import nl.stokpop.eventscheduler.exception.handler.KillSwitchException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="test", defaultPhase=LifecyclePhase.INTEGRATION_TEST, requiresDependencyResolution=ResolutionScope.TEST)
public class EventSchedulerMojo
extends AbstractMojo {
    private final Object eventSchedulerLock = new Object();
    private EventScheduler eventScheduler;
    @Parameter(defaultValue="true")
    private boolean failOnError;
    @Parameter(defaultValue="true")
    private boolean continueOnAssertionFailure;
    @Parameter(defaultValue="true")
    private boolean eventSchedulerEnabled;
    @Parameter
    private Map<String, Properties> events;
    @Parameter
    private String eventScheduleScript;
    @Parameter(defaultValue="UNKNOWN_SYSTEM_UNDER_TEST")
    private String eventSystemUnderTest;
    @Parameter(defaultValue="UNKNOWN_WORKLOAD")
    private String eventWorkload;
    @Parameter(defaultValue="UNKNOWN_TEST_ENVIRONMENT")
    private String eventTestEnvironment;
    @Parameter(defaultValue="ANONYMOUS_PRODUCT")
    private String eventProductName;
    @Parameter(defaultValue="ANONYMOUS_DASHBOARD")
    private String eventDashboardName;
    @Parameter(defaultValue="ANONYMOUS_TEST_ID")
    private String eventTestRunId;
    @Parameter
    private String eventBuildResultsUrl;
    @Parameter(defaultValue="1.0.0-SNAPSHOT")
    private String eventVersion;
    @Parameter(defaultValue="30")
    private String eventRampupTimeInSeconds;
    @Parameter(defaultValue="570")
    private String eventConstantLoadTimeInSeconds;
    @Parameter
    private String eventAnnotations;
    @Parameter
    private Properties eventVariables;
    @Parameter
    private List<String> eventTags;
    @Parameter
    private boolean eventDebugEnabled;
    @Parameter(defaultValue="30")
    private Integer eventKeepAliveIntervalInSeconds;
    private volatile SchedulerExceptionType schedulerExceptionType = SchedulerExceptionType.NONE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        this.getLog().info((CharSequence)"Execute event-scheduler-maven-plugin");
        if (!this.eventSchedulerEnabled) {
            this.getLog().info((CharSequence)"EventScheduler is disabled.");
            return;
        }
        boolean abortEventScheduler = false;
        this.eventScheduler = this.createEventScheduler();
        try {
            SchedulerExceptionHandler schedulerExceptionHandler = new SchedulerExceptionHandler(){

                public void kill(String message) {
                    EventSchedulerMojo.this.getLog().info((CharSequence)("Killing running process, message: " + message));
                    EventSchedulerMojo.this.schedulerExceptionType = SchedulerExceptionType.KILL;
                }

                public void abort(String message) {
                    EventSchedulerMojo.this.getLog().info((CharSequence)("Killing running process, message: " + message));
                    EventSchedulerMojo.this.schedulerExceptionType = SchedulerExceptionType.ABORT;
                }
            };
            this.startScheduler(this.eventScheduler, schedulerExceptionHandler);
            int rampupInSeconds = Integer.parseInt(this.eventRampupTimeInSeconds);
            int constantLoadInSeconds = Integer.parseInt(this.eventConstantLoadTimeInSeconds);
            int durationInSeconds = rampupInSeconds + constantLoadInSeconds;
            Duration duration = Duration.ofSeconds(durationInSeconds);
            this.getLog().info((CharSequence)("event-scheduler-maven-plugin will now wait for " + duration));
            Thread.sleep(duration.toMillis());
            this.eventScheduler.stopSession();
        }
        catch (Exception e) {
            this.getLog().warn((CharSequence)("Inside catch exception: " + e));
            if (!(e instanceof KillSwitchException)) {
                if (this.failOnError) {
                    this.getLog().debug((CharSequence)">>> Fail on error is enabled (true), setting abortEventScheduler to true.");
                    abortEventScheduler = true;
                } else {
                    this.getLog().warn((CharSequence)"There were some errors, but failOnError was set to false: build will not fail.");
                }
            } else {
                this.getLog().warn((CharSequence)"KillSwitchException found.");
            }
        }
        finally {
            if (this.eventScheduler != null) {
                Object e = this.eventSchedulerLock;
                synchronized (e) {
                    if (abortEventScheduler && !this.eventScheduler.isSessionStopped()) {
                        this.getLog().debug((CharSequence)">>> Abort is called in finally: abortEventScheduler is true");
                        this.eventScheduler.abortSession();
                    } else {
                        this.getLog().debug((CharSequence)(">>> No abort called: abort event scheduler is " + abortEventScheduler + ", stop is already called is " + this.eventScheduler.isSessionStopped()));
                    }
                }
            }
        }
        if (this.eventScheduler != null && !this.eventScheduler.isSessionStopped()) {
            this.getLog().debug((CharSequence)">>> Stop session (because not isSessionStopped())");
            this.eventScheduler.stopSession();
            try {
                this.getLog().debug((CharSequence)">>> Call check results");
                this.eventScheduler.checkResults();
            }
            catch (EventCheckFailureException e) {
                this.getLog().debug((CharSequence)(">>> EventCheckFailureException: " + e.getMessage()));
                if (!this.continueOnAssertionFailure) {
                    throw e;
                }
                this.getLog().warn((CharSequence)("EventCheck failures found, but continue on assert failure is enabled:" + e.getMessage()));
            }
        }
    }

    private void startScheduler(EventScheduler eventScheduler, SchedulerExceptionHandler schedulerExceptionHandler) {
        eventScheduler.addKillSwitch(schedulerExceptionHandler);
        eventScheduler.startSession();
        this.addShutdownHookForEventScheduler(eventScheduler);
    }

    private void addShutdownHookForEventScheduler(EventScheduler eventScheduler) {
        Thread main = Thread.currentThread();
        Runnable shutdowner = () -> {
            EventScheduler eventScheduler2 = eventScheduler;
            synchronized (eventScheduler2) {
                if (!eventScheduler.isSessionStopped()) {
                    this.getLog().info((CharSequence)"Shutdown Hook: abort event scheduler session!");
                    eventScheduler.abortSession();
                }
            }
            try {
                main.join(4000L);
            }
            catch (InterruptedException e) {
                this.getLog().warn((CharSequence)"Interrupt while waiting for abort to finish.");
            }
        };
        Thread eventSchedulerShutdownThread = new Thread(shutdowner, "eventSchedulerShutdownThread");
        Runtime.getRuntime().addShutdownHook(eventSchedulerShutdownThread);
    }

    private EventScheduler createEventScheduler() {
        EventLogger logger = new EventLogger(){

            public void info(String message) {
                EventSchedulerMojo.this.getLog().info((CharSequence)message);
            }

            public void warn(String message) {
                EventSchedulerMojo.this.getLog().warn((CharSequence)message);
            }

            public void error(String message) {
                EventSchedulerMojo.this.getLog().error((CharSequence)message);
            }

            public void error(String message, Throwable throwable) {
                EventSchedulerMojo.this.getLog().error((CharSequence)message, throwable);
            }

            public void debug(String message) {
                if (this.isDebugEnabled()) {
                    EventSchedulerMojo.this.getLog().debug((CharSequence)message);
                }
            }

            public boolean isDebugEnabled() {
                return EventSchedulerMojo.this.eventDebugEnabled;
            }
        };
        List filteredEventTags = this.eventTags.stream().filter(Objects::nonNull).collect(Collectors.toList());
        TestContext testContext = new TestContextBuilder().setTestRunId(this.eventTestRunId).setSystemUnderTest(this.eventSystemUnderTest).setVersion(this.eventVersion).setWorkload(this.eventWorkload).setTestEnvironment(this.eventTestEnvironment).setCIBuildResultsUrl(this.eventBuildResultsUrl).setRampupTimeInSeconds(this.eventRampupTimeInSeconds).setConstantLoadTimeInSeconds(this.eventConstantLoadTimeInSeconds).setAnnotations(this.eventAnnotations).setTags(filteredEventTags).setVariables(this.eventVariables).build();
        EventSchedulerSettings settings = new EventSchedulerSettingsBuilder().setKeepAliveInterval(Duration.ofSeconds(this.eventKeepAliveIntervalInSeconds.intValue())).build();
        EventSchedulerBuilder eventSchedulerBuilder = new EventSchedulerBuilder().setEventSchedulerSettings(settings).setTestContext(testContext).setAssertResultsEnabled(this.eventSchedulerEnabled).setCustomEvents(this.eventScheduleScript).setLogger(logger);
        if (this.events != null) {
            this.events.forEach((arg_0, arg_1) -> ((EventSchedulerBuilder)eventSchedulerBuilder).addEvent(arg_0, arg_1));
        }
        return eventSchedulerBuilder.build();
    }
}

