/*
 * Decompiled with CFR 0.152.
 */
package nl.stokpop.eventscheduler;

import java.util.HashMap;
import java.util.List;
import nl.stokpop.eventscheduler.EventScheduler;
import nl.stokpop.eventscheduler.api.EventSchedulerLogger;
import nl.stokpop.eventscheduler.api.EventSchedulerLoggerStdOut;
import nl.stokpop.eventscheduler.api.EventSchedulerSettings;
import nl.stokpop.eventscheduler.api.TestContext;
import nl.stokpop.eventscheduler.event.EventBroadcaster;
import nl.stokpop.eventscheduler.event.EventGenerator;
import nl.stokpop.eventscheduler.event.EventProvider;
import nl.stokpop.eventscheduler.event.EventSchedulerProperties;
import nl.stokpop.eventscheduler.event.ScheduleEvent;
import nl.stokpop.eventscheduler.exception.EventSchedulerRuntimeException;
import nl.stokpop.eventscheduler.generator.EventGeneratorDefault;
import nl.stokpop.eventscheduler.generator.EventGeneratorProperties;
import nl.stokpop.eventscheduler.generator.EventGeneratorProvider;

public class EventSchedulerBuilder {
    private static final String GENERATOR_CLASS_META_TAG = "@generator-class";
    private TestContext testContext;
    private EventSchedulerSettings eventSchedulerSettings;
    private boolean assertResultsEnabled = false;
    private EventBroadcaster broadcaster;
    private EventSchedulerProperties eventProperties = new EventSchedulerProperties();
    private String customEventsText = "";
    private EventSchedulerLogger logger = new EventSchedulerLoggerStdOut();

    public EventSchedulerBuilder setTestContext(TestContext context) {
        this.testContext = context;
        return this;
    }

    public EventSchedulerBuilder setLogger(EventSchedulerLogger logger) {
        this.logger = logger;
        return this;
    }

    public EventSchedulerBuilder setEventSchedulerSettings(EventSchedulerSettings settings) {
        this.eventSchedulerSettings = settings;
        return this;
    }

    public EventSchedulerBuilder setAssertResultsEnabled(boolean assertResultsEnabled) {
        this.assertResultsEnabled = assertResultsEnabled;
        return this;
    }

    public EventSchedulerBuilder setBroadcaster(EventBroadcaster broadcaster) {
        this.broadcaster = broadcaster;
        return this;
    }

    public EventSchedulerBuilder addEventProperty(String eventImplementationName, String name, String value) {
        if (eventImplementationName == null || eventImplementationName.isEmpty()) {
            throw new EventSchedulerRuntimeException("EventImplementationName is null or empty for " + this);
        }
        if (name == null || name.isEmpty()) {
            throw new EventSchedulerRuntimeException("EventImplementation property name is null or empty for " + this);
        }
        this.eventProperties.put(eventImplementationName, name, value);
        return this;
    }

    public EventScheduler build() {
        return this.build(null);
    }

    public EventScheduler build(ClassLoader classLoader) {
        if (this.broadcaster == null) {
            this.logger.info("create default event broadcaster");
            this.broadcaster = EventProvider.createInstanceWithEventsFromClasspath(this.logger, classLoader);
        }
        if (this.testContext == null) {
            throw new EventSchedulerRuntimeException("TestContext must be set, it is null.");
        }
        if (this.eventSchedulerSettings == null) {
            throw new EventSchedulerRuntimeException("EventSchedulerSettings must be set, it is null.");
        }
        List<ScheduleEvent> scheduleEvents = this.generateEventSchedule(this.testContext, this.customEventsText, this.logger, classLoader);
        return new EventScheduler(this.testContext, this.eventSchedulerSettings, this.assertResultsEnabled, this.broadcaster, this.eventProperties, scheduleEvents, this.logger);
    }

    private List<ScheduleEvent> generateEventSchedule(TestContext context, String text, EventSchedulerLogger logger, ClassLoader classLoader) {
        EventGeneratorProperties eventGeneratorProperties;
        EventGenerator eventGenerator;
        if (text == null) {
            eventGenerator = new EventGeneratorDefault();
            eventGeneratorProperties = new EventGeneratorProperties();
        } else if (text.contains(GENERATOR_CLASS_META_TAG)) {
            eventGeneratorProperties = new EventGeneratorProperties(text);
            String generatorClassname = eventGeneratorProperties.getMetaProperty(GENERATOR_CLASS_META_TAG);
            eventGenerator = this.findAndCreateEventScheduleGenerator(logger, generatorClassname, classLoader);
        } else {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("eventSchedule", text);
            eventGenerator = new EventGeneratorDefault();
            eventGeneratorProperties = new EventGeneratorProperties(properties);
        }
        return eventGenerator.generate(context, eventGeneratorProperties);
    }

    public EventSchedulerBuilder setCustomEvents(String customEventsText) {
        if (customEventsText != null) {
            this.customEventsText = customEventsText;
        }
        return this;
    }

    private EventGenerator findAndCreateEventScheduleGenerator(EventSchedulerLogger logger, String generatorClassname, ClassLoader classLoader) {
        EventGeneratorProvider provider = EventGeneratorProvider.createInstanceFromClasspath(logger, classLoader);
        EventGenerator generator = provider.find(generatorClassname);
        if (generator == null) {
            throw new EventSchedulerRuntimeException("unable to find EventScheduleGenerator implementation class: " + generatorClassname);
        }
        return generator;
    }
}

