/*
 * Decompiled with CFR 0.152.
 */
package nl.stokpop.eventscheduler.event;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import nl.stokpop.eventscheduler.api.EventSchedulerLogger;
import nl.stokpop.eventscheduler.api.TestContext;
import nl.stokpop.eventscheduler.event.Event;
import nl.stokpop.eventscheduler.event.EventBroadcaster;
import nl.stokpop.eventscheduler.event.EventSchedulerProperties;
import nl.stokpop.eventscheduler.event.ScheduleEvent;

public class EventProvider
implements EventBroadcaster {
    private final EventSchedulerLogger logger;
    private final List<Event> events;

    EventProvider(List<Event> events, EventSchedulerLogger logger) {
        this.events = Collections.unmodifiableList(new ArrayList<Event>(events));
        this.logger = logger;
    }

    public static EventProvider createInstanceWithEventsFromClasspath(EventSchedulerLogger logger) {
        return EventProvider.createInstanceWithEventsFromClasspath(logger, null);
    }

    public static EventProvider createInstanceWithEventsFromClasspath(EventSchedulerLogger logger, ClassLoader classLoader) {
        ServiceLoader<Event> eventLoader = classLoader == null ? ServiceLoader.load(Event.class) : ServiceLoader.load(Event.class, classLoader);
        ArrayList<Event> events = new ArrayList<Event>();
        for (Event event : eventLoader) {
            events.add(event);
        }
        return new EventProvider(events, logger);
    }

    @Override
    public void broadcastBeforeTest(TestContext context, EventSchedulerProperties properties) {
        this.logger.info("broadcast before test event");
        this.events.forEach(this.catchExceptionWrapper(event -> event.beforeTest(context, properties.get((Event)event))));
    }

    @Override
    public void broadcastAfterTest(TestContext context, EventSchedulerProperties properties) {
        this.logger.info("broadcast after test event");
        this.events.forEach(this.catchExceptionWrapper(event -> event.afterTest(context, properties.get((Event)event))));
    }

    @Override
    public void broadCastKeepAlive(TestContext context, EventSchedulerProperties properties) {
        this.logger.debug("broadcast keep alive event");
        this.events.forEach(this.catchExceptionWrapper(event -> event.keepAlive(context, properties.get((Event)event))));
    }

    @Override
    public void broadcastAbortTest(TestContext context, EventSchedulerProperties properties) {
        this.logger.debug("broadcast abort test event");
        this.events.forEach(this.catchExceptionWrapper(event -> event.keepAlive(context, properties.get((Event)event))));
    }

    @Override
    public void broadcastCustomEvent(TestContext context, EventSchedulerProperties properties, ScheduleEvent scheduleEvent) {
        this.logger.info("broadcast " + scheduleEvent.getName() + " custom event");
        this.events.forEach(this.catchExceptionWrapper(event -> event.customEvent(context, properties.get((Event)event), scheduleEvent)));
    }

    @Override
    public void broadcastCheckResults(TestContext context, EventSchedulerProperties eventProperties) {
    }

    private Consumer<Event> catchExceptionWrapper(Consumer<Event> consumer) {
        return event -> {
            try {
                consumer.accept((Event)event);
            }
            catch (Exception e) {
                String message = String.format("exception in event (%s)", event.getName());
                if (this.logger != null) {
                    this.logger.error(message, e);
                }
                System.out.println("(note: better provide a logger): " + message);
            }
        };
    }
}

