/*
 * Decompiled with CFR 0.152.
 */
package nl.stokpop.eventscheduler.generator;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import nl.stokpop.eventscheduler.api.EventSchedulerLogger;
import nl.stokpop.eventscheduler.event.EventGenerator;

public class EventGeneratorProvider {
    private Map<String, EventGenerator> generators;
    private EventSchedulerLogger logger;

    EventGeneratorProvider(Map<String, EventGenerator> generators, EventSchedulerLogger logger) {
        this.generators = Collections.unmodifiableMap(new HashMap<String, EventGenerator>(generators));
        this.logger = logger;
    }

    public static EventGeneratorProvider createInstanceFromClasspath(EventSchedulerLogger logger) {
        return EventGeneratorProvider.createInstanceFromClasspath(logger, null);
    }

    public static EventGeneratorProvider createInstanceFromClasspath(EventSchedulerLogger logger, ClassLoader classLoader) {
        ServiceLoader<EventGenerator> generatorLoader = classLoader == null ? ServiceLoader.load(EventGenerator.class) : ServiceLoader.load(EventGenerator.class, classLoader);
        HashMap<String, EventGenerator> generators = new HashMap<String, EventGenerator>();
        for (EventGenerator generator : generatorLoader) {
            String generatorName = generator.getClass().getName();
            logger.info("registering EventScheduleGenerator: " + generatorName);
            generators.put(generatorName, generator);
        }
        return new EventGeneratorProvider(generators, logger);
    }

    public EventGenerator find(String generatorClassname) {
        return this.generators.get(generatorClassname);
    }
}

