/*
 * Decompiled with CFR 0.152.
 */
package nl.stokpop.eventscheduler;

import java.util.List;
import nl.stokpop.eventscheduler.EventSchedulerEngine;
import nl.stokpop.eventscheduler.api.EventSchedulerLogger;
import nl.stokpop.eventscheduler.api.EventSchedulerSettings;
import nl.stokpop.eventscheduler.api.TestContext;
import nl.stokpop.eventscheduler.event.EventBroadcaster;
import nl.stokpop.eventscheduler.event.EventSchedulerProperties;
import nl.stokpop.eventscheduler.event.ScheduleEvent;

public final class EventScheduler {
    private final EventSchedulerLogger logger;
    private final TestContext context;
    private final EventSchedulerSettings settings;
    private final boolean checkResultsEnabled;
    private final EventBroadcaster broadcaster;
    private final EventSchedulerProperties eventProperties;
    private final List<ScheduleEvent> scheduleEvents;
    private EventSchedulerEngine executorEngine;
    private boolean isSessionStopped = false;

    EventScheduler(TestContext context, EventSchedulerSettings settings, boolean checkResultsEnabled, EventBroadcaster broadcaster, EventSchedulerProperties eventProperties, List<ScheduleEvent> scheduleEvents, EventSchedulerLogger logger) {
        this.context = context;
        this.settings = settings;
        this.checkResultsEnabled = checkResultsEnabled;
        this.eventProperties = eventProperties;
        this.broadcaster = broadcaster;
        this.scheduleEvents = scheduleEvents;
        this.logger = logger;
    }

    public void startSession() {
        this.logger.info("Start test session");
        this.isSessionStopped = false;
        this.executorEngine = new EventSchedulerEngine(this.logger);
        this.broadcaster.broadcastBeforeTest(this.context, this.eventProperties);
        this.executorEngine.startKeepAliveThread(this.context, this.settings, this.broadcaster, this.eventProperties);
        this.executorEngine.startCustomEventScheduler(this.context, this.scheduleEvents, this.broadcaster, this.eventProperties);
    }

    public void stopSession() {
        this.logger.info("Stop test session.");
        this.isSessionStopped = true;
        this.broadcaster.broadcastAfterTest(this.context, this.eventProperties);
        if (this.checkResultsEnabled) {
            this.broadcaster.broadcastCheckResults(this.context, this.eventProperties);
        }
        this.executorEngine.shutdownThreadsNow();
        this.logger.info("All broadcasts for stop test session are done");
    }

    public boolean isSessionStopped() {
        return this.isSessionStopped;
    }

    public void abortSession() {
        this.logger.warn("Test session abort called.");
        this.isSessionStopped = true;
        this.broadcaster.broadcastAbortTest(this.context, this.eventProperties);
        this.executorEngine.shutdownThreadsNow();
    }

    public String toString() {
        return String.format("EventScheduler [testRunId:%s testType:%s testEnv:%s]", this.context.getTestRunId(), this.context.getTestType(), this.context.getTestEnvironment());
    }
}

