/*
 * Decompiled with CFR 0.152.
 */
package nl.stokpop.eventscheduler.api;

import java.time.Duration;
import nl.stokpop.eventscheduler.EventSchedulerUtils;
import nl.stokpop.eventscheduler.api.EventSchedulerSettings;

public class EventSchedulerSettingsBuilder {
    private static final int DEFAULT_KEEP_ALIVE_TIME_SECONDS = 30;
    private Duration keepAliveInterval = Duration.ofSeconds(30L);

    public EventSchedulerSettingsBuilder setKeepAliveTimeInSeconds(String keepAliveTimeInSeconds) {
        this.keepAliveInterval = Duration.ofSeconds(EventSchedulerUtils.parseInt("keepAliveTimeInSeconds", keepAliveTimeInSeconds, 30));
        return this;
    }

    public EventSchedulerSettingsBuilder setKeepAliveInterval(Duration keepAliveInterval) {
        if (keepAliveInterval != null) {
            this.keepAliveInterval = keepAliveInterval;
        }
        return this;
    }

    public EventSchedulerSettings build() {
        return new EventSchedulerSettings(this.keepAliveInterval);
    }
}

