/*
 * Decompiled with CFR 0.152.
 */
package nl.stokpop.eventscheduler.event;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import nl.stokpop.eventscheduler.event.Event;
import nl.stokpop.eventscheduler.event.EventProperties;
import nl.stokpop.eventscheduler.exception.EventSchedulerRuntimeException;

public class EventSchedulerProperties {
    private Map<String, Map<String, String>> eventProperties = new ConcurrentHashMap<String, Map<String, String>>();

    public EventProperties get(Event event) {
        String canonicalName = EventSchedulerProperties.determineCanonicalName(event);
        Map<String, String> props = this.eventProperties.getOrDefault(canonicalName, Collections.emptyMap());
        return new EventProperties(props);
    }

    private static String determineCanonicalName(Event event) {
        String canonicalName = event.getClass().getCanonicalName();
        if (canonicalName == null) {
            String msg = String.format("Anonymous classes are not allowed for Even classes, sorry. [%s]", event.getClass());
            throw new EventSchedulerRuntimeException(msg);
        }
        return canonicalName;
    }

    public EventSchedulerProperties put(Event event, String name, String value) {
        String classImplName = EventSchedulerProperties.determineCanonicalName(event);
        this.put(classImplName, name, value);
        return this;
    }

    public EventSchedulerProperties put(String eventClassImplName, String name, String value) {
        this.eventProperties.computeIfAbsent(eventClassImplName, k -> new ConcurrentHashMap()).put(name, value);
        return this;
    }
}

