/*
 * Decompiled with CFR 0.152.
 */
package nl.stokpop.eventscheduler.generator;

import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class EventGeneratorProperties {
    private Map<String, String> properties;
    private Map<String, String> metaProperties;

    public EventGeneratorProperties(Map<String, String> props) {
        Map<String, String> propsMap = props.entrySet().stream().filter(e -> !((String)e.getKey()).startsWith("@")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Map<String, String> metaMap = props.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("@")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        this.properties = Collections.unmodifiableMap(propsMap);
        this.metaProperties = Collections.unmodifiableMap(metaMap);
    }

    public EventGeneratorProperties() {
        this.properties = Collections.unmodifiableMap(Collections.emptyMap());
    }

    public EventGeneratorProperties(String propsAsText) {
        this(Collections.unmodifiableMap(EventGeneratorProperties.createGeneratorSettings(propsAsText)));
    }

    public String getProperty(String name) {
        return this.properties.get(name);
    }

    public String getMetaProperty(String name) {
        return this.metaProperties.get(name);
    }

    private static Map<String, String> createGeneratorSettings(String generatorSettingsAsText) {
        return Stream.of(generatorSettingsAsText.split("\n")).map(line -> line.split("=")).filter(split -> ((String[])split).length == 2).filter(split -> split[0] != null && split[1] != null).collect(Collectors.toMap(e -> e[0].trim(), e -> e[1].trim()));
    }

    public String toString() {
        return "GeneratorProperties{properties=" + this.properties + ", metaProperties=" + this.metaProperties + '}';
    }
}

