/*
 * Decompiled with CFR 0.152.
 */
package nl.stokpop.eventscheduler.api;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import jdk.nashorn.internal.ir.annotations.Immutable;
import nl.stokpop.eventscheduler.exception.EventSchedulerRuntimeException;

@Immutable
public class EventProperties {
    public static final String FACTORY_CLASSNAME_KEY = "eventFactory";
    private Map<String, String> properties;

    public EventProperties(Properties properties) {
        this(properties.entrySet().stream().collect(Collectors.toMap(x -> x.getKey().toString(), x -> x.getValue().toString())));
    }

    public EventProperties(Map<String, String> props) {
        this.properties = Collections.unmodifiableMap(new HashMap<String, String>(props));
        if (!this.properties.containsKey(FACTORY_CLASSNAME_KEY)) {
            throw new EventSchedulerRuntimeException("The eventFactory property is missing, add it with value the fully qualified class name of the factory for the events.");
        }
    }

    public EventProperties() {
        this.properties = Collections.unmodifiableMap(Collections.emptyMap());
    }

    public String getProperty(String name) {
        return this.properties.get(name);
    }

    public String getPropertyOrDefault(String name, String defaultValue) {
        return this.properties.getOrDefault(name, defaultValue);
    }

    public String getFactoryClassName() {
        return this.properties.get(FACTORY_CLASSNAME_KEY);
    }

    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    public int hashCode() {
        return this.properties.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof EventProperties) {
            return this.properties.equals(((EventProperties)obj).properties);
        }
        return false;
    }

    public String toString() {
        return "EventProperties{properties=" + this.properties + '}';
    }
}

