/*
 * Decompiled with CFR 0.152.
 */
package nl.stokpop.eventscheduler.event;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import nl.stokpop.eventscheduler.api.EventFactory;

public class EventFactoryProvider {
    private final Map<String, EventFactory> eventFactories;

    private EventFactoryProvider(List<EventFactory> eventFactories) {
        Map<String, EventFactory> map = eventFactories.stream().collect(Collectors.toMap(f -> f.getClass().getName(), f -> f));
        this.eventFactories = Collections.unmodifiableMap(map);
    }

    public static EventFactoryProvider createInstanceFromClasspath() {
        return EventFactoryProvider.createInstanceFromClasspath(null);
    }

    public static EventFactoryProvider createInstanceFromClasspath(ClassLoader classLoader) {
        ServiceLoader<EventFactory> eventFactoryLoader = classLoader == null ? ServiceLoader.load(EventFactory.class) : ServiceLoader.load(EventFactory.class, classLoader);
        ArrayList<EventFactory> eventFactories = new ArrayList<EventFactory>();
        for (EventFactory eventFactory : eventFactoryLoader) {
            eventFactories.add(eventFactory);
        }
        return new EventFactoryProvider(eventFactories);
    }

    public Optional<EventFactory> factoryByClassName(String className) {
        return Optional.ofNullable(this.eventFactories.get(className));
    }
}

