/*
 * Decompiled with CFR 0.152.
 */
package nl.stokpop.eventscheduler.log;

import nl.stokpop.eventscheduler.api.EventLogger;

public class EventLoggerWithName
implements EventLogger {
    private final String name;
    private final String classname;
    private final EventLogger logger;

    public EventLoggerWithName(String name, String classname, EventLogger logger) {
        this.name = name;
        this.classname = this.removePackages(classname);
        this.logger = logger;
    }

    private String removePackages(String classname) {
        if (classname.contains(".")) {
            return classname.substring(classname.lastIndexOf(46) + 1);
        }
        return classname;
    }

    @Override
    public void info(String message) {
        this.logger.info(String.format("[%s] [%s] %s", this.name, this.classname, message));
    }

    @Override
    public void warn(String message) {
        this.logger.warn(String.format("[%s] [%s] %s", this.name, this.classname, message));
    }

    @Override
    public void error(String message) {
        this.logger.error(String.format("[%s] [%s] %s", this.name, this.classname, message));
    }

    @Override
    public void error(String message, Throwable throwable) {
        this.logger.error(String.format("[%s] [%s] %s", this.name, this.classname, message), throwable);
    }

    @Override
    public void debug(String message) {
        this.logger.debug(String.format("[%s] [%s] %s", this.name, this.classname, message));
    }
}

