/*
 * Decompiled with CFR 0.152.
 */
package nl.stokpop.eventscheduler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import nl.stokpop.eventscheduler.EventBroadcaster;
import nl.stokpop.eventscheduler.api.CustomEvent;
import nl.stokpop.eventscheduler.api.Event;
import nl.stokpop.eventscheduler.api.EventCheck;
import nl.stokpop.eventscheduler.api.EventLogger;
import nl.stokpop.eventscheduler.log.EventLoggerDevNull;

public class EventBroadcasterDefault
implements EventBroadcaster {
    private final List<Event> events;
    private final EventLogger logger;

    EventBroadcasterDefault(Collection<Event> events, EventLogger logger) {
        this.events = events == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<Event>(events));
        this.logger = logger == null ? EventLoggerDevNull.INSTANCE : logger;
    }

    public EventBroadcasterDefault(Collection<Event> events) {
        this(events, null);
    }

    @Override
    public void broadcastBeforeTest() {
        this.logger.info("broadcast before test event");
        this.events.forEach(this.catchExceptionWrapper(Event::beforeTest));
    }

    @Override
    public void broadcastAfterTest() {
        this.logger.info("broadcast after test event");
        this.events.forEach(this.catchExceptionWrapper(Event::afterTest));
    }

    @Override
    public void broadcastKeepAlive() {
        this.logger.debug("broadcast keep alive event");
        this.events.forEach(this.catchExceptionWrapper(Event::keepAlive));
    }

    @Override
    public void broadcastAbortTest() {
        this.logger.debug("broadcast abort test event");
        this.events.forEach(this.catchExceptionWrapper(Event::abortTest));
    }

    @Override
    public void broadcastCustomEvent(CustomEvent scheduleEvent) {
        this.logger.info("broadcast " + scheduleEvent.getName() + " custom event");
        this.events.forEach(this.catchExceptionWrapper(event -> event.customEvent(scheduleEvent)));
    }

    @Override
    public List<EventCheck> broadcastCheck() {
        this.logger.info("broadcast check test");
        return this.events.stream().map(Event::check).collect(Collectors.toList());
    }

    @Override
    public void shutdownAndWaitAllTasksDone(long timeoutSeconds) {
        this.logger.debug("shutdown broadcaster called, is noop in this implementation.");
    }

    private Consumer<Event> catchExceptionWrapper(Consumer<Event> consumer) {
        return event -> {
            try {
                consumer.accept((Event)event);
            }
            catch (Exception e) {
                String message = String.format("exception in event (%s)", event.getName());
                if (this.logger != null) {
                    this.logger.error(message, e);
                }
                System.err.printf("(note: better provide a logger): %s %s", message, e.getMessage());
            }
        };
    }
}

