/*
 * Decompiled with CFR 0.152.
 */
package nl.stokpop.eventscheduler;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import jdk.nashorn.internal.ir.annotations.Immutable;
import net.jcip.annotations.NotThreadSafe;
import nl.stokpop.eventscheduler.EventBroadcaster;
import nl.stokpop.eventscheduler.EventBroadcasterAsync;
import nl.stokpop.eventscheduler.EventBroadcasterFactory;
import nl.stokpop.eventscheduler.EventScheduler;
import nl.stokpop.eventscheduler.api.CustomEvent;
import nl.stokpop.eventscheduler.api.Event;
import nl.stokpop.eventscheduler.api.EventGenerator;
import nl.stokpop.eventscheduler.api.EventGeneratorFactory;
import nl.stokpop.eventscheduler.api.EventGeneratorMetaProperty;
import nl.stokpop.eventscheduler.api.EventGeneratorProperties;
import nl.stokpop.eventscheduler.api.EventLogger;
import nl.stokpop.eventscheduler.api.EventProperties;
import nl.stokpop.eventscheduler.api.EventSchedulerSettings;
import nl.stokpop.eventscheduler.api.EventSchedulerSettingsBuilder;
import nl.stokpop.eventscheduler.api.TestContext;
import nl.stokpop.eventscheduler.event.EventFactoryProvider;
import nl.stokpop.eventscheduler.exception.EventSchedulerRuntimeException;
import nl.stokpop.eventscheduler.generator.EventGeneratorDefault;
import nl.stokpop.eventscheduler.generator.EventGeneratorFactoryDefault;
import nl.stokpop.eventscheduler.generator.EventGeneratorFactoryProvider;
import nl.stokpop.eventscheduler.log.EventLoggerDevNull;
import nl.stokpop.eventscheduler.log.EventLoggerWithName;

@NotThreadSafe
public class EventSchedulerBuilder {
    private final Set<EventInfo> eventInfos = new HashSet<EventInfo>();
    private TestContext testContext;
    private EventSchedulerSettings eventSchedulerSettings;
    private boolean assertResultsEnabled = false;
    private EventProperties eventProperties = new EventProperties();
    private String customEventsText = "";
    private EventLogger logger = EventLoggerDevNull.INSTANCE;
    private EventFactoryProvider eventFactoryProvider;
    private EventBroadcasterFactory eventBroadcasterFactory;

    public EventSchedulerBuilder setTestContext(TestContext context) {
        this.testContext = context;
        return this;
    }

    public EventSchedulerBuilder setLogger(EventLogger logger) {
        this.logger = logger;
        return this;
    }

    public EventSchedulerBuilder setEventSchedulerSettings(EventSchedulerSettings settings) {
        this.eventSchedulerSettings = settings;
        return this;
    }

    public EventSchedulerBuilder setAssertResultsEnabled(boolean assertResultsEnabled) {
        this.assertResultsEnabled = assertResultsEnabled;
        return this;
    }

    public EventScheduler build() {
        return this.build(null);
    }

    public EventScheduler build(ClassLoader classLoader) {
        if (this.testContext == null) {
            throw new EventSchedulerRuntimeException("TestContext must be set, it is null.");
        }
        EventSchedulerSettings myEventSchedulerSettings = this.eventSchedulerSettings == null ? new EventSchedulerSettingsBuilder().build() : this.eventSchedulerSettings;
        List<CustomEvent> customEvents = this.generateCustomEventSchedule(this.testContext, this.customEventsText, this.logger, classLoader);
        EventFactoryProvider provider = this.eventFactoryProvider == null ? EventFactoryProvider.createInstanceFromClasspath(classLoader) : this.eventFactoryProvider;
        this.eventInfos.stream().filter(e -> !e.getEventProperties().isEventEnabled()).forEach(e -> this.logger.info("Event disabled: " + ((EventInfo)e).eventName));
        List<Event> events = this.eventInfos.stream().filter(e -> e.getEventProperties().isEventEnabled()).map(p -> this.createEvent(provider, (EventInfo)p, this.testContext)).collect(Collectors.toList());
        EventBroadcasterFactory broadcasterFactory = this.eventBroadcasterFactory == null ? EventBroadcasterAsync::new : this.eventBroadcasterFactory;
        EventBroadcaster broadcaster = broadcasterFactory.create(events, this.logger);
        return new EventScheduler(this.testContext, myEventSchedulerSettings, this.assertResultsEnabled, broadcaster, this.eventProperties, customEvents, this.logger);
    }

    private Event createEvent(EventFactoryProvider provider, EventInfo eventInfo, TestContext testContext) {
        EventProperties eventProperties = eventInfo.getEventProperties();
        String factoryClassName = eventProperties.getFactoryClassName();
        String eventName = eventInfo.getEventName();
        EventLoggerWithName eventLogger = new EventLoggerWithName(eventName, this.removeFactoryPostfix(factoryClassName), this.logger);
        Event event = provider.factoryByClassName(factoryClassName).orElseThrow(() -> new RuntimeException(factoryClassName + " not found on classpath")).create(eventName, testContext, eventProperties, eventLogger);
        Collection<String> allowedProperties = event.allowedProperties();
        eventProperties.checkUnknownProperties(allowedProperties, (key, value) -> eventLogger.warn(String.format("unknown property found: '%s' with value: '%s'. Choose from: %s", key, value, allowedProperties)));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("allowed properties: " + event.allowedProperties());
            this.logger.debug("allowed events    : " + event.allowedCustomEvents());
        }
        return event;
    }

    private String removeFactoryPostfix(String factoryClassName) {
        int index = factoryClassName.indexOf("Factory");
        return index != -1 ? factoryClassName.substring(0, index) : factoryClassName;
    }

    private List<CustomEvent> generateCustomEventSchedule(TestContext context, String text, EventLogger logger, ClassLoader classLoader) {
        EventGenerator eventGenerator;
        if (text == null) {
            EventGeneratorProperties eventGeneratorProperties = new EventGeneratorProperties();
            EventLoggerWithName myLogger = new EventLoggerWithName("defaultFactory", EventGeneratorDefault.class.getName(), logger);
            eventGenerator = new EventGeneratorFactoryDefault().create(this.testContext, eventGeneratorProperties, myLogger);
        } else if (EventGeneratorProperties.hasLinesThatStartWithMetaPropertyPrefix(text)) {
            EventGeneratorProperties eventGeneratorProperties = new EventGeneratorProperties(text);
            String generatorClassname = eventGeneratorProperties.getMetaProperty(EventGeneratorMetaProperty.generatorFactoryClass.name());
            EventGeneratorFactory eventGeneratorFactory = this.findAndCreateEventScheduleGenerator(logger, generatorClassname, classLoader);
            EventLoggerWithName myLogger = new EventLoggerWithName("customFactory", generatorClassname, logger);
            eventGenerator = eventGeneratorFactory.create(context, eventGeneratorProperties, myLogger);
        } else {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("eventSchedule", text);
            EventGeneratorProperties eventGeneratorProperties = new EventGeneratorProperties(properties);
            EventLoggerWithName myLogger = new EventLoggerWithName("defaultFactory", EventGeneratorDefault.class.getName(), logger);
            eventGenerator = new EventGeneratorFactoryDefault().create(context, eventGeneratorProperties, myLogger);
        }
        return eventGenerator.generate();
    }

    public EventSchedulerBuilder setCustomEvents(String customEventsText) {
        if (customEventsText != null) {
            this.customEventsText = customEventsText;
        }
        return this;
    }

    private EventGeneratorFactory findAndCreateEventScheduleGenerator(EventLogger logger, String generatorFactoryClassname, ClassLoader classLoader) {
        EventGeneratorFactoryProvider provider = EventGeneratorFactoryProvider.createInstanceFromClasspath(logger, classLoader);
        EventGeneratorFactory generatorFactory = provider.find(generatorFactoryClassname);
        if (generatorFactory == null) {
            throw new EventSchedulerRuntimeException("unable to find EventScheduleGeneratorFactory implementation class: " + generatorFactoryClassname);
        }
        return generatorFactory;
    }

    public EventSchedulerBuilder addEvent(String eventName, Map<String, String> properties) {
        this.addEvent(eventName, new EventProperties(properties));
        return this;
    }

    public EventSchedulerBuilder addEvent(String eventName, Properties properties) {
        this.addEvent(eventName, new EventProperties(properties));
        return this;
    }

    public EventSchedulerBuilder addEvent(String eventName, EventProperties properties) {
        EventInfo eventInfo = new EventInfo(eventName, properties);
        boolean unique = this.eventInfos.add(eventInfo);
        if (!unique) {
            throw new EventSchedulerRuntimeException("Event name is not unique: " + eventInfo);
        }
        return this;
    }

    EventSchedulerBuilder setEventFactoryProvider(EventFactoryProvider eventFactoryProvider) {
        this.eventFactoryProvider = eventFactoryProvider;
        return this;
    }

    EventSchedulerBuilder setEventBroadcasterFactory(EventBroadcasterFactory eventBroadcasterFactory) {
        this.eventBroadcasterFactory = eventBroadcasterFactory;
        return this;
    }

    @Immutable
    private static final class EventInfo {
        private String eventName;
        private EventProperties eventProperties;

        public EventInfo(String eventName, EventProperties eventProperties) {
            this.eventName = eventName;
            this.eventProperties = eventProperties;
        }

        public String getEventName() {
            return this.eventName;
        }

        public EventProperties getEventProperties() {
            return this.eventProperties;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EventInfo eventInfo = (EventInfo)o;
            return Objects.equals(this.eventName, eventInfo.eventName);
        }

        public int hashCode() {
            return Objects.hash(this.eventName);
        }

        public String toString() {
            return "EventInfo{eventName='" + this.eventName + '\'' + ", eventProperties=" + this.eventProperties + '}';
        }
    }
}

