/*
 * Decompiled with CFR 0.152.
 */
package nl.stokpop.eventscheduler.api;

import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import nl.stokpop.eventscheduler.api.CustomEvent;
import nl.stokpop.eventscheduler.api.Event;
import nl.stokpop.eventscheduler.api.EventCheck;
import nl.stokpop.eventscheduler.api.EventLogger;
import nl.stokpop.eventscheduler.api.EventProperties;
import nl.stokpop.eventscheduler.api.TestContext;

public abstract class EventAdapter
implements Event {
    protected final String eventName;
    protected final TestContext testContext;
    protected final EventProperties eventProperties;
    protected final EventLogger logger;

    public EventAdapter(String eventName, TestContext testContext, EventProperties eventProperties, EventLogger logger) {
        this.eventName = eventName;
        this.testContext = testContext;
        this.eventProperties = eventProperties;
        this.logger = logger;
    }

    @Override
    public void beforeTest() {
        this.logger.debug(String.format("[%s] [%s] beforeTest (not implemented)", this.eventName, this.getClass().getName()));
    }

    @Override
    public void afterTest() {
        this.logger.debug(String.format("[%s] [%s] afterTest (not implemented)", this.eventName, this.getClass().getName()));
    }

    @Override
    public void keepAlive() {
        this.logger.debug(String.format("[%s] [%s] keepAlive (not implemented)", this.eventName, this.getClass().getName()));
    }

    @Override
    public void abortTest() {
        this.logger.debug(String.format("[%s] [%s] abortTest (not implemented)", this.eventName, this.getClass().getName()));
    }

    @Override
    public EventCheck check() {
        return EventCheck.DEFAULT;
    }

    @Override
    public void customEvent(CustomEvent customEvent) {
        this.logger.debug(String.format("[%s] [%s] [%s] customEvent (not implemented)", this.eventName, this.getClass().getName(), customEvent.getName()));
    }

    @Override
    public final String getName() {
        return this.eventName;
    }

    public static Set<String> setOf(String ... items) {
        return Collections.unmodifiableSet(new TreeSet<String>(Arrays.asList(items)));
    }
}

