/*
 * Decompiled with CFR 0.152.
 */
package nl.stokpop.eventscheduler;

import java.util.List;
import java.util.stream.Collectors;
import nl.stokpop.eventscheduler.EventBroadcaster;
import nl.stokpop.eventscheduler.EventSchedulerEngine;
import nl.stokpop.eventscheduler.api.CustomEvent;
import nl.stokpop.eventscheduler.api.EventCheck;
import nl.stokpop.eventscheduler.api.EventLogger;
import nl.stokpop.eventscheduler.api.EventProperties;
import nl.stokpop.eventscheduler.api.EventSchedulerSettings;
import nl.stokpop.eventscheduler.api.EventStatus;
import nl.stokpop.eventscheduler.api.SchedulerExceptionHandler;
import nl.stokpop.eventscheduler.api.TestContext;
import nl.stokpop.eventscheduler.exception.EventCheckFailureException;

public final class EventScheduler {
    private final EventLogger logger;
    private final TestContext context;
    private final EventSchedulerSettings settings;
    private final boolean checkResultsEnabled;
    private final EventBroadcaster broadcaster;
    private final EventProperties eventProperties;
    private final List<CustomEvent> scheduleEvents;
    private SchedulerExceptionHandler schedulerExceptionHandler;
    private EventSchedulerEngine executorEngine;
    private boolean isSessionStopped = false;

    EventScheduler(TestContext context, EventSchedulerSettings settings, boolean checkResultsEnabled, EventBroadcaster broadcaster, EventProperties eventProperties, List<CustomEvent> scheduleEvents, EventLogger logger, SchedulerExceptionHandler schedulerExceptionHandler) {
        this.context = context;
        this.settings = settings;
        this.checkResultsEnabled = checkResultsEnabled;
        this.eventProperties = eventProperties;
        this.broadcaster = broadcaster;
        this.scheduleEvents = scheduleEvents;
        this.logger = logger;
        this.executorEngine = new EventSchedulerEngine(logger);
        this.schedulerExceptionHandler = schedulerExceptionHandler;
    }

    public void addKillSwitch(SchedulerExceptionHandler schedulerExceptionHandler) {
        this.schedulerExceptionHandler = schedulerExceptionHandler;
    }

    public void startSession() {
        this.logger.info("Start test session");
        this.isSessionStopped = false;
        this.broadcaster.broadcastBeforeTest();
        this.executorEngine.startKeepAliveThread(this.context, this.settings, this.broadcaster, this.eventProperties, this.schedulerExceptionHandler);
        this.executorEngine.startCustomEventScheduler(this.context, this.scheduleEvents, this.broadcaster, this.eventProperties);
    }

    public void stopSession() {
        this.logger.info("Stop test session.");
        this.isSessionStopped = true;
        this.broadcaster.broadcastAfterTest();
        this.executorEngine.shutdownThreadsNow();
        this.logger.info("All broadcasts for stop test session are done");
    }

    public boolean isSessionStopped() {
        return this.isSessionStopped;
    }

    public void abortSession() {
        this.logger.info("Test session abort called.");
        this.isSessionStopped = true;
        this.broadcaster.broadcastAbortTest();
        this.executorEngine.shutdownThreadsNow();
    }

    public void checkResults() throws EventCheckFailureException {
        this.logger.info("Check results called.");
        List<EventCheck> eventChecks = this.broadcaster.broadcastCheck();
        boolean success = eventChecks.stream().allMatch(e -> e.getEventStatus() != EventStatus.FAILURE);
        this.logger.debug("Checked " + eventChecks.size() + " event checks. All success: " + success);
        if (!success) {
            String failureMessage = eventChecks.stream().filter(e -> e.getEventStatus() == EventStatus.FAILURE).map(e -> String.format("class: '%s' eventId: '%s' message: '%s'", e.getEventClassName(), e.getEventId(), e.getMessage())).collect(Collectors.joining(", "));
            String message = String.format("Event checks with failures found: [%s]", failureMessage);
            if (this.checkResultsEnabled) {
                this.logger.info("One or more event checks reported a failure: " + message);
                throw new EventCheckFailureException(message);
            }
            this.logger.warn("CheckResultsEnabled is false, not throwing EventCheckFailureException with message: " + message);
        }
    }

    public String toString() {
        return "EventScheduler [testRunId:" + this.context.getTestRunId() + " testType:" + this.context.getWorkload() + " testEnv:" + this.context.getEnvironment() + "]";
    }
}

