/*
 * Decompiled with CFR 0.152.
 */
package nl.stokpop.eventscheduler.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.jcip.annotations.Immutable;
import nl.stokpop.eventscheduler.exception.EventSchedulerRuntimeException;

@Immutable
public class EventProperties {
    public static final String PROP_FACTORY_CLASSNAME = "eventFactory";
    public static final String PROP_EVENT_ENABLED = "enabled";
    private static final List<String> DEFAULT_PROPERTIES;
    private Map<String, String> properties;

    public EventProperties(Properties properties) {
        this(properties.entrySet().stream().collect(Collectors.toMap(x -> x.getKey().toString(), x -> x.getValue().toString())));
    }

    public EventProperties(Map<String, String> props) {
        this.properties = Collections.unmodifiableMap(new HashMap<String, String>(props));
        if (!this.properties.containsKey(PROP_FACTORY_CLASSNAME)) {
            throw new EventSchedulerRuntimeException("The eventFactory property is missing, add it with value the fully qualified class name of the factory for the events.");
        }
    }

    public EventProperties() {
        this.properties = Collections.unmodifiableMap(Collections.emptyMap());
    }

    public String getProperty(String name) {
        return this.properties.get(name);
    }

    public String getPropertyOrDefault(String name, String defaultValue) {
        return this.properties.getOrDefault(name, defaultValue);
    }

    public String getFactoryClassName() {
        return this.properties.get(PROP_FACTORY_CLASSNAME);
    }

    public boolean isEventEnabled() {
        return Boolean.parseBoolean(this.properties.getOrDefault(PROP_EVENT_ENABLED, "true"));
    }

    public void checkUnknownProperties(Collection<String> allowedProperties, BiConsumer<String, String> unknownPropertyAction) {
        this.properties.entrySet().stream().filter(e -> !DEFAULT_PROPERTIES.contains(e.getKey())).filter(e -> !allowedProperties.contains(e.getKey())).forEach(e -> unknownPropertyAction.accept((String)e.getKey(), (String)e.getValue()));
    }

    public boolean containsUnknownProperties(Collection<String> allowedProperties) {
        return this.properties.values().stream().filter(e -> !DEFAULT_PROPERTIES.contains(e)).anyMatch(e -> !allowedProperties.contains(e));
    }

    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    public int hashCode() {
        return this.properties.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof EventProperties) {
            return this.properties.equals(((EventProperties)obj).properties);
        }
        return false;
    }

    public String toString() {
        return "EventProperties{properties=" + this.properties + '}';
    }

    static {
        ArrayList<String> props = new ArrayList<String>();
        props.add(PROP_FACTORY_CLASSNAME);
        props.add(PROP_EVENT_ENABLED);
        DEFAULT_PROPERTIES = Collections.unmodifiableList(props);
    }
}

