/*
 * Decompiled with CFR 0.152.
 */
package nl.stokpop.eventscheduler.api;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.jcip.annotations.Immutable;

@Immutable
public class TestContext {
    private final String systemUnderTest;
    private final String workload;
    private final String environment;
    private final String testRunId;
    private final String version;
    private final String CIBuildResultsUrl;
    private final Duration rampupTime;
    private final Duration plannedDuration;
    private final String annotations;
    private final Map<String, String> variables;
    private final List<String> tags;

    TestContext(String systemUnderTest, String workload, String environment, String testRunId, String CIBuildResultsUrl, String version, Duration rampupTime, Duration plannedDuration, String annotations, Map<String, String> variables, List<String> tags) {
        this.systemUnderTest = systemUnderTest;
        this.workload = workload;
        this.environment = environment;
        this.testRunId = testRunId;
        this.CIBuildResultsUrl = CIBuildResultsUrl;
        this.version = version;
        this.rampupTime = rampupTime;
        this.plannedDuration = plannedDuration;
        this.annotations = annotations;
        this.variables = Collections.unmodifiableMap(new HashMap<String, String>(variables));
        this.tags = Collections.unmodifiableList(new ArrayList<String>(tags));
    }

    public String getSystemUnderTest() {
        return this.systemUnderTest;
    }

    public String getWorkload() {
        return this.workload;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public String getTestRunId() {
        return this.testRunId;
    }

    public String getCIBuildResultsUrl() {
        return this.CIBuildResultsUrl;
    }

    public String getVersion() {
        return this.version;
    }

    public Duration getRampupTime() {
        return this.rampupTime;
    }

    public Duration getPlannedDuration() {
        return this.plannedDuration;
    }

    public String getAnnotations() {
        return this.annotations;
    }

    public Map<String, String> getVariables() {
        return this.variables;
    }

    public List<String> getTags() {
        return this.tags;
    }
}

