/*
 * Decompiled with CFR 0.152.
 */
package nl.stokpop.eventscheduler.generator;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import nl.stokpop.eventscheduler.api.EventGeneratorFactory;
import nl.stokpop.eventscheduler.api.EventLogger;

public class EventGeneratorFactoryProvider {
    private Map<String, EventGeneratorFactory> generatorFactories;
    private EventLogger logger;

    EventGeneratorFactoryProvider(Map<String, EventGeneratorFactory> generatorFactories, EventLogger logger) {
        this.generatorFactories = Collections.unmodifiableMap(new HashMap<String, EventGeneratorFactory>(generatorFactories));
        this.logger = logger;
    }

    public static EventGeneratorFactoryProvider createInstanceFromClasspath(EventLogger logger) {
        return EventGeneratorFactoryProvider.createInstanceFromClasspath(logger, null);
    }

    public static EventGeneratorFactoryProvider createInstanceFromClasspath(EventLogger logger, ClassLoader classLoader) {
        ServiceLoader<EventGeneratorFactory> generatorFactoryLoader = classLoader == null ? ServiceLoader.load(EventGeneratorFactory.class) : ServiceLoader.load(EventGeneratorFactory.class, classLoader);
        HashMap<String, EventGeneratorFactory> factories = new HashMap<String, EventGeneratorFactory>();
        for (EventGeneratorFactory generatorFactory : generatorFactoryLoader) {
            String generatorName = generatorFactory.getClass().getName();
            logger.info("registering EventScheduleGeneratorFactory: " + generatorName);
            factories.put(generatorName, generatorFactory);
        }
        return new EventGeneratorFactoryProvider(factories, logger);
    }

    public EventGeneratorFactory find(String generatorClassname) {
        return this.generatorFactories.get(generatorClassname);
    }
}

