/*
 * Decompiled with CFR 0.152.
 */
package nl.stokpop.eventscheduler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import nl.stokpop.eventscheduler.EventBroadcaster;
import nl.stokpop.eventscheduler.api.CustomEvent;
import nl.stokpop.eventscheduler.api.Event;
import nl.stokpop.eventscheduler.api.EventCheck;
import nl.stokpop.eventscheduler.api.EventLogger;
import nl.stokpop.eventscheduler.api.EventStatus;
import nl.stokpop.eventscheduler.exception.EventSchedulerRuntimeException;
import nl.stokpop.eventscheduler.exception.handler.SchedulerHandlerException;
import nl.stokpop.eventscheduler.log.EventLoggerDevNull;

public class EventBroadcasterAsync
implements EventBroadcaster {
    protected static final int ALL_CALLS_TIME_OUT_SECONDS = 300;
    private final ExecutorService executor;
    private final List<Event> events;
    private final EventLogger logger;

    EventBroadcasterAsync(Collection<Event> events, EventLogger logger, ExecutorService executor) {
        this.events = events == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<Event>(events));
        this.logger = logger == null ? EventLoggerDevNull.INSTANCE : logger;
        this.executor = executor == null ? Executors.newCachedThreadPool() : executor;
    }

    public EventBroadcasterAsync(Collection<Event> events, EventLogger logger) {
        this(events, logger, null);
    }

    public EventBroadcasterAsync(Collection<Event> events) {
        this(events, null, null);
    }

    @Override
    public void broadcastBeforeTest() {
        this.logger.info("broadcast before test event");
        CompletableFuture[] cfs = (CompletableFuture[])this.events.stream().map(e -> CompletableFuture.runAsync(e::beforeTest, this.executor).exceptionally((Function)this.printError((Event)e))).toArray(CompletableFuture[]::new);
        CompletionStage allBeforeTests = CompletableFuture.allOf(cfs).exceptionally(t -> {
            this.logger.warn("There was an exception calling a before test: " + t.getMessage());
            return null;
        });
        try {
            Void void_ = (Void)((CompletableFuture)allBeforeTests).get(300L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e2) {
            this.logger.warn("got interrupt waiting for all 'before test' calls to finish, not all call may have been finished");
        }
        catch (ExecutionException e3) {
            throw new EventSchedulerRuntimeException("waiting for all 'before test' calls failed", e3);
        }
        catch (TimeoutException e4) {
            this.logger.warn("waited for 300 seconds, got timeout waiting, 'before test' tasks might still be running?");
        }
    }

    @Override
    public void broadcastStartTest() {
        this.logger.info("broadcast start test event");
        Stream<CompletableFuture> cfs = this.events.stream().map(e -> CompletableFuture.runAsync(e::startTest, this.executor).exceptionally((Function)this.printError((Event)e)));
        CompletionStage allStartTests = CompletableFuture.allOf((CompletableFuture[])cfs.toArray(CompletableFuture[]::new)).exceptionally(t -> {
            this.logger.warn("There was an exception calling a before test: " + t.getMessage());
            return null;
        });
        try {
            Void void_ = (Void)((CompletableFuture)allStartTests).get(300L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e2) {
            this.logger.warn("got interrupt waiting for all 'after test' calls to finish, not all call may have been finished");
        }
        catch (ExecutionException e3) {
            throw new EventSchedulerRuntimeException("waiting for all 'after test' calls failed", e3);
        }
        catch (TimeoutException e4) {
            this.logger.warn("waited for 300 seconds, got timeout waiting, 'after test' tasks might still be running?");
        }
    }

    @Override
    public void broadcastAfterTest() {
        this.logger.info("broadcast after test event");
        Stream<CompletableFuture> cfs = this.events.stream().map(e -> CompletableFuture.runAsync(e::afterTest, this.executor).exceptionally((Function)this.printError((Event)e)));
        CompletionStage allAfterTests = CompletableFuture.allOf((CompletableFuture[])cfs.toArray(CompletableFuture[]::new)).exceptionally(t -> {
            this.logger.warn("There was an exception calling a before test: " + t.getMessage());
            return null;
        });
        try {
            Void void_ = (Void)((CompletableFuture)allAfterTests).get(300L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e2) {
            this.logger.warn("got interrupt waiting for all 'after test' calls to finish, not all call may have been finished");
        }
        catch (ExecutionException e3) {
            throw new EventSchedulerRuntimeException("waiting for all 'after test' calls failed", e3);
        }
        catch (TimeoutException e4) {
            this.logger.warn("waited for 300 seconds, got timeout waiting, 'after test' tasks might still be running?");
        }
    }

    @Override
    public void broadcastKeepAlive() {
        this.logger.debug("broadcast keep alive event");
        ConcurrentLinkedQueue<Throwable> exceptions = new ConcurrentLinkedQueue<Throwable>();
        Stream<CompletableFuture> cfs = this.events.stream().map(e -> CompletableFuture.runAsync(e::keepAlive, this.executor).exceptionally((Function)this.printError((Event)e, (Queue<Throwable>)exceptions)));
        CompletableFuture<Void> allKeepAlives = CompletableFuture.allOf((CompletableFuture[])cfs.toArray(CompletableFuture[]::new));
        try {
            Void void_ = allKeepAlives.get(300L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e2) {
            this.logger.warn("got interrupt waiting for all 'keep alive' calls to finish, not all call may have been finished");
        }
        catch (ExecutionException e3) {
            throw new EventSchedulerRuntimeException("waiting for all 'keep alive' calls failed", e3);
        }
        catch (TimeoutException e4) {
            this.logger.warn("waited for 300 seconds, got timeout waiting for 'keep alive' tasks");
        }
        this.logger.debug("Keep Alive found exceptions: " + exceptions);
        this.throwAbortOrKillWitchException(exceptions);
    }

    @Override
    public void broadcastAbortTest() {
        this.logger.debug("broadcast abort test event");
        Stream<CompletableFuture> cfs = this.events.stream().map(e -> CompletableFuture.runAsync(e::abortTest, this.executor).exceptionally((Function)this.printError((Event)e)));
        CompletionStage allAbortTests = CompletableFuture.allOf((CompletableFuture[])cfs.toArray(CompletableFuture[]::new)).exceptionally(t -> {
            this.logger.warn("There was an exception calling an abort test: " + t.getMessage());
            return null;
        });
        try {
            Void void_ = (Void)((CompletableFuture)allAbortTests).get(300L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e2) {
            this.logger.warn("got interrupt waiting for all 'abort test' calls to finish, not all call may have been finished");
        }
        catch (ExecutionException e3) {
            throw new EventSchedulerRuntimeException("waiting for all 'abort test' calls failed", e3);
        }
        catch (TimeoutException e4) {
            this.logger.warn("waited for 300 seconds, got timeout waiting, 'abort test' tasks might still be running?");
        }
    }

    @Override
    public void broadcastCustomEvent(CustomEvent scheduleEvent) {
        this.logger.info("broadcast " + scheduleEvent.getName() + " custom event");
        this.events.forEach(e -> CompletableFuture.runAsync(() -> e.customEvent(scheduleEvent), this.executor).exceptionally((Function)this.printError((Event)e)));
    }

    @Override
    public List<EventCheck> broadcastCheck() {
        this.logger.info("broadcast check test");
        List<CompletableFuture> eventChecks = this.events.stream().map(e -> CompletableFuture.supplyAsync(e::check, this.executor).exceptionally((Function)this.getFailureEventCheck((Event)e))).collect(Collectors.toList());
        CompletableFuture[] cfs = eventChecks.toArray(new CompletableFuture[0]);
        CompletionStage allEventChecks = CompletableFuture.allOf(cfs).exceptionally(t -> {
            throw new EventSchedulerRuntimeException("There was an exception getting an event check: " + t.getMessage());
        });
        CompletionStage listCompletableFuture = ((CompletableFuture)allEventChecks).thenApply(future -> eventChecks.stream().map(CompletableFuture::join).collect(Collectors.toList()));
        try {
            return (List)((CompletableFuture)listCompletableFuture).get(300L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e2) {
            throw new EventSchedulerRuntimeException("get event checks error", e2);
        }
    }

    @Override
    public void shutdownAndWaitAllTasksDone(long timeoutSeconds) {
        this.logger.info("shutdown broadcaster, waiting up to " + timeoutSeconds + " seconds for tasks to finish");
        this.executor.shutdown();
        try {
            if (!this.executor.awaitTermination(timeoutSeconds, TimeUnit.SECONDS)) {
                this.executor.shutdownNow();
            }
        }
        catch (InterruptedException ex) {
            this.logger.warn("forced shutdown broadcaster, some tasks might not have been finished");
            this.executor.shutdownNow();
            Thread.currentThread().interrupt();
        }
        this.logger.info("shutdown broadcaster done.");
    }

    private Function<Throwable, EventCheck> getFailureEventCheck(Event e) {
        return t -> {
            EventCheck eventCheck = new EventCheck(e.getName(), e.getClass().getSimpleName(), EventStatus.FAILURE, "Failed to produce an event check! " + t.getMessage());
            this.logger.error("Error during check: " + eventCheck, (Throwable)t);
            return eventCheck;
        };
    }

    private Function<Throwable, Void> printError(Event e, Queue<Throwable> errors) {
        return t -> {
            Throwable cause = t.getCause();
            if (cause instanceof SchedulerHandlerException) {
                this.logger.debug("SchedulerHandler " + (Object)((Object)((SchedulerHandlerException)cause).getExceptionType()) + " requested from event '" + e.getName() + "'");
            } else {
                this.logger.error("Event failure in '" + e.getName() + "'", cause);
            }
            if (errors != null) {
                errors.add(cause);
            }
            return null;
        };
    }

    private Function<Throwable, Void> printError(Event e) {
        return this.printError(e, null);
    }
}

