/*
 * Decompiled with CFR 0.152.
 */
package nl.stokpop.eventscheduler;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import nl.stokpop.eventscheduler.EventBroadcaster;
import nl.stokpop.eventscheduler.EventSchedulerEngine;
import nl.stokpop.eventscheduler.api.CustomEvent;
import nl.stokpop.eventscheduler.api.EventCheck;
import nl.stokpop.eventscheduler.api.EventLogger;
import nl.stokpop.eventscheduler.api.EventStatus;
import nl.stokpop.eventscheduler.api.SchedulerExceptionHandler;
import nl.stokpop.eventscheduler.api.config.EventContext;
import nl.stokpop.eventscheduler.api.config.EventSchedulerContext;
import nl.stokpop.eventscheduler.api.message.EventMessage;
import nl.stokpop.eventscheduler.api.message.EventMessageBus;
import nl.stokpop.eventscheduler.exception.EventCheckFailureException;

public final class EventScheduler {
    private final EventLogger logger;
    private final String name;
    private final boolean checkResultsEnabled;
    private final EventBroadcaster broadcaster;
    private final Collection<CustomEvent> scheduleEvents;
    private final EventSchedulerContext eventSchedulerContext;
    private final EventMessageBus eventMessageBus;
    private volatile SchedulerExceptionHandler schedulerExceptionHandler;
    private final EventSchedulerEngine eventSchedulerEngine;
    private final AtomicBoolean isSessionActive = new AtomicBoolean(false);
    private final AtomicInteger goMessageCount = new AtomicInteger(0);
    private final StartTest startTest;
    private final int waitForGoMessagesCount;

    EventScheduler(EventBroadcaster broadcaster, Collection<CustomEvent> scheduleEvents, EventSchedulerContext eventSchedulerContext, EventMessageBus messageBus, EventLogger logger, EventSchedulerEngine eventSchedulerEngine, SchedulerExceptionHandler schedulerExceptionHandler) {
        this.name = eventSchedulerContext.getTestContext().getTestRunId();
        this.checkResultsEnabled = eventSchedulerContext.isSchedulerEnabled();
        this.broadcaster = broadcaster;
        this.scheduleEvents = scheduleEvents;
        this.eventSchedulerContext = eventSchedulerContext;
        this.eventMessageBus = messageBus;
        this.logger = logger;
        this.eventSchedulerEngine = eventSchedulerEngine;
        this.schedulerExceptionHandler = schedulerExceptionHandler;
        this.waitForGoMessagesCount = (int)eventSchedulerContext.getEventContexts().stream().filter(EventContext::isReadyForStartParticipant).peek(e -> logger.info("Found 'ReadyForStart' participant: " + e.getName())).count();
        this.startTest = () -> {
            broadcaster.broadcastStartTest();
            eventSchedulerEngine.startKeepAliveThread(this.name, eventSchedulerContext.getKeepAliveInterval(), broadcaster, schedulerExceptionHandler);
            eventSchedulerEngine.startCustomEventScheduler(scheduleEvents, broadcaster);
        };
        if (this.waitForGoMessagesCount != 0) {
            logger.info("Wait for Go! messages is active, need " + this.waitForGoMessagesCount + " Go! messages to start!");
            this.eventMessageBus.addReceiver(m -> this.checkMessageForGo(m, this.startTest, this.waitForGoMessagesCount));
        }
    }

    private void checkMessageForGo(EventMessage m, StartTest startTest, int totalGoMessages) {
        if ("go!".equalsIgnoreCase(m.getMessage())) {
            int count = this.goMessageCount.incrementAndGet();
            this.logger.info("Got 'Go! message' from " + m.getPluginName() + " now counted " + count + " 'Go! messages' of " + totalGoMessages + " needed.");
            if (count == totalGoMessages) {
                startTest.start();
            }
        }
    }

    public void addKillSwitch(SchedulerExceptionHandler schedulerExceptionHandler) {
        this.schedulerExceptionHandler = schedulerExceptionHandler;
    }

    public void startSession() {
        boolean wasInActive = this.isSessionActive.compareAndSet(false, true);
        if (!wasInActive) {
            this.logger.warn("unexpected call to start session, session was active already, ignore call!");
        } else {
            this.logger.info("start test session");
            this.broadcaster.broadcastBeforeTest();
            if (this.waitForGoMessagesCount == 0) {
                this.startTest.start();
            }
        }
    }

    public void stopSession() {
        boolean wasActive = this.isSessionActive.compareAndSet(true, false);
        if (!wasActive) {
            this.logger.warn("unexpected call to stop session, session was inactive already, ignoring call: please debug");
        } else {
            this.logger.info("stop test session.");
            this.eventSchedulerEngine.shutdownThreadsNow();
            this.broadcaster.broadcastAfterTest();
            this.logger.info("all broadcasts for stop test session are done");
        }
    }

    public boolean isSessionStopped() {
        return !this.isSessionActive.get();
    }

    public void abortSession() {
        boolean wasActive = this.isSessionActive.compareAndSet(true, false);
        if (!wasActive) {
            this.logger.warn("unexpected call to abort session, session was inactive already, ignoring call: please debug");
        } else {
            this.logger.info("test session abort called");
            this.eventSchedulerEngine.shutdownThreadsNow();
            this.broadcaster.broadcastAbortTest();
        }
    }

    public void checkResults() throws EventCheckFailureException {
        this.logger.info("check results called");
        List<EventCheck> eventChecks = this.broadcaster.broadcastCheck();
        this.logger.debug("event checks: " + eventChecks);
        boolean success = eventChecks.stream().allMatch(e -> e.getEventStatus() != EventStatus.FAILURE);
        this.logger.debug("checked " + eventChecks.size() + " event checks, all success: " + success);
        if (!success) {
            String failureMessage = eventChecks.stream().filter(e -> e.getEventStatus() == EventStatus.FAILURE).map(e -> String.format("class: '%s' eventId: '%s' message: '%s'", e.getEventClassName(), e.getEventId(), e.getMessage())).collect(Collectors.joining(", "));
            String message = String.format("event checks with failures found: [%s]", failureMessage);
            if (this.checkResultsEnabled) {
                this.logger.info("one or more event checks reported a failure: " + message);
                throw new EventCheckFailureException(message);
            }
            this.logger.warn("checkResultsEnabled is false, not throwing EventCheckFailureException with message: " + message);
        }
    }

    public String toString() {
        return "EventScheduler [testRunId:" + this.name + "]";
    }

    public EventSchedulerContext getEventSchedulerContext() {
        return this.eventSchedulerContext;
    }

    private static interface StartTest {
        public void start();
    }
}

