/*
 * Decompiled with CFR 0.152.
 */
package nl.stokpop.eventscheduler.api.config;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.jcip.annotations.Immutable;
import nl.stokpop.eventscheduler.api.config.EventContext;
import nl.stokpop.eventscheduler.api.config.TestContext;

@Immutable
public final class EventSchedulerContext {
    private final boolean debugEnabled;
    private final boolean schedulerEnabled;
    private final boolean failOnError;
    private final boolean continueOnEventCheckFailure;
    private final Duration keepAliveInterval;
    private final String scheduleScript;
    private final List<EventContext> eventContexts;
    private final TestContext testContext;

    private static boolean $default$debugEnabled() {
        return false;
    }

    private static boolean $default$schedulerEnabled() {
        return true;
    }

    private static boolean $default$failOnError() {
        return true;
    }

    private static boolean $default$continueOnEventCheckFailure() {
        return true;
    }

    private static Duration $default$keepAliveInterval() {
        return Duration.ofSeconds(30L);
    }

    private static String $default$scheduleScript() {
        return "";
    }

    private static TestContext $default$testContext() {
        return TestContext.builder().build();
    }

    EventSchedulerContext(boolean debugEnabled, boolean schedulerEnabled, boolean failOnError, boolean continueOnEventCheckFailure, Duration keepAliveInterval, String scheduleScript, List<EventContext> eventContexts, TestContext testContext) {
        this.debugEnabled = debugEnabled;
        this.schedulerEnabled = schedulerEnabled;
        this.failOnError = failOnError;
        this.continueOnEventCheckFailure = continueOnEventCheckFailure;
        this.keepAliveInterval = keepAliveInterval;
        this.scheduleScript = scheduleScript;
        this.eventContexts = eventContexts;
        this.testContext = testContext;
    }

    protected static EventSchedulerContextBuilder builder() {
        return new EventSchedulerContextBuilder();
    }

    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    public boolean isSchedulerEnabled() {
        return this.schedulerEnabled;
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    public boolean isContinueOnEventCheckFailure() {
        return this.continueOnEventCheckFailure;
    }

    public Duration getKeepAliveInterval() {
        return this.keepAliveInterval;
    }

    public String getScheduleScript() {
        return this.scheduleScript;
    }

    public List<EventContext> getEventContexts() {
        return this.eventContexts;
    }

    public TestContext getTestContext() {
        return this.testContext;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EventSchedulerContext)) {
            return false;
        }
        EventSchedulerContext other = (EventSchedulerContext)o;
        if (this.isDebugEnabled() != other.isDebugEnabled()) {
            return false;
        }
        if (this.isSchedulerEnabled() != other.isSchedulerEnabled()) {
            return false;
        }
        if (this.isFailOnError() != other.isFailOnError()) {
            return false;
        }
        if (this.isContinueOnEventCheckFailure() != other.isContinueOnEventCheckFailure()) {
            return false;
        }
        Duration this$keepAliveInterval = this.getKeepAliveInterval();
        Duration other$keepAliveInterval = other.getKeepAliveInterval();
        if (this$keepAliveInterval == null ? other$keepAliveInterval != null : !((Object)this$keepAliveInterval).equals(other$keepAliveInterval)) {
            return false;
        }
        String this$scheduleScript = this.getScheduleScript();
        String other$scheduleScript = other.getScheduleScript();
        if (this$scheduleScript == null ? other$scheduleScript != null : !this$scheduleScript.equals(other$scheduleScript)) {
            return false;
        }
        List<EventContext> this$eventContexts = this.getEventContexts();
        List<EventContext> other$eventContexts = other.getEventContexts();
        if (this$eventContexts == null ? other$eventContexts != null : !((Object)this$eventContexts).equals(other$eventContexts)) {
            return false;
        }
        TestContext this$testContext = this.getTestContext();
        TestContext other$testContext = other.getTestContext();
        return !(this$testContext == null ? other$testContext != null : !((Object)this$testContext).equals(other$testContext));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDebugEnabled() ? 79 : 97);
        result = result * 59 + (this.isSchedulerEnabled() ? 79 : 97);
        result = result * 59 + (this.isFailOnError() ? 79 : 97);
        result = result * 59 + (this.isContinueOnEventCheckFailure() ? 79 : 97);
        Duration $keepAliveInterval = this.getKeepAliveInterval();
        result = result * 59 + ($keepAliveInterval == null ? 43 : ((Object)$keepAliveInterval).hashCode());
        String $scheduleScript = this.getScheduleScript();
        result = result * 59 + ($scheduleScript == null ? 43 : $scheduleScript.hashCode());
        List<EventContext> $eventContexts = this.getEventContexts();
        result = result * 59 + ($eventContexts == null ? 43 : ((Object)$eventContexts).hashCode());
        TestContext $testContext = this.getTestContext();
        result = result * 59 + ($testContext == null ? 43 : ((Object)$testContext).hashCode());
        return result;
    }

    public String toString() {
        return "EventSchedulerContext(debugEnabled=" + this.isDebugEnabled() + ", schedulerEnabled=" + this.isSchedulerEnabled() + ", failOnError=" + this.isFailOnError() + ", continueOnEventCheckFailure=" + this.isContinueOnEventCheckFailure() + ", keepAliveInterval=" + this.getKeepAliveInterval() + ", scheduleScript=" + this.getScheduleScript() + ", eventContexts=" + this.getEventContexts() + ", testContext=" + this.getTestContext() + ")";
    }

    protected static class EventSchedulerContextBuilder {
        private boolean debugEnabled$set;
        private boolean debugEnabled$value;
        private boolean schedulerEnabled$set;
        private boolean schedulerEnabled$value;
        private boolean failOnError$set;
        private boolean failOnError$value;
        private boolean continueOnEventCheckFailure$set;
        private boolean continueOnEventCheckFailure$value;
        private boolean keepAliveInterval$set;
        private Duration keepAliveInterval$value;
        private boolean scheduleScript$set;
        private String scheduleScript$value;
        private ArrayList<EventContext> eventContexts;
        private boolean testContext$set;
        private TestContext testContext$value;

        EventSchedulerContextBuilder() {
        }

        public EventSchedulerContextBuilder debugEnabled(boolean debugEnabled) {
            this.debugEnabled$value = debugEnabled;
            this.debugEnabled$set = true;
            return this;
        }

        public EventSchedulerContextBuilder schedulerEnabled(boolean schedulerEnabled) {
            this.schedulerEnabled$value = schedulerEnabled;
            this.schedulerEnabled$set = true;
            return this;
        }

        public EventSchedulerContextBuilder failOnError(boolean failOnError) {
            this.failOnError$value = failOnError;
            this.failOnError$set = true;
            return this;
        }

        public EventSchedulerContextBuilder continueOnEventCheckFailure(boolean continueOnEventCheckFailure) {
            this.continueOnEventCheckFailure$value = continueOnEventCheckFailure;
            this.continueOnEventCheckFailure$set = true;
            return this;
        }

        public EventSchedulerContextBuilder keepAliveInterval(Duration keepAliveInterval) {
            this.keepAliveInterval$value = keepAliveInterval;
            this.keepAliveInterval$set = true;
            return this;
        }

        public EventSchedulerContextBuilder scheduleScript(String scheduleScript) {
            this.scheduleScript$value = scheduleScript;
            this.scheduleScript$set = true;
            return this;
        }

        public EventSchedulerContextBuilder eventContext(EventContext eventContext) {
            if (this.eventContexts == null) {
                this.eventContexts = new ArrayList();
            }
            this.eventContexts.add(eventContext);
            return this;
        }

        public EventSchedulerContextBuilder eventContexts(Collection<? extends EventContext> eventContexts) {
            if (eventContexts == null) {
                throw new NullPointerException("eventContexts cannot be null");
            }
            if (this.eventContexts == null) {
                this.eventContexts = new ArrayList();
            }
            this.eventContexts.addAll(eventContexts);
            return this;
        }

        public EventSchedulerContextBuilder clearEventContexts() {
            if (this.eventContexts != null) {
                this.eventContexts.clear();
            }
            return this;
        }

        public EventSchedulerContextBuilder testContext(TestContext testContext) {
            this.testContext$value = testContext;
            this.testContext$set = true;
            return this;
        }

        public EventSchedulerContext build() {
            List<EventContext> eventContexts;
            switch (this.eventContexts == null ? 0 : this.eventContexts.size()) {
                case 0: {
                    eventContexts = Collections.emptyList();
                    break;
                }
                case 1: {
                    eventContexts = Collections.singletonList(this.eventContexts.get(0));
                    break;
                }
                default: {
                    eventContexts = Collections.unmodifiableList(new ArrayList<EventContext>(this.eventContexts));
                }
            }
            boolean debugEnabled$value = this.debugEnabled$value;
            if (!this.debugEnabled$set) {
                debugEnabled$value = EventSchedulerContext.$default$debugEnabled();
            }
            boolean schedulerEnabled$value = this.schedulerEnabled$value;
            if (!this.schedulerEnabled$set) {
                schedulerEnabled$value = EventSchedulerContext.$default$schedulerEnabled();
            }
            boolean failOnError$value = this.failOnError$value;
            if (!this.failOnError$set) {
                failOnError$value = EventSchedulerContext.$default$failOnError();
            }
            boolean continueOnEventCheckFailure$value = this.continueOnEventCheckFailure$value;
            if (!this.continueOnEventCheckFailure$set) {
                continueOnEventCheckFailure$value = EventSchedulerContext.$default$continueOnEventCheckFailure();
            }
            Duration keepAliveInterval$value = this.keepAliveInterval$value;
            if (!this.keepAliveInterval$set) {
                keepAliveInterval$value = EventSchedulerContext.$default$keepAliveInterval();
            }
            String scheduleScript$value = this.scheduleScript$value;
            if (!this.scheduleScript$set) {
                scheduleScript$value = EventSchedulerContext.$default$scheduleScript();
            }
            TestContext testContext$value = this.testContext$value;
            if (!this.testContext$set) {
                testContext$value = EventSchedulerContext.$default$testContext();
            }
            return new EventSchedulerContext(debugEnabled$value, schedulerEnabled$value, failOnError$value, continueOnEventCheckFailure$value, keepAliveInterval$value, scheduleScript$value, eventContexts, testContext$value);
        }

        public String toString() {
            return "EventSchedulerContext.EventSchedulerContextBuilder(debugEnabled$value=" + this.debugEnabled$value + ", schedulerEnabled$value=" + this.schedulerEnabled$value + ", failOnError$value=" + this.failOnError$value + ", continueOnEventCheckFailure$value=" + this.continueOnEventCheckFailure$value + ", keepAliveInterval$value=" + this.keepAliveInterval$value + ", scheduleScript$value=" + this.scheduleScript$value + ", eventContexts=" + this.eventContexts + ", testContext$value=" + this.testContext$value + ")";
        }
    }
}

