/*
 * Decompiled with CFR 0.152.
 */
package nl.stokpop.eventscheduler;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.jcip.annotations.NotThreadSafe;
import nl.stokpop.eventscheduler.EventBroadcaster;
import nl.stokpop.eventscheduler.EventBroadcasterAsync;
import nl.stokpop.eventscheduler.EventBroadcasterFactory;
import nl.stokpop.eventscheduler.EventMessageBusSimple;
import nl.stokpop.eventscheduler.EventScheduler;
import nl.stokpop.eventscheduler.EventSchedulerEngine;
import nl.stokpop.eventscheduler.api.CustomEvent;
import nl.stokpop.eventscheduler.api.Event;
import nl.stokpop.eventscheduler.api.EventGenerator;
import nl.stokpop.eventscheduler.api.EventGeneratorFactory;
import nl.stokpop.eventscheduler.api.EventGeneratorMetaProperty;
import nl.stokpop.eventscheduler.api.EventGeneratorProperties;
import nl.stokpop.eventscheduler.api.EventLogger;
import nl.stokpop.eventscheduler.api.SchedulerExceptionHandler;
import nl.stokpop.eventscheduler.api.config.EventContext;
import nl.stokpop.eventscheduler.api.config.EventSchedulerContext;
import nl.stokpop.eventscheduler.api.message.EventMessageBus;
import nl.stokpop.eventscheduler.event.EventFactoryProvider;
import nl.stokpop.eventscheduler.exception.EventSchedulerRuntimeException;
import nl.stokpop.eventscheduler.generator.EventGeneratorDefault;
import nl.stokpop.eventscheduler.generator.EventGeneratorFactoryDefault;
import nl.stokpop.eventscheduler.generator.EventGeneratorFactoryProvider;
import nl.stokpop.eventscheduler.log.EventLoggerDevNull;
import nl.stokpop.eventscheduler.log.EventLoggerWithName;

@NotThreadSafe
class EventSchedulerBuilderInternal {
    private final Map<String, EventContext> eventContexts = new ConcurrentHashMap<String, EventContext>();
    private EventSchedulerContext eventSchedulerContext;
    private String customEventsText = "";
    private EventLogger logger = EventLoggerDevNull.INSTANCE;
    private EventFactoryProvider eventFactoryProvider;
    private EventBroadcasterFactory eventBroadcasterFactory;
    private SchedulerExceptionHandler schedulerExceptionHandler;
    private EventSchedulerEngine eventSchedulerEngine;
    private EventMessageBus eventMessageBus;

    EventSchedulerBuilderInternal() {
    }

    public EventSchedulerBuilderInternal setEventSchedulerEngine(EventSchedulerEngine executorEngine) {
        this.eventSchedulerEngine = executorEngine;
        return this;
    }

    public EventSchedulerBuilderInternal setEventMessageBus(EventMessageBus eventMessageBus) {
        this.eventMessageBus = eventMessageBus;
        return this;
    }

    public EventSchedulerBuilderInternal setSchedulerExceptionHandler(SchedulerExceptionHandler callback) {
        this.schedulerExceptionHandler = callback;
        return this;
    }

    public EventSchedulerBuilderInternal setLogger(EventLogger logger) {
        this.logger = logger;
        return this;
    }

    public EventSchedulerBuilderInternal setEventSchedulerContext(EventSchedulerContext context) {
        this.eventSchedulerContext = context;
        return this;
    }

    public EventScheduler build() {
        return this.build(null);
    }

    public EventScheduler build(ClassLoader classLoader) {
        if (this.eventSchedulerContext == null) {
            throw new EventSchedulerRuntimeException("eventSchedulerContext must be set, it is null.");
        }
        EventMessageBus eventMessageBus = this.eventMessageBus == null ? new EventMessageBusSimple() : this.eventMessageBus;
        this.eventSchedulerContext.getEventContexts().forEach(this::addEvent);
        List<CustomEvent> customEvents = this.generateCustomEventSchedule(this.customEventsText, this.logger, classLoader);
        EventFactoryProvider provider = this.eventFactoryProvider == null ? EventFactoryProvider.createInstanceFromClasspath(classLoader) : this.eventFactoryProvider;
        this.eventContexts.values().stream().filter(eventConfig -> !eventConfig.isEnabled()).forEach(eventConfig -> this.logger.info("Event disabled: " + eventConfig.getName()));
        List<Event> events = this.eventContexts.values().stream().filter(EventContext::isEnabled).map(context -> this.createEvent(provider, (EventContext)context, eventMessageBus)).collect(Collectors.toList());
        EventBroadcasterFactory broadcasterFactory = this.eventBroadcasterFactory == null ? EventBroadcasterAsync::new : this.eventBroadcasterFactory;
        EventBroadcaster broadcaster = broadcasterFactory.create(events, this.logger);
        this.eventSchedulerEngine = this.eventSchedulerEngine == null ? new EventSchedulerEngine(this.logger) : this.eventSchedulerEngine;
        return new EventScheduler(broadcaster, customEvents, this.eventSchedulerContext, eventMessageBus, this.logger, this.eventSchedulerEngine, this.schedulerExceptionHandler);
    }

    private Event createEvent(EventFactoryProvider provider, EventContext context, EventMessageBus messageBus) {
        String factoryClassName = context.getEventFactory();
        String eventName = context.getName();
        EventLoggerWithName eventLogger = new EventLoggerWithName(eventName, this.removeFactoryPostfix(factoryClassName), this.logger);
        return provider.factoryByClassName(factoryClassName).orElseThrow(() -> new RuntimeException(factoryClassName + " not found on classpath")).create(context, messageBus, eventLogger);
    }

    private String removeFactoryPostfix(String factoryClassName) {
        int index = factoryClassName.indexOf("Factory");
        return index != -1 ? factoryClassName.substring(0, index) : factoryClassName;
    }

    private List<CustomEvent> generateCustomEventSchedule(String text, EventLogger logger, ClassLoader classLoader) {
        EventGenerator eventGenerator;
        if (text == null) {
            EventGeneratorProperties eventGeneratorProperties = new EventGeneratorProperties();
            EventLoggerWithName myLogger = new EventLoggerWithName("defaultFactory", EventGeneratorDefault.class.getName(), logger);
            eventGenerator = new EventGeneratorFactoryDefault().create(eventGeneratorProperties, myLogger);
        } else if (EventGeneratorProperties.hasLinesThatStartWithMetaPropertyPrefix(text)) {
            EventGeneratorProperties eventGeneratorProperties = new EventGeneratorProperties(text);
            String generatorClassname = eventGeneratorProperties.getMetaProperty(EventGeneratorMetaProperty.generatorFactoryClass.name());
            EventGeneratorFactory eventGeneratorFactory = this.findAndCreateEventScheduleGenerator(logger, generatorClassname, classLoader);
            EventLoggerWithName myLogger = new EventLoggerWithName("customFactory", generatorClassname, logger);
            eventGenerator = eventGeneratorFactory.create(eventGeneratorProperties, myLogger);
        } else {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("eventSchedule", text);
            EventGeneratorProperties eventGeneratorProperties = new EventGeneratorProperties(properties);
            EventLoggerWithName myLogger = new EventLoggerWithName("defaultFactory", EventGeneratorDefault.class.getName(), logger);
            eventGenerator = new EventGeneratorFactoryDefault().create(eventGeneratorProperties, myLogger);
        }
        return eventGenerator.generate();
    }

    public EventSchedulerBuilderInternal setCustomEvents(String customEventsText) {
        if (customEventsText != null) {
            this.customEventsText = customEventsText;
        }
        return this;
    }

    private EventGeneratorFactory findAndCreateEventScheduleGenerator(EventLogger logger, String generatorFactoryClassname, ClassLoader classLoader) {
        EventGeneratorFactoryProvider provider = EventGeneratorFactoryProvider.createInstanceFromClasspath(logger, classLoader);
        EventGeneratorFactory generatorFactory = provider.find(generatorFactoryClassname);
        if (generatorFactory == null) {
            throw new EventSchedulerRuntimeException("unable to find EventScheduleGeneratorFactory implementation class: " + generatorFactoryClassname);
        }
        return generatorFactory;
    }

    private EventSchedulerBuilderInternal addEvent(EventContext eventContext) {
        if (eventContext.getTestContext() == null) {
            throw new EventSchedulerRuntimeException("eventConfig without test config! " + eventContext);
        }
        EventContext existingEventContext = this.eventContexts.putIfAbsent(eventContext.getName(), eventContext);
        if (existingEventContext != null) {
            throw new EventSchedulerRuntimeException("Event name is not unique: " + eventContext.getName());
        }
        return this;
    }

    EventSchedulerBuilderInternal setEventFactoryProvider(EventFactoryProvider eventFactoryProvider) {
        this.eventFactoryProvider = eventFactoryProvider;
        return this;
    }

    EventSchedulerBuilderInternal setEventBroadcasterFactory(EventBroadcasterFactory eventBroadcasterFactory) {
        this.eventBroadcasterFactory = eventBroadcasterFactory;
        return this;
    }
}

