/*
 * Decompiled with CFR 0.152.
 */
package nl.stokpop.eventscheduler.api.message;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public final class EventMessage {
    private final long timestamp;
    private final String message;
    private final String pluginName;
    private final Map<String, String> variables;

    private static long $default$timestamp() {
        return System.currentTimeMillis();
    }

    EventMessage(long timestamp, String message, String pluginName, Map<String, String> variables) {
        this.timestamp = timestamp;
        this.message = message;
        this.pluginName = pluginName;
        this.variables = variables;
    }

    public static EventMessageBuilder builder() {
        return new EventMessageBuilder();
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getMessage() {
        return this.message;
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public Map<String, String> getVariables() {
        return this.variables;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EventMessage)) {
            return false;
        }
        EventMessage other = (EventMessage)o;
        if (this.getTimestamp() != other.getTimestamp()) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        String this$pluginName = this.getPluginName();
        String other$pluginName = other.getPluginName();
        if (this$pluginName == null ? other$pluginName != null : !this$pluginName.equals(other$pluginName)) {
            return false;
        }
        Map<String, String> this$variables = this.getVariables();
        Map<String, String> other$variables = other.getVariables();
        return !(this$variables == null ? other$variables != null : !((Object)this$variables).equals(other$variables));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $timestamp = this.getTimestamp();
        result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        String $pluginName = this.getPluginName();
        result = result * 59 + ($pluginName == null ? 43 : $pluginName.hashCode());
        Map<String, String> $variables = this.getVariables();
        result = result * 59 + ($variables == null ? 43 : ((Object)$variables).hashCode());
        return result;
    }

    public String toString() {
        return "EventMessage(timestamp=" + this.getTimestamp() + ", message=" + this.getMessage() + ", pluginName=" + this.getPluginName() + ", variables=" + this.getVariables() + ")";
    }

    public static class EventMessageBuilder {
        private boolean timestamp$set;
        private long timestamp$value;
        private String message;
        private String pluginName;
        private ArrayList<String> variables$key;
        private ArrayList<String> variables$value;

        EventMessageBuilder() {
        }

        public EventMessageBuilder timestamp(long timestamp) {
            this.timestamp$value = timestamp;
            this.timestamp$set = true;
            return this;
        }

        public EventMessageBuilder message(String message) {
            this.message = message;
            return this;
        }

        public EventMessageBuilder pluginName(String pluginName) {
            this.pluginName = pluginName;
            return this;
        }

        public EventMessageBuilder variable(String variableKey, String variableValue) {
            if (this.variables$key == null) {
                this.variables$key = new ArrayList();
                this.variables$value = new ArrayList();
            }
            this.variables$key.add(variableKey);
            this.variables$value.add(variableValue);
            return this;
        }

        public EventMessageBuilder variables(Map<? extends String, ? extends String> variables) {
            if (variables == null) {
                throw new NullPointerException("variables cannot be null");
            }
            if (this.variables$key == null) {
                this.variables$key = new ArrayList();
                this.variables$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : variables.entrySet()) {
                this.variables$key.add($lombokEntry.getKey());
                this.variables$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public EventMessageBuilder clearVariables() {
            if (this.variables$key != null) {
                this.variables$key.clear();
                this.variables$value.clear();
            }
            return this;
        }

        public EventMessage build() {
            Map<String, String> variables;
            switch (this.variables$key == null ? 0 : this.variables$key.size()) {
                case 0: {
                    variables = Collections.emptyMap();
                    break;
                }
                case 1: {
                    variables = Collections.singletonMap(this.variables$key.get(0), this.variables$value.get(0));
                    break;
                }
                default: {
                    variables = new LinkedHashMap(this.variables$key.size() < 0x40000000 ? 1 + this.variables$key.size() + (this.variables$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.variables$key.size(); ++$i) {
                        variables.put(this.variables$key.get($i), this.variables$value.get($i));
                    }
                    variables = Collections.unmodifiableMap(variables);
                }
            }
            long timestamp$value = this.timestamp$value;
            if (!this.timestamp$set) {
                timestamp$value = EventMessage.$default$timestamp();
            }
            return new EventMessage(timestamp$value, this.message, this.pluginName, variables);
        }

        public String toString() {
            return "EventMessage.EventMessageBuilder(timestamp$value=" + this.timestamp$value + ", message=" + this.message + ", pluginName=" + this.pluginName + ", variables$key=" + this.variables$key + ", variables$value=" + this.variables$value + ")";
        }
    }
}

