/*
 * Decompiled with CFR 0.152.
 */
package nl.stokpop.eventscheduler.generator;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import nl.stokpop.eventscheduler.api.CustomEvent;
import nl.stokpop.eventscheduler.api.EventGenerator;
import nl.stokpop.eventscheduler.api.EventGeneratorProperties;
import nl.stokpop.eventscheduler.api.EventLogger;
import nl.stokpop.eventscheduler.exception.EventSchedulerRuntimeException;

public class EventGeneratorDefault
implements EventGenerator {
    public static final String EVENT_SCHEDULE_TAG = "eventSchedule";
    private final EventGeneratorProperties properties;

    EventGeneratorDefault(EventGeneratorProperties properties, EventLogger logger) {
        this.properties = properties;
    }

    @Override
    public List<CustomEvent> generate() {
        return this.createTestEvents(this.properties.getProperty(EVENT_SCHEDULE_TAG));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<CustomEvent> createTestEvents(String eventsAsString) {
        if (eventsAsString == null) return Collections.emptyList();
        try (BufferedReader eventReader = new BufferedReader(new StringReader(eventsAsString));){
            List<String> events = eventReader.lines().map(String::trim).filter(e -> !e.isEmpty()).filter(e -> !e.startsWith("@")).collect(Collectors.toList());
            List<CustomEvent> list = this.parseScheduleEvents(events);
            return list;
        }
        catch (IOException e2) {
            throw new EventSchedulerRuntimeException("Unable to generate test events");
        }
    }

    private List<CustomEvent> parseScheduleEvents(List<String> eventSchedule) {
        return eventSchedule.stream().map(CustomEvent::createFromLine).collect(Collectors.toList());
    }
}

