/*
 * Decompiled with CFR 0.152.
 */
package nl.stokpop.eventscheduler;

import java.util.List;
import java.util.Queue;
import nl.stokpop.eventscheduler.api.CustomEvent;
import nl.stokpop.eventscheduler.api.EventCheck;
import nl.stokpop.eventscheduler.exception.handler.AbortSchedulerException;
import nl.stokpop.eventscheduler.exception.handler.KillSwitchException;

public interface EventBroadcaster {
    public void broadcastBeforeTest();

    public void broadcastStartTest();

    public void broadcastAfterTest();

    public void broadcastKeepAlive();

    public void broadcastAbortTest();

    public void broadcastCustomEvent(CustomEvent var1);

    public List<EventCheck> broadcastCheck();

    public void shutdownAndWaitAllTasksDone(long var1);

    default public void throwAbortOrKillWitchException(Queue<Throwable> exceptions) {
        exceptions.stream().filter(t -> t instanceof AbortSchedulerException).findFirst().ifPresent(abort -> {
            throw new AbortSchedulerException("Found abort scheduler request during keep-alive broadcast: " + abort.getMessage());
        });
        exceptions.stream().filter(t -> t instanceof KillSwitchException).findFirst().ifPresent(kill -> {
            throw new KillSwitchException("Found kill switch request during keep-alive broadcast: " + kill.getMessage());
        });
    }
}

