/*
 * Decompiled with CFR 0.152.
 */
package nl.stokpop.eventscheduler.api;

import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import nl.stokpop.eventscheduler.api.CustomEvent;
import nl.stokpop.eventscheduler.api.Event;
import nl.stokpop.eventscheduler.api.EventCheck;
import nl.stokpop.eventscheduler.api.EventLogger;
import nl.stokpop.eventscheduler.api.config.EventContext;
import nl.stokpop.eventscheduler.api.message.EventMessageBus;

public abstract class EventAdapter<T extends EventContext>
implements Event {
    protected final T eventContext;
    protected final EventLogger logger;
    protected final EventMessageBus eventMessageBus;

    public EventAdapter(T context, EventMessageBus messageBus, EventLogger logger) {
        this.eventContext = context;
        this.logger = logger;
        this.eventMessageBus = messageBus;
    }

    @Deprecated
    public EventAdapter(T context, EventLogger logger) {
        this(context, null, logger);
    }

    @Override
    public void beforeTest() {
        this.logger.debug(String.format("[%s] [%s] beforeTest (not implemented)", ((EventContext)this.eventContext).getName(), this.getClass().getName()));
    }

    @Override
    public void startTest() {
        this.logger.debug(String.format("[%s] [%s] startTest (not implemented)", ((EventContext)this.eventContext).getName(), this.getClass().getName()));
    }

    @Override
    public void afterTest() {
        this.logger.debug(String.format("[%s] [%s] afterTest (not implemented)", ((EventContext)this.eventContext).getName(), this.getClass().getName()));
    }

    @Override
    public void keepAlive() {
        this.logger.debug(String.format("[%s] [%s] keepAlive (not implemented)", ((EventContext)this.eventContext).getName(), this.getClass().getName()));
    }

    @Override
    public void abortTest() {
        this.logger.debug(String.format("[%s] [%s] abortTest (not implemented)", ((EventContext)this.eventContext).getName(), this.getClass().getName()));
    }

    @Override
    public EventCheck check() {
        return EventCheck.DEFAULT;
    }

    @Override
    public void customEvent(CustomEvent customEvent) {
        this.logger.debug(String.format("[%s] [%s] [%s] customEvent (not implemented)", ((EventContext)this.eventContext).getName(), this.getClass().getName(), customEvent.getName()));
    }

    @Override
    public final String getName() {
        return ((EventContext)this.eventContext).getName();
    }

    public static Set<String> setOf(String ... items) {
        return Collections.unmodifiableSet(new TreeSet<String>(Arrays.asList(items)));
    }
}

