/*
 * Decompiled with CFR 0.152.
 */
package nl.stokpop.memory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import nl.stokpop.memory.HistoAnalyser;
import nl.stokpop.memory.domain.AnalysisResult;
import nl.stokpop.memory.domain.ClassGrowth;
import nl.stokpop.memory.domain.ClassGrowthTrend;
import nl.stokpop.memory.domain.ClassName;
import nl.stokpop.memory.domain.HistoInfo;
import nl.stokpop.memory.domain.HistoLine;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J,\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00062\u0016\b\u0002\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\rJ\u001e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u00a8\u0006\u0013"}, d2={"Lnl/stokpop/memory/HistoAnalyser;", "", "()V", "analyse", "Lnl/stokpop/memory/domain/ClassGrowthTrend;", "histos", "", "Lnl/stokpop/memory/domain/HistoInfo;", "analyseGrowth", "Lnl/stokpop/memory/domain/AnalysisResult;", "histoLines", "Lnl/stokpop/memory/domain/HistoLine;", "thingToCheck", "Lkotlin/Function1;", "", "processClassNameForHistoInfos", "Lnl/stokpop/memory/domain/ClassGrowth;", "name", "Lnl/stokpop/memory/domain/ClassName;", "memory-check"})
public final class HistoAnalyser {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ClassGrowthTrend analyse(@NotNull List<HistoInfo> histos) {
        Collection<Pair> collection;
        void $this$mapTo$iv$iv;
        Object list$iv$iv;
        HistoInfo it;
        Iterable $this$flatMapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(histos, (String)"histos");
        if (histos.isEmpty()) {
            return new ClassGrowthTrend(MapsKt.emptyMap());
        }
        Iterable $this$flatMap$iv = histos;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (HistoInfo)element$iv$iv;
            boolean bl = false;
            list$iv$iv = it.findAllClassNames();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Set classNames = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Iterable $this$map$iv = classNames;
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            list$iv$iv = (ClassName)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it, (Object)this.processClassNameForHistoInfos((ClassName)((Object)it), histos));
            collection.add(pair);
        }
        collection = (List)destination$iv$iv;
        Map map = MapsKt.toMap((Iterable)collection);
        return new ClassGrowthTrend(map);
    }

    /*
     * WARNING - void declaration
     */
    private final ClassGrowth processClassNameForHistoInfos(ClassName name, List<HistoInfo> histos) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = histos;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            HistoLine histoLine;
            Object v0;
            Collection collection;
            block3: {
                void it;
                HistoInfo histoInfo = (HistoInfo)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                Iterable $this$firstOrNull$iv = it.getHistogram();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    HistoLine it2 = (HistoLine)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)name, (Object)it2.getClassName())) continue;
                    v0 = element$iv;
                    break block3;
                }
                v0 = null;
            }
            if ((histoLine = (HistoLine)v0) == null) {
                histoLine = HistoLine.Companion.createGhostLine(name);
            }
            HistoLine histoLine2 = histoLine;
            collection.add(histoLine2);
        }
        List histosForClassName = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        return new ClassGrowth(name, histosForClassName, this.analyseGrowth(histosForClassName, (Function1<? super HistoLine, Long>)((Function1)processClassNameForHistoInfos.1.INSTANCE)));
    }

    @NotNull
    public final AnalysisResult analyseGrowth(@NotNull List<HistoLine> histoLines, @NotNull Function1<? super HistoLine, Long> thingToCheck) {
        Intrinsics.checkParameterIsNotNull(histoLines, (String)"histoLines");
        Intrinsics.checkParameterIsNotNull(thingToCheck, (String)"thingToCheck");
        if (histoLines.isEmpty()) {
            return AnalysisResult.UNKNOWN;
        }
        int histoSize = histoLines.size();
        if (histoSize == 1) {
            return AnalysisResult.UNKNOWN;
        }
        int compareSize = histoSize - 1;
        int growthCount = 0;
        int shrinkCount = 0;
        int stableCount = 0;
        int ghostCount = 0;
        boolean lastIsGhost = false;
        long lastValue = -1L;
        for (HistoLine line : histoLines) {
            lastIsGhost = false;
            if (line.isGhost()) {
                ++ghostCount;
                lastIsGhost = true;
                continue;
            }
            Object object = thingToCheck.invoke((Object)line);
            if (object == null) {
                Intrinsics.throwNpe();
            }
            long currentValue = ((Number)object).longValue();
            if (lastValue != -1L) {
                if (lastValue < currentValue) {
                    ++growthCount;
                } else if (lastValue > currentValue) {
                    ++shrinkCount;
                } else {
                    ++stableCount;
                }
            }
            lastValue = currentValue;
        }
        if (ghostCount == compareSize) {
            return AnalysisResult.UNKNOWN;
        }
        if (growthCount + ghostCount == compareSize && !lastIsGhost) {
            return AnalysisResult.GROW;
        }
        if (growthCount + ghostCount == compareSize && lastIsGhost) {
            return AnalysisResult.UNKNOWN;
        }
        if (shrinkCount + ghostCount == compareSize) {
            return AnalysisResult.SHRINK;
        }
        if (stableCount + ghostCount == compareSize) {
            return AnalysisResult.STABLE;
        }
        return AnalysisResult.UNKNOWN;
    }

    public static /* synthetic */ AnalysisResult analyseGrowth$default(HistoAnalyser histoAnalyser, List list, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = analyseGrowth.1.INSTANCE;
        }
        return histoAnalyser.analyseGrowth(list, (Function1<? super HistoLine, Long>)function1);
    }
}

