/*
 * Decompiled with CFR 0.152.
 */
package nl.stokpop.memory;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import nl.stokpop.memory.HistoReader;
import nl.stokpop.memory.InvalidHistoLineException;
import nl.stokpop.memory.MemoryCheck;
import nl.stokpop.memory.domain.ClassName;
import nl.stokpop.memory.domain.HistoInfo;
import nl.stokpop.memory.domain.HistoLine;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\f2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\fJ\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0006H\u0002\u00a8\u0006\u0012"}, d2={"Lnl/stokpop/memory/HistoReader;", "", "()V", "createHistoLine", "Lnl/stokpop/memory/domain/HistoLine;", "line", "", "dateForHistoFile", "Ljava/time/LocalDateTime;", "file", "Ljava/io/File;", "readHisto", "", "readHistos", "Lnl/stokpop/memory/domain/HistoInfo;", "histoFiles", "skipLastCharacter", "s", "memory-check"})
public final class HistoReader {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<HistoInfo> readHistos(@NotNull List<? extends File> histoFiles) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(histoFiles, (String)"histoFiles");
        Iterable $this$map$iv = histoFiles;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File file = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            HistoInfo histoInfo = new HistoInfo((File)it, this.dateForHistoFile((File)it), this.readHisto((File)it));
            collection.add(histoInfo);
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    private final LocalDateTime dateForHistoFile(File file) {
        LocalDateTime localDateTime;
        try {
            BasicFileAttributes attr = Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
            FileTime fileTime = attr.creationTime();
            LocalDateTime localDateTime2 = LocalDateTime.ofInstant(fileTime.toInstant(), MemoryCheck.Companion.useZoneOffset());
            Intrinsics.checkExpressionValueIsNotNull((Object)localDateTime2, (String)"LocalDateTime.ofInstant(\u2026oryCheck.useZoneOffset())");
            localDateTime = localDateTime2;
        }
        catch (IOException ex) {
            System.err.println("Unable to get creation date for " + file + ", using last modified as work around.");
            LocalDateTime localDateTime3 = LocalDateTime.from(Instant.ofEpochMilli(file.lastModified()));
            Intrinsics.checkExpressionValueIsNotNull((Object)localDateTime3, (String)"LocalDateTime.from(Insta\u2026lli(file.lastModified()))");
            localDateTime = localDateTime3;
        }
        return localDateTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<HistoLine> readHisto(File file) {
        File $this$useLines$iv = file;
        Charset charset$iv = Charsets.UTF_8;
        boolean $i$f$useLines = false;
        Object object = $this$useLines$iv;
        int n = 8192;
        boolean bl = false;
        Object object2 = object;
        boolean bl2 = false;
        Object object3 = object2;
        boolean bl3 = false;
        object3 = new FileInputStream((File)object3);
        bl3 = false;
        object2 = new InputStreamReader((InputStream)object3, charset$iv);
        bl2 = false;
        object = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
        n = 0;
        Throwable throwable = null;
        try {
            BufferedReader it$iv = (BufferedReader)object;
            boolean bl4 = false;
            Sequence line = TextStreamsKt.lineSequence((BufferedReader)it$iv);
            boolean bl5 = false;
            object2 = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)line, (Function1)readHisto.1.1.INSTANCE), (Function1)readHisto.1.2.INSTANCE), (Function1)((Function1)new Function1<String, HistoLine>(this){
                final /* synthetic */ HistoReader this$0;
                {
                    this.this$0 = histoReader;
                    super(1);
                }

                @NotNull
                public final HistoLine invoke(@NotNull String it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return HistoReader.access$createHistoLine(this.this$0, it);
                }
            })));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        return object2;
    }

    private final HistoLine createHistoLine(String line) {
        CharSequence charSequence = line;
        String string = "\\s+";
        int n = 0;
        string = new Regex(string);
        n = 0;
        boolean bl = false;
        List split = string.split(charSequence, n);
        if (split.size() != 4 && split.size() != 5) {
            throw (Throwable)new InvalidHistoLineException("Cannot read histo line (" + split.size() + " elements, 4 or 5 expected): '" + line + "' and '" + split + '\'');
        }
        String num = this.skipLastCharacter((String)split.get(0));
        String instances = (String)split.get(1);
        String bytes2 = (String)split.get(2);
        String name = (String)split.get(3);
        String string2 = num;
        ClassName className = new ClassName(name);
        boolean bl2 = false;
        long l = Long.parseLong(string2);
        string2 = instances;
        Long l2 = l;
        bl2 = false;
        long l3 = Long.parseLong(string2);
        string2 = bytes2;
        Long l4 = l3;
        bl2 = false;
        long l5 = Long.parseLong(string2);
        Long l6 = l5;
        Long l7 = l4;
        Long l8 = l2;
        ClassName className2 = className;
        return new HistoLine(className2, l8, l7, l6);
    }

    private final String skipLastCharacter(String s) {
        String string = s;
        int n = 0;
        int n2 = s.length() - 1;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, n2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        return string3;
    }

    public static final /* synthetic */ HistoLine access$createHistoLine(HistoReader $this, String line) {
        return $this.createHistoLine(line);
    }
}

