/*
 * Decompiled with CFR 0.152.
 */
package nl.stokpop.memory;

import java.io.File;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import nl.stokpop.memory.HistoAnalyser;
import nl.stokpop.memory.HistoReader;
import nl.stokpop.memory.MemoryCheckException;
import nl.stokpop.memory.TextReport;
import nl.stokpop.memory.domain.ClassGrowthTrend;
import nl.stokpop.memory.domain.HistoInfo;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006\u00a8\u0006\t"}, d2={"Lnl/stokpop/memory/MemoryCheck;", "", "()V", "processHistos", "", "directory", "", "extension", "Companion", "memory-check"})
public final class MemoryCheck {
    public static final Companion Companion = new Companion(null);

    public final void processHistos(@NotNull String directory, @NotNull String extension) {
        File file;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)directory, (String)"directory");
        Intrinsics.checkParameterIsNotNull((Object)extension, (String)"extension");
        File dir = new File(directory);
        if (!dir.isDirectory()) {
            throw (Throwable)new MemoryCheckException("This is not a directory: " + directory);
        }
        Object[] objectArray = dir.listFiles();
        if (objectArray == null) {
            objectArray = new File[]{};
        }
        Object $this$filter$iv = ArraysKt.asList((Object[])objectArray);
        boolean $i$f$filter = false;
        Object object = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            file = (File)element$iv$iv;
            boolean bl = false;
            File file2 = file;
            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"file");
            if (!FilesKt.getExtension((File)file2).equals(extension)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            file = (File)element$iv$iv;
            boolean bl = false;
            File file3 = file;
            Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"file");
            String string = file3.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.name");
            if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"histo", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List files = CollectionsKt.toList((Iterable)CollectionsKt.sorted((Iterable)((List)destination$iv$iv)));
        $this$filter$iv = "\nChecking files: ";
        $i$f$filter = false;
        System.out.println($this$filter$iv);
        Iterable $this$forEach$iv = files;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            boolean bl2 = false;
            System.out.println(it);
        }
        List<HistoInfo> readHistos = new HistoReader().readHistos(files);
        ClassGrowthTrend analysis = new HistoAnalyser().analyse(readHistos);
        new TextReport().report(readHistos, analysis);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Lnl/stokpop/memory/MemoryCheck$Companion;", "", "()V", "useZoneOffset", "Ljava/time/ZoneId;", "memory-check"})
    public static final class Companion {
        @NotNull
        public final ZoneId useZoneOffset() {
            ZoneId zoneId = ZoneId.of("Europe/Amsterdam");
            Intrinsics.checkExpressionValueIsNotNull((Object)zoneId, (String)"ZoneId.of(\"Europe/Amsterdam\")");
            return zoneId;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

