/*
 * Decompiled with CFR 0.152.
 */
package nl.stokpop.memory;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import nl.stokpop.memory.HumanReadable;
import nl.stokpop.memory.TextReport;
import nl.stokpop.memory.domain.AnalysisResult;
import nl.stokpop.memory.domain.ClassGrowth;
import nl.stokpop.memory.domain.ClassGrowthTrend;
import nl.stokpop.memory.domain.HistoInfo;
import nl.stokpop.memory.domain.HistoLine;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J'\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0016\u0010\u0005\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0006H\u0002\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004H\u0002J\u001c\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\n\u00a8\u0006\u0015"}, d2={"Lnl/stokpop/memory/TextReport;", "", "()V", "diffOrNull", "", "it", "Lkotlin/Pair;", "(Lkotlin/Pair;)Ljava/lang/Long;", "largerThanBytesInLastHisto", "", "Lnl/stokpop/memory/domain/ClassGrowth;", "minSizeInBytes", "report", "", "histos", "", "Lnl/stokpop/memory/domain/HistoInfo;", "analysis", "Lnl/stokpop/memory/domain/ClassGrowthTrend;", "reportLine", "line", "memory-check"})
public final class TextReport {
    /*
     * WARNING - void declaration
     */
    public final void report(@NotNull List<HistoInfo> histos, @NotNull ClassGrowthTrend analysis) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(histos, (String)"histos");
        Intrinsics.checkParameterIsNotNull((Object)analysis, (String)"analysis");
        long minSizeInBytes = 1024L;
        String header = "Histogram report - " + LocalDateTime.now().format(DateTimeFormatter.ISO_DATE_TIME);
        String dashes2 = SequencesKt.joinToString$default((Sequence)SequencesKt.take((Sequence)SequencesKt.generateSequence((Function0)report.dashes.1.INSTANCE), (int)header.length()), (CharSequence)"", null, null, (int)0, null, (Function1)report.dashes.2.INSTANCE, (int)30, null);
        boolean bl = false;
        System.out.println((Object)dashes2);
        bl = false;
        System.out.println((Object)header);
        bl = false;
        System.out.println((Object)dashes2);
        bl = false;
        System.out.println();
        Iterable $this$forEach$iv = histos;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            HistoInfo it = (HistoInfo)element$iv;
            boolean bl2 = false;
            String string = "File: '" + it.getHistoFile().getName() + "' with date " + it.getTimestamp().format(DateTimeFormatter.ISO_DATE_TIME);
            boolean bl3 = false;
            System.out.println((Object)string);
        }
        boolean doReportUnknowns = false;
        boolean doReportShrinks = false;
        Object object = "\nNumber of GROW " + analysis.statusCount(AnalysisResult.GROW);
        boolean element$iv = false;
        System.out.println(object);
        object = "Number of STABLE " + analysis.statusCount(AnalysisResult.STABLE);
        element$iv = false;
        System.out.println(object);
        object = "Number of SHRINK " + analysis.statusCount(AnalysisResult.SHRINK);
        element$iv = false;
        System.out.println(object);
        object = "Number of UNKNOWN " + analysis.statusCount(AnalysisResult.UNKNOWN);
        element$iv = false;
        System.out.println(object);
        object = "\nBelow only results are printed that have remaining size of at least " + HumanReadable.INSTANCE.humanReadableMemorySize(minSizeInBytes) + " in last histogram.";
        element$iv = false;
        System.out.println(object);
        object = "\nFound possible memory leaks:";
        element$iv = false;
        System.out.println(object);
        Function1 bytesFilter2 = (Function1)new Function1<ClassGrowth, Boolean>(this, minSizeInBytes){
            final /* synthetic */ TextReport this$0;
            final /* synthetic */ long $minSizeInBytes;

            public final boolean invoke(@NotNull ClassGrowth it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return TextReport.access$largerThanBytesInLastHisto(this.this$0, it, this.$minSizeInBytes);
            }
            {
                this.this$0 = textReport;
                this.$minSizeInBytes = l;
                super(1);
            }
        };
        Iterable $this$filter$iv = analysis.statusFilter(AnalysisResult.GROW);
        boolean $i$f$filter = false;
        Iterable bl2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            if (!((Boolean)bytesFilter2.invoke(element$iv$iv)).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv2 = (List)destination$iv$iv;
        boolean $i$f$forEach2 = false;
        for (Object element$iv2 : $this$forEach$iv2) {
            ClassGrowth it = (ClassGrowth)element$iv2;
            boolean bl4 = false;
            this.reportLine(it);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean largerThanBytesInLastHisto(ClassGrowth it, long minSizeInBytes) {
        if (((HistoLine)CollectionsKt.last(it.getHistoLines())).getBytes() == null) return false;
        Long l = ((HistoLine)CollectionsKt.last(it.getHistoLines())).getBytes();
        if (l == null) {
            Intrinsics.throwNpe();
        }
        if (l <= minSizeInBytes) return false;
        return true;
    }

    public final void reportLine(@NotNull ClassGrowth line) {
        Object object;
        Long it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)line, (String)"line");
        String charForNull = "_";
        Iterable $this$map$iv = line.getHistoLines();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            HistoLine histoLine = (HistoLine)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            object = ((HistoLine)((Object)it)).getInstances();
            collection.add(object);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Long)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Object object2 = it;
            if (object2 == null || (object2 = String.valueOf((Long)object2)) == null) {
                object2 = charForNull;
            }
            object = object2;
            collection.add(object);
        }
        List instances = (List)destination$iv$iv;
        List instancesDiffs2 = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)SequencesKt.zipWithNext((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)line.getHistoLines()), (Function1)reportLine.instancesDiffs.1.INSTANCE)), (Function1)((Function1)new Function1<Pair<? extends Long, ? extends Long>, Long>(this){
            final /* synthetic */ TextReport this$0;

            @Nullable
            public final Long invoke(@NotNull Pair<Long, Long> it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                return TextReport.access$diffOrNull(this.this$0, it);
            }
            {
                this.this$0 = textReport;
                super(1);
            }
        })), (Function1)((Function1)new Function1<Long, String>(charForNull){
            final /* synthetic */ String $charForNull;

            @NotNull
            public final String invoke(@Nullable Long it) {
                Object object = it;
                if (object == null || (object = String.valueOf((Long)object)) == null) {
                    object = this.$charForNull;
                }
                return object;
            }
            {
                this.$charForNull = string;
                super(1);
            }
        })));
        Sequence bytes2 = SequencesKt.map((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)line.getHistoLines()), (Function1)reportLine.bytes.1.INSTANCE), (Function1)((Function1)new Function1<Long, String>(charForNull){
            final /* synthetic */ String $charForNull;

            @Nullable
            public final String invoke(@Nullable Long it) {
                return it == null ? this.$charForNull : HumanReadable.INSTANCE.humanReadableMemorySize(it);
            }
            {
                this.$charForNull = string;
                super(1);
            }
        }));
        Sequence bytesDiff2 = SequencesKt.map((Sequence)SequencesKt.map((Sequence)SequencesKt.zipWithNext((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)line.getHistoLines()), (Function1)reportLine.bytesDiff.1.INSTANCE)), (Function1)((Function1)new Function1<Pair<? extends Long, ? extends Long>, Long>(this){
            final /* synthetic */ TextReport this$0;

            @Nullable
            public final Long invoke(@NotNull Pair<Long, Long> it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                return TextReport.access$diffOrNull(this.this$0, it);
            }
            {
                this.this$0 = textReport;
                super(1);
            }
        })), (Function1)((Function1)new Function1<Long, String>(charForNull){
            final /* synthetic */ String $charForNull;

            @Nullable
            public final String invoke(@Nullable Long it) {
                return it == null ? this.$charForNull : HumanReadable.INSTANCE.humanReadableMemorySize(it);
            }
            {
                this.$charForNull = string;
                super(1);
            }
        }));
        String string = line.getClassName().getName() + " instances: " + instances + " diff: " + instancesDiffs2 + " size: " + bytes2 + " diff: " + bytesDiff2;
        boolean bl = false;
        System.out.println((Object)string);
    }

    private final Long diffOrNull(Pair<Long, Long> it) {
        Long l;
        if (it.getFirst() == null || it.getSecond() == null) {
            l = null;
        } else {
            Object object = it.getSecond();
            if (object == null) {
                Intrinsics.throwNpe();
            }
            long l2 = ((Number)object).longValue();
            Object object2 = it.getFirst();
            if (object2 == null) {
                Intrinsics.throwNpe();
            }
            l = l2 - ((Number)object2).longValue();
        }
        return l;
    }

    public static final /* synthetic */ boolean access$largerThanBytesInLastHisto(TextReport $this, ClassGrowth it, long minSizeInBytes) {
        return $this.largerThanBytesInLastHisto(it, minSizeInBytes);
    }

    public static final /* synthetic */ Long access$diffOrNull(TextReport $this, Pair it) {
        return $this.diffOrNull((Pair<Long, Long>)it);
    }
}

