/*
 * Decompiled with CFR 0.152.
 */
package nl.stokpop.memory.report;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import nl.stokpop.memory.domain.AnalysisResult;
import nl.stokpop.memory.domain.ClassGrowth;
import nl.stokpop.memory.domain.ClassGrowthTrend;
import nl.stokpop.memory.domain.ClassName;
import nl.stokpop.memory.domain.HeapHistogramDumpLine;
import nl.stokpop.memory.domain.json.ClassHistogramDetails;
import nl.stokpop.memory.domain.json.HeapHistogramDumpDetails;
import nl.stokpop.memory.domain.json.HeapHistogramDumpReport;
import nl.stokpop.memory.domain.json.HeapHistogramDumpSummary;
import nl.stokpop.memory.report.ReportAnalyser;
import nl.stokpop.memory.report.ReportConfig;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004H\u0002J\u001e\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004H\u0002J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u001e\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004H\u0002J\u001e\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004H\u0002J'\u0010\u0011\u001a\u0004\u0018\u00010\u00052\u0016\u0010\u0012\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0013H\u0002\u00a2\u0006\u0002\u0010\u0014J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0005H\u0002\u00a8\u0006\u0019"}, d2={"Lnl/stokpop/memory/report/ReportAnalyser;", "", "()V", "createBytesDiffList", "", "", "histoLines", "Lnl/stokpop/memory/domain/HeapHistogramDumpLine;", "createBytesList", "createHeapHistogramDumpReport", "Lnl/stokpop/memory/domain/json/HeapHistogramDumpReport;", "classGrowthTrend", "Lnl/stokpop/memory/domain/ClassGrowthTrend;", "reportConfig", "Lnl/stokpop/memory/report/ReportConfig;", "createInstancesDiffList", "createInstancesList", "diffOrNull", "it", "Lkotlin/Pair;", "(Lkotlin/Pair;)Ljava/lang/Long;", "largerThanBytesInLastHisto", "", "Lnl/stokpop/memory/domain/json/ClassHistogramDetails;", "minSizeInBytes", "memory-check"})
public final class ReportAnalyser {
    public static final ReportAnalyser INSTANCE;

    @NotNull
    public final HeapHistogramDumpReport createHeapHistogramDumpReport(@NotNull ClassGrowthTrend classGrowthTrend, @NotNull ReportConfig reportConfig) {
        AnalysisResult analysisResult;
        Intrinsics.checkParameterIsNotNull((Object)classGrowthTrend, (String)"classGrowthTrend");
        Intrinsics.checkParameterIsNotNull((Object)reportConfig, (String)"reportConfig");
        Map analysisResultToCount2 = MapsKt.toMap((Sequence)SequencesKt.map((Sequence)ArraysKt.asSequence((Object[])AnalysisResult.values()), (Function1)((Function1)new Function1<AnalysisResult, Pair<? extends AnalysisResult, ? extends Integer>>(classGrowthTrend, reportConfig){
            final /* synthetic */ ClassGrowthTrend $classGrowthTrend;
            final /* synthetic */ ReportConfig $reportConfig;

            @NotNull
            public final Pair<AnalysisResult, Integer> invoke(@NotNull AnalysisResult it) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)it), (String)"it");
                return TuplesKt.to((Object)((Object)it), (Object)this.$classGrowthTrend.statusCount(it, this.$reportConfig.getByteLimit()));
            }
            {
                this.$classGrowthTrend = classGrowthTrend;
                this.$reportConfig = reportConfig;
                super(1);
            }
        })));
        HeapHistogramDumpSummary heapHistogramDumpSummary = new HeapHistogramDumpSummary(analysisResultToCount2);
        Integer n = heapHistogramDumpSummary.getData().get((Object)AnalysisResult.GROW);
        if ((n != null ? n : 0) > 0) {
            analysisResult = AnalysisResult.GROW;
        } else {
            Integer n2 = heapHistogramDumpSummary.getData().get((Object)AnalysisResult.SHRINK);
            if ((n2 != null ? n2 : 0) > 0) {
                analysisResult = AnalysisResult.SHRINK;
            } else {
                Integer n3 = heapHistogramDumpSummary.getData().get((Object)AnalysisResult.STABLE);
                analysisResult = (n3 != null ? n3 : 0) > 0 ? AnalysisResult.STABLE : AnalysisResult.UNKNOWN;
            }
        }
        AnalysisResult leakResult = analysisResult;
        Function1 analysisFilter2 = (Function1)new Function1<Map.Entry<? extends ClassName, ? extends ClassGrowth>, Boolean>(reportConfig){
            final /* synthetic */ ReportConfig $reportConfig;

            public final boolean invoke(@NotNull Map.Entry<ClassName, ClassGrowth> it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                return this.$reportConfig.getDoReportGrow() && it.getValue().getAnalysisResult() == AnalysisResult.GROW || this.$reportConfig.getDoReportShrinks() && it.getValue().getAnalysisResult() == AnalysisResult.SHRINK || this.$reportConfig.getDoReportStable() && it.getValue().getAnalysisResult() == AnalysisResult.STABLE || this.$reportConfig.getDoReportUnknowns() && it.getValue().getAnalysisResult() == AnalysisResult.UNKNOWN;
            }
            {
                this.$reportConfig = reportConfig;
                super(1);
            }
        };
        List classHistogramDumpDetails2 = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)classGrowthTrend.getData().entrySet()), (Function1)analysisFilter2), (Function1)createHeapHistogramDumpReport.classHistogramDumpDetails.1.INSTANCE), (Function1)((Function1)new Function1<ClassHistogramDetails, Boolean>(reportConfig){
            final /* synthetic */ ReportConfig $reportConfig;

            public final boolean invoke(@NotNull ClassHistogramDetails it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return ReportAnalyser.access$largerThanBytesInLastHisto(ReportAnalyser.INSTANCE, it, this.$reportConfig.getByteLimit());
            }
            {
                this.$reportConfig = reportConfig;
                super(1);
            }
        })));
        HeapHistogramDumpDetails heapHistogramDumpDetails = new HeapHistogramDumpDetails(classHistogramDumpDetails2, classGrowthTrend.getTimestamps());
        return new HeapHistogramDumpReport(reportConfig, leakResult, heapHistogramDumpSummary, heapHistogramDumpDetails);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean largerThanBytesInLastHisto(ClassHistogramDetails it, long minSizeInBytes) {
        if (CollectionsKt.last(it.getBytes()) == null) return false;
        Object object = CollectionsKt.last(it.getBytes());
        if (object == null) {
            Intrinsics.throwNpe();
        }
        if (((Number)object).longValue() <= minSizeInBytes) return false;
        return true;
    }

    private final List<Long> createInstancesList(List<HeapHistogramDumpLine> histoLines) {
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)histoLines), (Function1)createInstancesList.1.INSTANCE));
    }

    private final List<Long> createInstancesDiffList(List<HeapHistogramDumpLine> histoLines) {
        return CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)0L), (Iterable)SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.zipWithNext((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)histoLines), (Function1)createInstancesDiffList.1.INSTANCE)), (Function1)createInstancesDiffList.2.INSTANCE)));
    }

    private final List<Long> createBytesDiffList(List<HeapHistogramDumpLine> histoLines) {
        return CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)0L), (Iterable)SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.zipWithNext((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)histoLines), (Function1)createBytesDiffList.1.INSTANCE)), (Function1)createBytesDiffList.2.INSTANCE)));
    }

    private final List<Long> createBytesList(List<HeapHistogramDumpLine> histoLines) {
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)histoLines), (Function1)createBytesList.1.INSTANCE));
    }

    private final Long diffOrNull(Pair<Long, Long> it) {
        Long l;
        if (it.getFirst() == null || it.getSecond() == null) {
            l = null;
        } else {
            Object object = it.getSecond();
            if (object == null) {
                Intrinsics.throwNpe();
            }
            long l2 = ((Number)object).longValue();
            Object object2 = it.getFirst();
            if (object2 == null) {
                Intrinsics.throwNpe();
            }
            l = l2 - ((Number)object2).longValue();
        }
        return l;
    }

    private ReportAnalyser() {
    }

    static {
        ReportAnalyser reportAnalyser;
        INSTANCE = reportAnalyser = new ReportAnalyser();
    }

    public static final /* synthetic */ List access$createBytesList(ReportAnalyser $this, List histoLines) {
        return $this.createBytesList(histoLines);
    }

    public static final /* synthetic */ List access$createBytesDiffList(ReportAnalyser $this, List histoLines) {
        return $this.createBytesDiffList(histoLines);
    }

    public static final /* synthetic */ List access$createInstancesList(ReportAnalyser $this, List histoLines) {
        return $this.createInstancesList(histoLines);
    }

    public static final /* synthetic */ List access$createInstancesDiffList(ReportAnalyser $this, List histoLines) {
        return $this.createInstancesDiffList(histoLines);
    }

    public static final /* synthetic */ boolean access$largerThanBytesInLastHisto(ReportAnalyser $this, ClassHistogramDetails it, long minSizeInBytes) {
        return $this.largerThanBytesInLastHisto(it, minSizeInBytes);
    }

    public static final /* synthetic */ Long access$diffOrNull(ReportAnalyser $this, Pair it) {
        return $this.diffOrNull((Pair<Long, Long>)it);
    }
}

