/*
 * Decompiled with CFR 0.152.
 */
package nl.stokpop.memory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import nl.stokpop.memory.HistoAnalyser;
import nl.stokpop.memory.MemoryCheck;
import nl.stokpop.memory.domain.AnalysisResult;
import nl.stokpop.memory.domain.ClassGrowth;
import nl.stokpop.memory.domain.ClassGrowthTrend;
import nl.stokpop.memory.domain.ClassName;
import nl.stokpop.memory.domain.HeapHistogramDump;
import nl.stokpop.memory.domain.HeapHistogramDumpLine;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J,\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00062\u0016\b\u0002\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\rJ\u001e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u00a8\u0006\u0013"}, d2={"Lnl/stokpop/memory/HistoAnalyser;", "", "()V", "analyse", "Lnl/stokpop/memory/domain/ClassGrowthTrend;", "histos", "", "Lnl/stokpop/memory/domain/HeapHistogramDump;", "analyseGrowth", "Lnl/stokpop/memory/domain/AnalysisResult;", "histoLines", "Lnl/stokpop/memory/domain/HeapHistogramDumpLine;", "thingToCheck", "Lkotlin/Function1;", "", "processClassNameForHistoInfos", "Lnl/stokpop/memory/domain/ClassGrowth;", "name", "Lnl/stokpop/memory/domain/ClassName;", "memory-check"})
public final class HistoAnalyser {
    public static final HistoAnalyser INSTANCE;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ClassGrowthTrend analyse(@NotNull List<HeapHistogramDump> histos) {
        void $this$mapTo$iv$iv;
        Long l;
        Collection collection;
        void $this$mapTo$iv$iv2;
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(histos, (String)"histos");
        if (histos.isEmpty()) {
            return new ClassGrowthTrend(CollectionsKt.emptyList(), MapsKt.emptyMap());
        }
        Iterable $this$flatMap$iv = histos;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            HeapHistogramDump it = (HeapHistogramDump)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.findAllClassNames();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Set classNames = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Iterable $this$map$iv = histos;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            HeapHistogramDump bl = (HeapHistogramDump)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            l = it.getTimestamp().atZone(MemoryCheck.Companion.useZoneOffset()).toInstant().toEpochMilli();
            collection.add(l);
        }
        List timestamps = CollectionsKt.toList((Iterable)((List)destination$iv$iv2));
        Iterable $this$map$iv2 = classNames;
        boolean $i$f$map2 = false;
        destination$iv$iv2 = $this$map$iv2;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ClassName bl2 = (ClassName)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl = false;
            l = TuplesKt.to((Object)it, (Object)INSTANCE.processClassNameForHistoInfos((ClassName)it, histos));
            collection.add(l);
        }
        Iterable $this$sortedBy$iv = CollectionsKt.toList((Iterable)((List)destination$iv$iv3));
        boolean $i$f$sortedBy = false;
        Iterable iterable2 = $this$sortedBy$iv;
        boolean bl = false;
        Comparator comparator = new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Pair $dstr$_u24__u24$value = (Pair)a;
                boolean bl2 = false;
                ClassGrowth value = (ClassGrowth)$dstr$_u24__u24$value.component2();
                $dstr$_u24__u24$value = (Pair)b;
                Comparable comparable = ((HeapHistogramDumpLine)CollectionsKt.last(value.getHistoLines())).getBytes();
                bl2 = false;
                value = (ClassGrowth)$dstr$_u24__u24$value.component2();
                Long l = ((HeapHistogramDumpLine)CollectionsKt.last(value.getHistoLines())).getBytes();
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)l);
            }
        };
        Map data = MapsKt.toMap((Iterable)CollectionsKt.reversed((Iterable)CollectionsKt.sortedWith((Iterable)iterable2, (Comparator)comparator)));
        return new ClassGrowthTrend(timestamps, data);
    }

    /*
     * WARNING - void declaration
     */
    private final ClassGrowth processClassNameForHistoInfos(ClassName name, List<HeapHistogramDump> histos) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = histos;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            HeapHistogramDumpLine heapHistogramDumpLine;
            Object v0;
            Collection collection;
            block3: {
                void it;
                HeapHistogramDump heapHistogramDump = (HeapHistogramDump)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                Iterable $this$firstOrNull$iv = it.getHistogram();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    HeapHistogramDumpLine it2 = (HeapHistogramDumpLine)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)name, (Object)it2.getClassName())) continue;
                    v0 = element$iv;
                    break block3;
                }
                v0 = null;
            }
            if ((heapHistogramDumpLine = (HeapHistogramDumpLine)v0) == null) {
                heapHistogramDumpLine = HeapHistogramDumpLine.Companion.createGhostLine(name);
            }
            HeapHistogramDumpLine heapHistogramDumpLine2 = heapHistogramDumpLine;
            collection.add(heapHistogramDumpLine2);
        }
        List histosForClassName = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        return new ClassGrowth(name, histosForClassName, this.analyseGrowth(histosForClassName, (Function1<? super HeapHistogramDumpLine, Long>)((Function1)processClassNameForHistoInfos.1.INSTANCE)));
    }

    @NotNull
    public final AnalysisResult analyseGrowth(@NotNull List<HeapHistogramDumpLine> histoLines, @NotNull Function1<? super HeapHistogramDumpLine, Long> thingToCheck) {
        Intrinsics.checkParameterIsNotNull(histoLines, (String)"histoLines");
        Intrinsics.checkParameterIsNotNull(thingToCheck, (String)"thingToCheck");
        if (histoLines.isEmpty()) {
            return AnalysisResult.UNKNOWN;
        }
        int histoSize = histoLines.size();
        if (histoSize == 1) {
            return AnalysisResult.UNKNOWN;
        }
        int compareSize = histoSize - 1;
        int growthCount = 0;
        int shrinkCount = 0;
        int stableCount = 0;
        int ghostCount = 0;
        boolean lastIsGhost = false;
        long lastValue = -1L;
        for (HeapHistogramDumpLine line : histoLines) {
            lastIsGhost = false;
            if (line.isGhost()) {
                ++ghostCount;
                lastIsGhost = true;
                continue;
            }
            Object object = thingToCheck.invoke((Object)line);
            if (object == null) {
                Intrinsics.throwNpe();
            }
            long currentValue = ((Number)object).longValue();
            if (lastValue != -1L) {
                if (lastValue < currentValue) {
                    ++growthCount;
                } else if (lastValue > currentValue) {
                    ++shrinkCount;
                } else {
                    ++stableCount;
                }
            }
            lastValue = currentValue;
        }
        if (ghostCount == compareSize) {
            return AnalysisResult.UNKNOWN;
        }
        if (growthCount > 0 && growthCount + ghostCount + stableCount == compareSize && !lastIsGhost) {
            return AnalysisResult.GROW;
        }
        if (growthCount + ghostCount == compareSize && lastIsGhost) {
            return AnalysisResult.UNKNOWN;
        }
        if (shrinkCount > 0 && shrinkCount + ghostCount + stableCount == compareSize) {
            return AnalysisResult.SHRINK;
        }
        if (stableCount + ghostCount == compareSize) {
            return AnalysisResult.STABLE;
        }
        return AnalysisResult.UNKNOWN;
    }

    public static /* synthetic */ AnalysisResult analyseGrowth$default(HistoAnalyser histoAnalyser, List list, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = analyseGrowth.1.INSTANCE;
        }
        return histoAnalyser.analyseGrowth(list, (Function1<? super HeapHistogramDumpLine, Long>)function1);
    }

    private HistoAnalyser() {
    }

    static {
        HistoAnalyser histoAnalyser;
        INSTANCE = histoAnalyser = new HistoAnalyser();
    }
}

