/*
 * Decompiled with CFR 0.152.
 */
package nl.stokpop.memory.report;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.Regex;
import nl.stokpop.memory.HumanReadable;
import nl.stokpop.memory.domain.AnalysisResult;
import nl.stokpop.memory.domain.json.ClassHistogramDetails;
import nl.stokpop.memory.domain.json.HeapHistogramDumpReport;
import nl.stokpop.memory.report.HtmlGraphCreator;
import nl.stokpop.memory.report.HtmlGraphCreator$WhenMappings;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\f\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0002J>\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\u000e\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u00112\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00130\u00112\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J>\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\u000e\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u00112\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00130\u00112\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0016H\u0002JJ\u0010\u0018\u001a\u00020\u00042\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00130\u00112\u000e\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u00112\u001a\u0010\u0019\u001a\u0016\u0012\u0004\u0012\u00020\u0013\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u00110\u001a2\u0006\u0010\u001b\u001a\u00020\u0016H\u0002J>\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\u000e\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u00112\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00130\u00112\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J>\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\u000e\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u00112\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00130\u00112\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020 H\u0002J\u000e\u0010!\u001a\u00020\"2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lnl/stokpop/memory/report/HtmlGraphCreator;", "", "()V", "CHART_HTML_TEMPLATE", "", "arrowDown", "", "arrowFlat", "arrowUp", "arrowUpDown", "nonBreakSpace", "analysisResultTable", "data", "Lnl/stokpop/memory/domain/json/HeapHistogramDumpReport;", "createBytesTable", "title", "timestamps", "", "", "Lnl/stokpop/memory/domain/json/ClassHistogramDetails;", "template", "classLimit", "", "createBytesTableDiff", "createChartDataTable", "detailsMapper", "Lkotlin/Function1;", "limit", "createInstancesTable", "createInstancesTableDiff", "mapToUnicodeArrow", "analysis", "Lnl/stokpop/memory/domain/AnalysisResult;", "writeHtmlGoogleGraphFile", "Ljava/io/File;", "memory-check"})
public final class HtmlGraphCreator {
    private static char arrowUp;
    private static char arrowUpDown;
    private static char arrowDown;
    private static char arrowFlat;
    private static char nonBreakSpace;
    private static final String CHART_HTML_TEMPLATE = "\n<html>\n  <head>\n    <meta charset=\"UTF-8\">\n\n    <link rel=\"stylesheet\" href=\"https://fonts.googleapis.com/css?family=Roboto:300,300italic,700,700italic\">\n    <link rel=\"stylesheet\" href=\"https://cdnjs.cloudflare.com/ajax/libs/normalize/8.0.1/normalize.css\">\n    <link rel=\"stylesheet\" href=\"https://cdnjs.cloudflare.com/ajax/libs/milligram/1.4.0/milligram.css\">    \n\n    <script type=\"text/javascript\" src=\"https://www.google.com/jsapi\"></script>\n    <script type=\"text/javascript\">\n      google.load(\"visualization\", \"1\", {packages:[\"corechart\"]});\n      google.setOnLoadCallback(drawChart);\n      function drawChart() {\n        var date_formatter = new google.visualization.DateFormat({ pattern: \"HH:mm:ss.SSS\" });\n        \n        // CHART BYTES\n        \n        var dataBytes = google.visualization.arrayToDataTable([\n          ###TABLE_BYTES###\n        ]);\n        date_formatter.format(dataBytes, 0);\n\n        var optionsBytes = {\n          title: '###TITLE_BYTES###',\n          hAxis: {title: '###H_AXIS_TITLE_BYTES###',  titleTextStyle: {color: '#333'}, format: 'dd-MM HH:mm', minorGridlines: {count: 10, format: 'mm'} },\n          vAxis: {title: '###V_AXIS_TITLE_BYTES###', scaleType: 'log', viewWindow: {} },\n          chartArea: { left:'10%', width:'60%' }\n        };\n\n        var chartBytes = new google.visualization.LineChart(document.getElementById('chart_div_bytes'));\n        chartBytes.draw(dataBytes, optionsBytes);\n\n        // CHART BYTES DIFF\n        \n        var dataBytesDiff = google.visualization.arrayToDataTable([\n          ###TABLE_BYTES_DIFF###\n        ]);\n        date_formatter.format(dataBytesDiff, 0);\n        \n        var optionsBytesDiff = {\n          title: '###TITLE_BYTES_DIFF###',\n          hAxis: {title: '###H_AXIS_TITLE_BYTES_DIFF###',  titleTextStyle: {color: '#333'}, format: 'dd-MM HH:mm', minorGridlines: {count: 10, format: 'mm'} },\n          vAxis: {title: '###V_AXIS_TITLE_BYTES_DIFF###', scaleType: 'mirrorLog', viewWindow: {} },\n          chartArea: { left:'10%', width:'60%' }\n        };\n\n        var chartBytesDiff = new google.visualization.LineChart(document.getElementById('chart_div_bytes_diff'));\n        chartBytesDiff.draw(dataBytesDiff, optionsBytesDiff);\n\n        // CHART INSTANCES\n        \n        var dataInstances = google.visualization.arrayToDataTable([\n          ###TABLE_INSTANCES###\n        ]);\n        date_formatter.format(dataInstances, 0);\n\n        var optionsInstances = {\n          title: '###TITLE_INSTANCES###',\n          hAxis: {title: '###H_AXIS_TITLE_INSTANCES###',  titleTextStyle: {color: '#333'}, format: 'dd-MM HH:mm', minorGridlines: {count: 10, format: 'mm'} },\n          vAxis: {title: '###V_AXIS_TITLE_INSTANCES###', scaleType: 'log', viewWindow: {} },\n          chartArea: { left:'10%', width:'60%' }\n        };\n\n        var chartInstances = new google.visualization.LineChart(document.getElementById('chart_div_instances'));\n        chartInstances.draw(dataInstances, optionsInstances);\n\n        // CHART INSTANCES DIFF\n        \n        var dataInstancesDiff = google.visualization.arrayToDataTable([\n          ###TABLE_INSTANCES_DIFF###\n        ]);\n        date_formatter.format(dataInstancesDiff, 0);\n\n        var optionsInstancesDiff = {\n          title: '###TITLE_INSTANCES_DIFF###',\n          hAxis: {title: '###H_AXIS_TITLE_INSTANCES_DIFF###',  titleTextStyle: {color: '#333'}, format: 'dd-MM HH:mm', minorGridlines: {count: 10, format: 'mm'} },\n          vAxis: {title: '###V_AXIS_TITLE_INSTANCES_DIFF###', scaleType: 'mirrorLog', viewWindow: {} },\n          chartArea: { left:'10%', width:'60%' }\n        };\n\n        var chartBytesDiff = new google.visualization.LineChart(document.getElementById('chart_div_instances_diff'));\n        chartBytesDiff.draw(dataInstancesDiff, optionsInstancesDiff);\n\n    }\n    </script>\n  </head>\n  <body>\n    <div style=\"margin: 5%\">\n    <h1>Stokpop Memory Check</h2>\n    <h2>Heap Histogram Dumps Analysis</h2>\n    ###ANALYSIS-RESULT-SUMMARY###\n    <h2>Heap Histogram Dumps Charts</h2>\n    </div>\n    <div id=\"chart_div_bytes\" style=\"width: 96%; min-height: 800px; height: 50%; margin-left: auto; margin-right: auto\"></div>\n    <div id=\"chart_div_bytes_diff\" style=\"width: 96%; min-height: 800px; height: 50%; margin-left: auto; margin-right: auto\"></div>\n    <div id=\"chart_div_instances\" style=\"width: 96%; min-height: 800px; height: 50%; margin-left: auto; margin-right: auto\"></div>\n    <div id=\"chart_div_instances_diff\" style=\"width: 96%; min-height: 800px; height: 50%; margin-left: auto; margin-right: auto\"></div>\n  </body>\n</html>";
    public static final HtmlGraphCreator INSTANCE;

    @NotNull
    public final File writeHtmlGoogleGraphFile(@NotNull HeapHistogramDumpReport data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        String title = data.getReportConfig().getIdentifier();
        List<Long> timestamps = data.getHeapHistogramDumpDetails().getTimestamps();
        String template = CHART_HTML_TEMPLATE;
        int size = timestamps.size();
        if (size < 3) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "Not enough points ([%d]<3) to create html graph for [%s].";
            Object[] objectArray = new Object[]{size, title};
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
            String message = string2;
            boolean bl2 = false;
            System.out.println((Object)message);
            template = "<p>" + message + "<p>";
        } else {
            String message = "###ANALYSIS-RESULT-SUMMARY###";
            boolean bl = false;
            template = new Regex(message).replace((CharSequence)template, this.analysisResultTable(data));
            int classLimit = data.getReportConfig().getClassLimit();
            template = this.createBytesTable(title, timestamps, data.getHeapHistogramDumpDetails().getClassHistogramDetails(), template, classLimit);
            template = this.createBytesTableDiff(title, timestamps, data.getHeapHistogramDumpDetails().getClassHistogramDetails(), template, classLimit);
            template = this.createInstancesTable(title, timestamps, data.getHeapHistogramDumpDetails().getClassHistogramDetails(), template, classLimit);
            template = this.createInstancesTableDiff(title, timestamps, data.getHeapHistogramDumpDetails().getClassHistogramDetails(), template, classLimit);
        }
        File file = new File(data.getReportConfig().getReportDirectory(), "heapHistogramDumpReport-" + title + ".html");
        FilesKt.writeText$default((File)file, (String)template, null, (int)2, null);
        return file;
    }

    /*
     * WARNING - void declaration
     */
    private final String analysisResultTable(HeapHistogramDumpReport data) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        StringBuilder html = new StringBuilder(2048);
        html.append("<table>");
        html.append("<tr><th>key</th><th>value</th></tr>");
        html.append("<tr><td>Test run id</td><td><b>" + data.getReportConfig().getIdentifier() + "</b></td></tr>").append("\n");
        html.append("<tr><td>Report date</td><td><b>" + data.getReportConfig().getReportDateTime() + "</b></td></tr>").append("\n");
        html.append("<tr><td>Overall analysis result</td><td><b>" + (Object)((Object)data.getLeakResult()) + "</b></td></tr>").append("\n");
        html.append("<tr><td>Report settings</td><td><b>" + data.getReportConfig().getSettings() + "</b></td></tr>").append("\n");
        html.append("<tr><td>Report class limit</td><td><b>" + data.getReportConfig().getClassLimit() + "</b></td></tr>").append("\n");
        html.append("<tr><td>Report byte limit</td><td><b>" + HumanReadable.INSTANCE.humanReadableMemorySize(data.getReportConfig().getByteLimit()) + "</b></td></tr>").append("\n");
        html.append("<table>");
        html.append("<table>").append("\n");
        html.append("<tr><th>analysis result</th><th>count</th><th>icon</th></tr>");
        Map<AnalysisResult, Integer> map = data.getHeapHistogramDumpSummary().getData();
        StringBuilder stringBuilder = html;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        void var8_9 = $this$mapTo$iv$iv;
        boolean bl = false;
        Iterator iterator = var8_9.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            collection = destination$iv$iv;
            boolean bl2 = false;
            String string = "<tr><td>" + (Object)((Object)((AnalysisResult)((Object)it.getKey()))) + "</td><td>" + ((Number)it.getValue()).intValue() + "</td><td>" + INSTANCE.mapToUnicodeArrow((AnalysisResult)((Object)it.getKey())) + "</td></tr>";
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        stringBuilder.append(CollectionsKt.joinToString$default((Iterable)collection, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
        html.append("</table>");
        String string = html.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"html.toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final String createChartDataTable(List<ClassHistogramDetails> data, List<Long> timestamps, Function1<? super ClassHistogramDetails, ? extends List<Long>> detailsMapper2, int limit) {
        void $this$mapTo$iv$iv;
        Object object;
        Collection collection;
        void $this$mapTo$iv$iv2;
        StringBuilder table = new StringBuilder();
        Iterable $this$map$iv = CollectionsKt.take((Iterable)data, (int)limit);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            ClassHistogramDetails classHistogramDetails = (ClassHistogramDetails)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            object = "" + INSTANCE.mapToUnicodeArrow(it.getAnalysis()) + nonBreakSpace + it.getClassName();
            collection.add(object);
        }
        List classNames = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        Iterable $this$map$iv2 = CollectionsKt.take((Iterable)data, (int)limit);
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            destination$iv$iv2.add(detailsMapper2.invoke(item$iv$iv));
        }
        List detailsList = CollectionsKt.toList((Iterable)((List)destination$iv$iv2));
        table.append("['Time'");
        $this$map$iv2 = classNames;
        $i$f$map2 = false;
        if (!$this$map$iv2.isEmpty()) {
            void $this$mapTo$iv$iv3;
            Iterable $this$map$iv3 = classNames;
            boolean $i$f$map3 = false;
            destination$iv$iv2 = $this$map$iv3;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                void it;
                String string = (String)item$iv$iv;
                collection = destination$iv$iv3;
                boolean bl = false;
                object = '\'' + (String)it + '\'';
                collection.add(object);
            }
            String classNamesList = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv3), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
            table.append(", ").append(classNamesList);
        } else {
            table.append(", 'No Data'");
        }
        table.append("],\n");
        int i = 0;
        for (Long timestamp : timestamps) {
            table.append("[ new Date(").append(timestamp).append(")");
            Collection $this$mapTo$iv$iv3 = detailsList;
            boolean destination$iv$iv3 = false;
            if (!$this$mapTo$iv$iv3.isEmpty()) {
                void $this$mapTo$iv$iv4;
                Object item$iv$iv;
                table.append(", ");
                Iterable $this$map$iv4 = detailsList;
                boolean $i$f$map4 = false;
                item$iv$iv = $this$map$iv4;
                Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv4, (int)10));
                boolean $i$f$mapTo4 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv4) {
                    void it;
                    List list = (List)item$iv$iv2;
                    collection = destination$iv$iv4;
                    boolean bl = false;
                    Long l = (Long)it.get(i);
                    object = l != null ? l : 0L;
                    collection.add(object);
                }
                String bytesForTimestamp = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv4), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
                table.append(bytesForTimestamp);
            } else {
                table.append(", 0");
            }
            table.append("]").append(",").append("\n");
            int n = i;
            i = n + 1;
        }
        table.deleteCharAt(table.length() - 2);
        String string = table.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"table.toString()");
        return string;
    }

    private final char mapToUnicodeArrow(AnalysisResult analysis) {
        char c;
        switch (HtmlGraphCreator$WhenMappings.$EnumSwitchMapping$0[analysis.ordinal()]) {
            case 1: {
                c = arrowUp;
                break;
            }
            case 2: {
                c = arrowDown;
                break;
            }
            case 3: {
                c = arrowFlat;
                break;
            }
            case 4: {
                c = arrowUpDown;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return c;
    }

    private final String createBytesTable(String title, List<Long> timestamps, List<ClassHistogramDetails> data, String template, int classLimit) {
        String newTemplate = template;
        Function1 detailsMapper2 = createBytesTable.detailsMapper.1.INSTANCE;
        String table = this.createChartDataTable(data, timestamps, (Function1<? super ClassHistogramDetails, ? extends List<Long>>)detailsMapper2, classLimit);
        String string = "###TABLE_BYTES###";
        boolean bl = false;
        newTemplate = new Regex(string).replace((CharSequence)newTemplate, Regex.Companion.escapeReplacement(table));
        string = "###TITLE_BYTES###";
        bl = false;
        newTemplate = new Regex(string).replace((CharSequence)newTemplate, "bytes in heap - " + title);
        string = "###H_AXIS_TITLE_BYTES###";
        bl = false;
        newTemplate = new Regex(string).replace((CharSequence)newTemplate, "time");
        string = "###V_AXIS_TITLE_BYTES###";
        bl = false;
        newTemplate = new Regex(string).replace((CharSequence)newTemplate, "bytes");
        string = "###BASE_UNIT_FULL_BYTES###";
        bl = false;
        newTemplate = new Regex(string).replace((CharSequence)newTemplate, "bytes");
        string = "###BASE_UNIT_SHORT_BYTES###";
        bl = false;
        newTemplate = new Regex(string).replace((CharSequence)newTemplate, "B");
        return newTemplate;
    }

    private final String createBytesTableDiff(String title, List<Long> timestamps, List<ClassHistogramDetails> data, String template, int classLimit) {
        String newTemplate = template;
        Function1 detailsMapper2 = createBytesTableDiff.detailsMapper.1.INSTANCE;
        String table = this.createChartDataTable(data, timestamps, (Function1<? super ClassHistogramDetails, ? extends List<Long>>)detailsMapper2, classLimit);
        String string = "###TABLE_BYTES_DIFF###";
        boolean bl = false;
        newTemplate = new Regex(string).replace((CharSequence)newTemplate, Regex.Companion.escapeReplacement(table));
        string = "###TITLE_BYTES_DIFF###";
        bl = false;
        newTemplate = new Regex(string).replace((CharSequence)newTemplate, "bytes diff in heap - " + title);
        string = "###H_AXIS_TITLE_BYTES_DIFF###";
        bl = false;
        newTemplate = new Regex(string).replace((CharSequence)newTemplate, "time");
        string = "###V_AXIS_TITLE_BYTES_DIFF###";
        bl = false;
        newTemplate = new Regex(string).replace((CharSequence)newTemplate, "bytes diff");
        string = "###BASE_UNIT_FULL_BYTES_DIFF###";
        bl = false;
        newTemplate = new Regex(string).replace((CharSequence)newTemplate, "bytes");
        string = "###BASE_UNIT_SHORT_BYTES_DIFF###";
        bl = false;
        newTemplate = new Regex(string).replace((CharSequence)newTemplate, "B");
        return newTemplate;
    }

    private final String createInstancesTable(String title, List<Long> timestamps, List<ClassHistogramDetails> data, String template, int classLimit) {
        String newTemplate = template;
        Function1 detailsMapper2 = createInstancesTable.detailsMapper.1.INSTANCE;
        String table = this.createChartDataTable(data, timestamps, (Function1<? super ClassHistogramDetails, ? extends List<Long>>)detailsMapper2, classLimit);
        String string = "###TABLE_INSTANCES###";
        boolean bl = false;
        newTemplate = new Regex(string).replace((CharSequence)newTemplate, Regex.Companion.escapeReplacement(table));
        string = "###TITLE_INSTANCES###";
        bl = false;
        newTemplate = new Regex(string).replace((CharSequence)newTemplate, "instances in heap - " + title);
        string = "###H_AXIS_TITLE_INSTANCES###";
        bl = false;
        newTemplate = new Regex(string).replace((CharSequence)newTemplate, "time");
        string = "###V_AXIS_TITLE_INSTANCES###";
        bl = false;
        newTemplate = new Regex(string).replace((CharSequence)newTemplate, "instances");
        string = "###BASE_UNIT_FULL_INSTANCES###";
        bl = false;
        newTemplate = new Regex(string).replace((CharSequence)newTemplate, "instances");
        string = "###BASE_UNIT_SHORT_INSTANCES###";
        bl = false;
        newTemplate = new Regex(string).replace((CharSequence)newTemplate, "#");
        return newTemplate;
    }

    private final String createInstancesTableDiff(String title, List<Long> timestamps, List<ClassHistogramDetails> data, String template, int classLimit) {
        String newTemplate = template;
        Function1 detailsMapper2 = createInstancesTableDiff.detailsMapper.1.INSTANCE;
        String table = this.createChartDataTable(data, timestamps, (Function1<? super ClassHistogramDetails, ? extends List<Long>>)detailsMapper2, classLimit);
        String string = "###TABLE_INSTANCES_DIFF###";
        boolean bl = false;
        newTemplate = new Regex(string).replace((CharSequence)newTemplate, Regex.Companion.escapeReplacement(table));
        string = "###TITLE_INSTANCES_DIFF###";
        bl = false;
        newTemplate = new Regex(string).replace((CharSequence)newTemplate, "instances diff in heap - " + title);
        string = "###H_AXIS_TITLE_INSTANCES_DIFF###";
        bl = false;
        newTemplate = new Regex(string).replace((CharSequence)newTemplate, "time");
        string = "###V_AXIS_TITLE_INSTANCES_DIFF###";
        bl = false;
        newTemplate = new Regex(string).replace((CharSequence)newTemplate, "instances diff");
        string = "###BASE_UNIT_FULL_INSTANCES_DIFF###";
        bl = false;
        newTemplate = new Regex(string).replace((CharSequence)newTemplate, "instances");
        string = "###BASE_UNIT_SHORT_INSTANCES_DIFF###";
        bl = false;
        newTemplate = new Regex(string).replace((CharSequence)newTemplate, "#");
        return newTemplate;
    }

    private HtmlGraphCreator() {
    }

    static {
        HtmlGraphCreator htmlGraphCreator;
        INSTANCE = htmlGraphCreator = new HtmlGraphCreator();
        arrowUp = (char)8593;
        arrowUpDown = (char)8597;
        arrowDown = (char)8595;
        arrowFlat = (char)8596;
        nonBreakSpace = (char)160;
    }
}

