/*
 * Decompiled with CFR 0.152.
 */
package nl.stokpop.memory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import nl.stokpop.memory.HistoAnalyser;
import nl.stokpop.memory.MemoryCheck;
import nl.stokpop.memory.domain.AnalysisResult;
import nl.stokpop.memory.domain.ClassGrowth;
import nl.stokpop.memory.domain.ClassGrowthTrend;
import nl.stokpop.memory.domain.ClassInfo;
import nl.stokpop.memory.domain.HeapHistogramDump;
import nl.stokpop.memory.domain.HeapHistogramDumpLine;
import nl.stokpop.memory.report.ReportConfig;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tJJ\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00062\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u00112\u0016\b\u0002\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0014J&\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u001a"}, d2={"Lnl/stokpop/memory/HistoAnalyser;", "", "()V", "analyse", "Lnl/stokpop/memory/domain/ClassGrowthTrend;", "dumps", "", "Lnl/stokpop/memory/domain/HeapHistogramDump;", "config", "Lnl/stokpop/memory/report/ReportConfig;", "analyseGrowth", "Lnl/stokpop/memory/domain/AnalysisResult;", "histoLines", "Lnl/stokpop/memory/domain/HeapHistogramDumpLine;", "isSafeToGrow", "", "maxGrowthPercentage", "", "minGrowthPointPercentage", "thingToCheck", "Lkotlin/Function1;", "", "processClassNameForHistoInfos", "Lnl/stokpop/memory/domain/ClassGrowth;", "name", "Lnl/stokpop/memory/domain/ClassInfo;", "memory-check"})
public final class HistoAnalyser {
    @NotNull
    public static final HistoAnalyser INSTANCE;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ClassGrowthTrend analyse(@NotNull List<HeapHistogramDump> dumps, @NotNull ReportConfig config) {
        void $this$sortedBy$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Long l;
        Collection collection;
        void $this$mapTo$iv$iv2;
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(dumps, (String)"dumps");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        if (dumps.isEmpty()) {
            return new ClassGrowthTrend(CollectionsKt.emptyList(), MapsKt.emptyMap());
        }
        Iterable $this$flatMap$iv = dumps;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            HeapHistogramDump it = (HeapHistogramDump)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.findAllClassNames();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Set classNames = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Iterable $this$map$iv2 = dumps;
        boolean $i$f$map22 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            HeapHistogramDump bl = (HeapHistogramDump)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            l = it.getTimestamp().atZone(MemoryCheck.Companion.useZoneOffset()).toInstant().toEpochMilli();
            collection.add(l);
        }
        List timestamps = CollectionsKt.toList((Iterable)((List)destination$iv$iv2));
        Iterable $i$f$map22 = classNames;
        boolean $i$f$map = false;
        destination$iv$iv2 = $this$map$iv;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void className;
            ClassInfo bl2 = (ClassInfo)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl = false;
            l = TuplesKt.to((Object)className, (Object)INSTANCE.processClassNameForHistoInfos((ClassInfo)className, dumps, config));
            collection.add(l);
        }
        $this$map$iv = CollectionsKt.toList((Iterable)((List)destination$iv$iv3));
        boolean $i$f$sortedBy = false;
        boolean bl = false;
        Map data = MapsKt.toMap((Iterable)CollectionsKt.reversed((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Pair $dstr$_u24__u24$value = (Pair)a;
                boolean bl2 = false;
                ClassGrowth value = (ClassGrowth)$dstr$_u24__u24$value.component2();
                $dstr$_u24__u24$value = (Pair)b;
                Comparable comparable = ((HeapHistogramDumpLine)CollectionsKt.last(value.getHistoLines())).getBytes();
                bl2 = false;
                value = (ClassGrowth)$dstr$_u24__u24$value.component2();
                Long l = ((HeapHistogramDumpLine)CollectionsKt.last(value.getHistoLines())).getBytes();
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)l);
            }
        })));
        return new ClassGrowthTrend(timestamps, data);
    }

    /*
     * WARNING - void declaration
     */
    private final ClassGrowth processClassNameForHistoInfos(ClassInfo name, List<HeapHistogramDump> dumps, ReportConfig config) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = dumps;
        boolean $i$f$map = false;
        void var7_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            HeapHistogramDumpLine heapHistogramDumpLine;
            Object v0;
            Collection collection;
            block3: {
                void dump;
                HeapHistogramDump heapHistogramDump = (HeapHistogramDump)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                Iterable $this$firstOrNull$iv = dump.getHistogram();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    HeapHistogramDumpLine it = (HeapHistogramDumpLine)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)name, (Object)it.getClassInfo())) continue;
                    v0 = element$iv;
                    break block3;
                }
                v0 = null;
            }
            if ((heapHistogramDumpLine = (HeapHistogramDumpLine)v0) == null) {
                heapHistogramDumpLine = HeapHistogramDumpLine.Companion.createGhostLine(name);
            }
            HeapHistogramDumpLine heapHistogramDumpLine2 = heapHistogramDumpLine;
            collection.add(heapHistogramDumpLine2);
        }
        List histosForClassName = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        AnalysisResult analyseGrowth2 = this.analyseGrowth(histosForClassName, name.isOnSafeList(), config.getReportLimits().getMaxGrowthPercentage(), config.getReportLimits().getMinGrowthPointsPercentage(), (Function1<? super HeapHistogramDumpLine, Long>)((Function1)processClassNameForHistoInfos.analyseGrowth.1.INSTANCE));
        return new ClassGrowth(name, histosForClassName, analyseGrowth2);
    }

    @NotNull
    public final AnalysisResult analyseGrowth(@NotNull List<HeapHistogramDumpLine> histoLines, boolean isSafeToGrow, double maxGrowthPercentage, double minGrowthPointPercentage, @NotNull Function1<? super HeapHistogramDumpLine, Long> thingToCheck) {
        boolean hasEnoughGrowthPoints;
        Intrinsics.checkNotNullParameter(histoLines, (String)"histoLines");
        Intrinsics.checkNotNullParameter(thingToCheck, (String)"thingToCheck");
        if (histoLines.isEmpty()) {
            return AnalysisResult.UNKNOWN;
        }
        int histoSize = histoLines.size();
        if (histoSize == 1) {
            return AnalysisResult.UNKNOWN;
        }
        int compareSize = histoSize - 1;
        int growthCriticalCount = 0;
        int growthMinorCount = 0;
        int shrinkCount = 0;
        int stableCount = 0;
        int ghostCount = 0;
        boolean lastIsGhost = false;
        long lastValue = -1L;
        for (HeapHistogramDumpLine line : histoLines) {
            lastIsGhost = false;
            if (line.isGhost()) {
                ++ghostCount;
                lastIsGhost = true;
                continue;
            }
            Object object = thingToCheck.invoke((Object)line);
            Intrinsics.checkNotNull((Object)object);
            long currentValue = ((Number)object).longValue();
            if (lastValue != -1L) {
                double percentageGrowth = (double)100 * ((double)(currentValue - lastValue) / (double)lastValue);
                if (lastValue < currentValue && percentageGrowth > maxGrowthPercentage) {
                    ++growthCriticalCount;
                } else if (lastValue < currentValue && percentageGrowth <= maxGrowthPercentage) {
                    ++growthMinorCount;
                } else if (lastValue > currentValue) {
                    ++shrinkCount;
                } else {
                    ++stableCount;
                }
            }
            lastValue = currentValue;
        }
        if (ghostCount == compareSize) {
            return AnalysisResult.UNKNOWN;
        }
        int totalGrowthCount = growthCriticalCount + growthMinorCount;
        double growthPointsPercentage = (double)totalGrowthCount / (double)compareSize * 100.0;
        boolean bl = hasEnoughGrowthPoints = growthPointsPercentage >= minGrowthPointPercentage;
        if (growthCriticalCount > 0 && totalGrowthCount + ghostCount + stableCount == compareSize && !lastIsGhost) {
            return hasEnoughGrowthPoints ? (isSafeToGrow ? AnalysisResult.GROW_SAFE : AnalysisResult.GROW_CRITICAL) : AnalysisResult.GROW_HICK_UPS;
        }
        if (growthMinorCount > 0 && growthMinorCount + ghostCount + stableCount == compareSize && !lastIsGhost) {
            return hasEnoughGrowthPoints ? (isSafeToGrow ? AnalysisResult.GROW_SAFE : AnalysisResult.GROW_MINOR) : AnalysisResult.GROW_HICK_UPS;
        }
        if (totalGrowthCount + ghostCount == compareSize && lastIsGhost) {
            return AnalysisResult.UNKNOWN;
        }
        if (shrinkCount > 0 && shrinkCount + ghostCount + stableCount == compareSize) {
            return AnalysisResult.SHRINK;
        }
        if (stableCount + ghostCount == compareSize) {
            return AnalysisResult.STABLE;
        }
        return AnalysisResult.SHRINK_AND_GROW;
    }

    public static /* synthetic */ AnalysisResult analyseGrowth$default(HistoAnalyser histoAnalyser, List list, boolean bl, double d, double d2, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            d = 10.0;
        }
        if ((n & 8) != 0) {
            d2 = 50.0;
        }
        if ((n & 0x10) != 0) {
            function1 = analyseGrowth.1.INSTANCE;
        }
        return histoAnalyser.analyseGrowth(list, bl, d, d2, (Function1<? super HeapHistogramDumpLine, Long>)function1);
    }

    private HistoAnalyser() {
    }

    static {
        HistoAnalyser histoAnalyser;
        INSTANCE = histoAnalyser = new HistoAnalyser();
    }
}

