/*
 * Decompiled with CFR 0.152.
 */
package nl.stokpop.memory;

import com.github.ajalt.clikt.core.CliktCommand;
import com.github.ajalt.clikt.core.ParameterHolder;
import com.github.ajalt.clikt.parameters.options.OptionWithValues;
import com.github.ajalt.clikt.parameters.options.OptionWithValuesKt;
import com.github.ajalt.clikt.parameters.types.DoubleKt;
import com.github.ajalt.clikt.parameters.types.FileKt;
import com.github.ajalt.clikt.parameters.types.IntKt;
import java.io.File;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import nl.stokpop.memory.MemoryCheck;
import nl.stokpop.memory.domain.AnalysisResult;
import nl.stokpop.memory.report.ReportConfig;
import nl.stokpop.memory.report.ReportLimits;
import nl.stokpop.memory.util.ConversionUtils;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u0006\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u00103\u001a\b\u0012\u0004\u0012\u00020\u0004042\b\u00105\u001a\u0004\u0018\u00010)H\u0002J\u0012\u00106\u001a\u0004\u0018\u0001072\u0006\u00108\u001a\u00020\u0004H\u0002J\b\u00109\u001a\u00020:H\u0016R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u001b\u0010\t\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\b\u001a\u0004\b\n\u0010\u0006R\u001b\u0010\f\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\b\u001a\u0004\b\u000e\u0010\u000fR\u001b\u0010\u0011\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\b\u001a\u0004\b\u0012\u0010\u0006R\u001b\u0010\u0014\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\b\u001a\u0004\b\u0015\u0010\u0006R\u001b\u0010\u0017\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\b\u001a\u0004\b\u0018\u0010\u0006R\u001b\u0010\u001a\u001a\u00020\u001b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\b\u001a\u0004\b\u001c\u0010\u001dR\u001b\u0010\u001f\u001a\u00020\u001b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\b\u001a\u0004\b \u0010\u001dR\u001b\u0010\"\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010\b\u001a\u0004\b#\u0010\u0006R\u001b\u0010%\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b'\u0010\b\u001a\u0004\b&\u0010\u0006R\u001d\u0010(\u001a\u0004\u0018\u00010)8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b,\u0010\b\u001a\u0004\b*\u0010+R\u001b\u0010-\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b/\u0010\b\u001a\u0004\b.\u0010\u0006R\u001d\u00100\u001a\u0004\u0018\u00010)8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b2\u0010\b\u001a\u0004\b1\u0010+\u00a8\u0006;"}, d2={"Lnl/stokpop/memory/MemoryCheckCli;", "Lcom/github/ajalt/clikt/core/CliktCommand;", "()V", "bytesLimit", "", "getBytesLimit", "()Ljava/lang/String;", "bytesLimit$delegate", "Lkotlin/properties/ReadOnlyProperty;", "categories", "getCategories", "categories$delegate", "classLimit", "", "getClassLimit", "()I", "classLimit$delegate", "directory", "getDirectory", "directory$delegate", "extension", "getExtension", "extension$delegate", "identifier", "getIdentifier", "identifier$delegate", "maxGrowthPercentage", "", "getMaxGrowthPercentage", "()D", "maxGrowthPercentage$delegate", "minGrowthPointsPercentage", "getMinGrowthPointsPercentage", "minGrowthPointsPercentage$delegate", "reportDirectory", "getReportDirectory", "reportDirectory$delegate", "safeList", "getSafeList", "safeList$delegate", "safeListFile", "Ljava/io/File;", "getSafeListFile", "()Ljava/io/File;", "safeListFile$delegate", "watchList", "getWatchList", "watchList$delegate", "watchListFile", "getWatchListFile", "watchListFile$delegate", "filterClassnamesFile", "", "classNamesFile", "parseAnalysisResult", "Lnl/stokpop/memory/domain/AnalysisResult;", "analysisResultAsString", "run", "", "memory-check"})
public final class MemoryCheckCli
extends CliktCommand {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final ReadOnlyProperty directory$delegate = OptionWithValuesKt.default$default((OptionWithValues)OptionWithValuesKt.option$default((ParameterHolder)this, (String[])new String[]{"-d", "--dir"}, (String)"Look in this directory for heap histogram dumps.", null, (boolean)false, null, null, null, null, (int)252, null), (Object)".", null, (int)2, null).provideDelegate((ParameterHolder)this, $$delegatedProperties[0]);
    private final ReadOnlyProperty extension$delegate = OptionWithValuesKt.default$default((OptionWithValues)OptionWithValuesKt.option$default((ParameterHolder)this, (String[])new String[]{"-e", "--ext"}, (String)"Only process files with this extension, example: 'histo'", null, (boolean)false, null, null, null, null, (int)252, null), (Object)"histo", null, (int)2, null).provideDelegate((ParameterHolder)this, $$delegatedProperties[1]);
    private final ReadOnlyProperty identifier$delegate = OptionWithValuesKt.default$default((OptionWithValues)OptionWithValuesKt.option$default((ParameterHolder)this, (String[])new String[]{"-i", "--id"}, (String)"Identifier for the report, example: 'test-run-1234'. Include #ts# for a timestamp.", null, (boolean)false, null, null, null, null, (int)252, null), (Object)"anonymous-#ts#", null, (int)2, null).provideDelegate((ParameterHolder)this, $$delegatedProperties[2]);
    private final ReadOnlyProperty reportDirectory$delegate = OptionWithValuesKt.default$default((OptionWithValues)OptionWithValuesKt.option$default((ParameterHolder)this, (String[])new String[]{"-r", "--report-dir"}, (String)"Full or relative path to directory for the reports, example: '.' for current directory", null, (boolean)false, null, null, null, null, (int)252, null), (Object)".", null, (int)2, null).provideDelegate((ParameterHolder)this, $$delegatedProperties[3]);
    private final ReadOnlyProperty classLimit$delegate = OptionWithValuesKt.default$default((OptionWithValues)IntKt.int((OptionWithValues)OptionWithValuesKt.option$default((ParameterHolder)this, (String[])new String[]{"-c", "--class-limit"}, (String)"Report only the top 'limit' classes, example: '128'.", null, (boolean)false, null, null, null, null, (int)252, null)), (Object)128, null, (int)2, null).provideDelegate((ParameterHolder)this, $$delegatedProperties[4]);
    private final ReadOnlyProperty bytesLimit$delegate = OptionWithValuesKt.default$default((OptionWithValues)OptionWithValuesKt.option$default((ParameterHolder)this, (String[])new String[]{"-b", "--bytes-limit"}, (String)"Report class only when last dump has at least x bytes, example: '2048' or '2KB'", null, (boolean)false, null, null, null, null, (int)252, null), (Object)"2048", null, (int)2, null).provideDelegate((ParameterHolder)this, $$delegatedProperties[5]);
    private final ReadOnlyProperty categories$delegate = OptionWithValuesKt.default$default((OptionWithValues)OptionWithValuesKt.option$default((ParameterHolder)this, (String[])new String[]{"-cat", "--categories"}, (String)"Comma separated file with categories to report: 'grow_critical, grow_minor, grow_safe, grow_hick_ups, shrink_and_grow, shrink, stable, unknown'. Or 'all'. Default: 'grow_critical,grow_minor'", null, (boolean)false, null, null, null, null, (int)252, null), (Object)"grow_critical,grow_minor", null, (int)2, null).provideDelegate((ParameterHolder)this, $$delegatedProperties[6]);
    private final ReadOnlyProperty maxGrowthPercentage$delegate = OptionWithValuesKt.default$default((OptionWithValues)DoubleKt.double((OptionWithValues)OptionWithValuesKt.option$default((ParameterHolder)this, (String[])new String[]{"-mgp", "--max-growth-percentage"}, (String)"Maximum allowed growth in percentage before reporting a critical growth. Default: 5.0", null, (boolean)false, null, null, null, null, (int)252, null)), (Object)5.0, null, (int)2, null).provideDelegate((ParameterHolder)this, $$delegatedProperties[7]);
    private final ReadOnlyProperty minGrowthPointsPercentage$delegate = OptionWithValuesKt.default$default((OptionWithValues)DoubleKt.double((OptionWithValues)OptionWithValuesKt.option$default((ParameterHolder)this, (String[])new String[]{"-mgpp", "--min-growth-points-percentage"}, (String)"Minimum percentage of growth points to be considered growth. Default: 50.0", null, (boolean)false, null, null, null, null, (int)252, null)), (Object)50.0, null, (int)2, null).provideDelegate((ParameterHolder)this, $$delegatedProperties[8]);
    private final ReadOnlyProperty safeList$delegate = OptionWithValuesKt.default$default((OptionWithValues)OptionWithValuesKt.option$default((ParameterHolder)this, (String[])new String[]{"-sl", "--safe-list"}, (String)"Comma separated list of fully qualified classnames that are 'safe to growth'. The asterisk (*) can be used as wildcard. Default: \"\"", null, (boolean)false, null, null, null, null, (int)252, null), (Object)"", null, (int)2, null).provideDelegate((ParameterHolder)this, $$delegatedProperties[9]);
    private final ReadOnlyProperty watchList$delegate = OptionWithValuesKt.default$default((OptionWithValues)OptionWithValuesKt.option$default((ParameterHolder)this, (String[])new String[]{"-wl", "--watch-list"}, (String)"Comma separated list of fully qualified classnames that are 'always watched' irrelevant of other settings. The asterisk (*) can be used as wildcard. Default: \"\"", null, (boolean)false, null, null, null, null, (int)252, null), (Object)"", null, (int)2, null).provideDelegate((ParameterHolder)this, $$delegatedProperties[10]);
    private final ReadOnlyProperty safeListFile$delegate = FileKt.file$default((OptionWithValues)OptionWithValuesKt.option$default((ParameterHolder)this, (String[])new String[]{"-slf", "--safe-list-file"}, (String)"The safe list file. Should contain one fully qualified classname per line.", null, (boolean)false, null, null, null, null, (int)252, null), (boolean)true, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (int)58, null).provideDelegate((ParameterHolder)this, $$delegatedProperties[11]);
    private final ReadOnlyProperty watchListFile$delegate = FileKt.file$default((OptionWithValues)OptionWithValuesKt.option$default((ParameterHolder)this, (String[])new String[]{"-wlf", "--watch-list-file"}, (String)"The safe list file. Should contain one fully qualified classname per line.", null, (boolean)false, null, null, null, null, (int)252, null), (boolean)true, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (int)58, null).provideDelegate((ParameterHolder)this, $$delegatedProperties[12]);

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl(MemoryCheckCli.class, "directory", "getDirectory()Ljava/lang/String;", 0)), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl(MemoryCheckCli.class, "extension", "getExtension()Ljava/lang/String;", 0)), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl(MemoryCheckCli.class, "identifier", "getIdentifier()Ljava/lang/String;", 0)), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl(MemoryCheckCli.class, "reportDirectory", "getReportDirectory()Ljava/lang/String;", 0)), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl(MemoryCheckCli.class, "classLimit", "getClassLimit()I", 0)), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl(MemoryCheckCli.class, "bytesLimit", "getBytesLimit()Ljava/lang/String;", 0)), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl(MemoryCheckCli.class, "categories", "getCategories()Ljava/lang/String;", 0)), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl(MemoryCheckCli.class, "maxGrowthPercentage", "getMaxGrowthPercentage()D", 0)), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl(MemoryCheckCli.class, "minGrowthPointsPercentage", "getMinGrowthPointsPercentage()D", 0)), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl(MemoryCheckCli.class, "safeList", "getSafeList()Ljava/lang/String;", 0)), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl(MemoryCheckCli.class, "watchList", "getWatchList()Ljava/lang/String;", 0)), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl(MemoryCheckCli.class, "safeListFile", "getSafeListFile()Ljava/io/File;", 0)), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl(MemoryCheckCli.class, "watchListFile", "getWatchListFile()Ljava/io/File;", 0))};
    }

    private final String getDirectory() {
        return (String)this.directory$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    private final String getExtension() {
        return (String)this.extension$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    private final String getIdentifier() {
        return (String)this.identifier$delegate.getValue((Object)this, $$delegatedProperties[2]);
    }

    private final String getReportDirectory() {
        return (String)this.reportDirectory$delegate.getValue((Object)this, $$delegatedProperties[3]);
    }

    private final int getClassLimit() {
        return ((Number)this.classLimit$delegate.getValue((Object)this, $$delegatedProperties[4])).intValue();
    }

    private final String getBytesLimit() {
        return (String)this.bytesLimit$delegate.getValue((Object)this, $$delegatedProperties[5]);
    }

    private final String getCategories() {
        return (String)this.categories$delegate.getValue((Object)this, $$delegatedProperties[6]);
    }

    private final double getMaxGrowthPercentage() {
        return ((Number)this.maxGrowthPercentage$delegate.getValue((Object)this, $$delegatedProperties[7])).doubleValue();
    }

    private final double getMinGrowthPointsPercentage() {
        return ((Number)this.minGrowthPointsPercentage$delegate.getValue((Object)this, $$delegatedProperties[8])).doubleValue();
    }

    private final String getSafeList() {
        return (String)this.safeList$delegate.getValue((Object)this, $$delegatedProperties[9]);
    }

    private final String getWatchList() {
        return (String)this.watchList$delegate.getValue((Object)this, $$delegatedProperties[10]);
    }

    private final File getSafeListFile() {
        return (File)this.safeListFile$delegate.getValue((Object)this, $$delegatedProperties[11]);
    }

    private final File getWatchListFile() {
        return (File)this.watchListFile$delegate.getValue((Object)this, $$delegatedProperties[12]);
    }

    /*
     * WARNING - void declaration
     */
    public void run() {
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        Iterable destination$iv$iv;
        Set set;
        String string;
        String reportDateTime = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm"));
        String string2 = "#ts#";
        boolean bl = false;
        Regex timestampRegex = new Regex(string2);
        if (timestampRegex.containsMatchIn((CharSequence)this.getIdentifier())) {
            CharSequence charSequence = this.getIdentifier();
            String string3 = reportDateTime;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"reportDateTime");
            string = timestampRegex.replace(charSequence, string3);
        } else {
            string = this.getIdentifier();
        }
        String processedId = string;
        Object object = this.getCategories();
        boolean bl2 = false;
        String string4 = object;
        if (string4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = string4.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).toLowerCase()");
        if (Intrinsics.areEqual((Object)string5, (Object)"all")) {
            set = ArraysKt.toSet((Object[])AnalysisResult.values());
        } else {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Iterator s;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            object = StringsKt.split$default((CharSequence)this.getCategories(), (char[])new char[]{','}, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$map = false;
            void var7_9 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string6;
                String string7 = (String)item$iv$iv;
                Iterable iterable = destination$iv$iv;
                boolean bl3 = false;
                void var14_31 = s;
                boolean bl4 = false;
                void v6 = var14_31;
                if (v6 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkNotNullExpressionValue((Object)v6.toUpperCase(), (String)"(this as java.lang.String).toUpperCase()");
                iterable.add(string6);
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$mapNotNull = false;
            $this$mapTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            s = $this$forEach$iv$iv$iv.iterator();
            while (s.hasNext()) {
                AnalysisResult analysisResult;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = s.next();
                boolean bl5 = false;
                String s2 = (String)element$iv$iv;
                boolean bl6 = false;
                if (this.parseAnalysisResult(s2) == null) continue;
                boolean bl7 = false;
                boolean bl8 = false;
                AnalysisResult it$iv$iv = analysisResult;
                boolean bl9 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            set = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        }
        Set reportSettings = set;
        Iterable $this$filter$iv = StringsKt.split$default((CharSequence)this.getSafeList(), (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Iterable destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            String it = (String)element$iv$iv;
            boolean bl10 = false;
            CharSequence bl5 = it;
            boolean bl11 = false;
            if (!(bl5.length() > 0)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        Set safeGrowSetOption = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        Iterable $this$filter$iv2 = StringsKt.split$default((CharSequence)this.getWatchList(), (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$filter2 = false;
        destination$iv$iv2 = $this$filter$iv2;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl12 = false;
            CharSequence charSequence = it;
            boolean bl13 = false;
            if (!(charSequence.length() > 0)) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        List list = (List)destination$iv$iv3;
        Collection collection = CollectionsKt.toSet((Iterable)list);
        HashSet watchSetOption = new HashSet(collection);
        Set<String> safeGrowSetFile = this.filterClassnamesFile(this.getSafeListFile());
        Set<String> watchSetFile = this.filterClassnamesFile(this.getWatchListFile());
        Set safeGrowSet = SetsKt.plus((Set)safeGrowSetOption, (Iterable)safeGrowSetFile);
        Set watchSet = SetsKt.plus((Set)watchSetOption, (Iterable)watchSetFile);
        ReportLimits reportLimits = new ReportLimits(this.getClassLimit(), ConversionUtils.INSTANCE.convertHumanReadableToBytes(this.getBytesLimit()), this.getMaxGrowthPercentage(), this.getMinGrowthPointsPercentage(), safeGrowSet, watchSet, reportSettings.contains((Object)AnalysisResult.GROW_CRITICAL), reportSettings.contains((Object)AnalysisResult.GROW_MINOR), reportSettings.contains((Object)AnalysisResult.GROW_SAFE), reportSettings.contains((Object)AnalysisResult.GROW_HICK_UPS), reportSettings.contains((Object)AnalysisResult.SHRINK_AND_GROW), reportSettings.contains((Object)AnalysisResult.SHRINK), reportSettings.contains((Object)AnalysisResult.STABLE));
        String string8 = this.getDirectory();
        String string9 = this.getReportDirectory();
        String string10 = this.getExtension();
        String string11 = reportDateTime;
        Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"reportDateTime");
        ReportConfig reportConfig = new ReportConfig(reportSettings, string8, string9, string10, processedId, string11, reportLimits);
        try {
            new MemoryCheck().processHistos(reportConfig);
        }
        catch (Exception e) {
            String string12 = "Error: " + e.getMessage();
            boolean bl14 = false;
            System.out.println((Object)string12);
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final Set<String> filterClassnamesFile(File classNamesFile) {
        Set set;
        Object object = classNamesFile;
        if (object != null && (object = FilesKt.readLines$default((File)object, null, (int)1, null)) != null) {
            Iterable $this$filterTo$iv$iv;
            boolean bl;
            CharSequence charSequence;
            String it;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)object;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                charSequence = it;
                bl = false;
                void v1 = charSequence;
                if (v1 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                String string2 = ((Object)StringsKt.trim((CharSequence)((CharSequence)v1))).toString();
                collection.add(string2);
            }
            Iterable $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (String)element$iv$iv;
                boolean bl3 = false;
                charSequence = it;
                bl = false;
                if (!(charSequence.length() > 0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (String)element$iv$iv;
                boolean bl4 = false;
                if (!(!StringsKt.startsWith$default((String)it, (String)"#", (boolean)false, (int)2, null))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            object = CollectionsKt.toHashSet((Iterable)((List)destination$iv$iv));
            if (object != null) {
                set = (Set)object;
                return set;
            }
        }
        set = SetsKt.emptySet();
        return set;
    }

    private final AnalysisResult parseAnalysisResult(String analysisResultAsString) {
        AnalysisResult analysisResult;
        try {
            analysisResult = AnalysisResult.valueOf(analysisResultAsString);
        }
        catch (IllegalArgumentException e) {
            System.err.println("Unknown analysis result in settings: " + analysisResultAsString);
            return null;
        }
        return analysisResult;
    }

    public MemoryCheckCli() {
        super(null, null, null, false, false, null, null, false, false, 511, null);
    }
}

