/*
 * Decompiled with CFR 0.152.
 */
package nl.stokpop.memory.report;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import nl.stokpop.memory.domain.AnalysisResult;
import nl.stokpop.memory.domain.ClassGrowth;
import nl.stokpop.memory.domain.ClassGrowthTrend;
import nl.stokpop.memory.domain.ClassInfo;
import nl.stokpop.memory.domain.HeapHistogramDumpLine;
import nl.stokpop.memory.domain.json.ClassHistogramDetails;
import nl.stokpop.memory.domain.json.HeapHistogramDumpDetails;
import nl.stokpop.memory.domain.json.HeapHistogramDumpReport;
import nl.stokpop.memory.domain.json.HeapHistogramDumpSummary;
import nl.stokpop.memory.report.ReportAnalyser;
import nl.stokpop.memory.report.ReportLimits;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004H\u0002J\u001e\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004H\u0002J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u001e\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004H\u0002J\u001e\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004H\u0002J'\u0010\u0011\u001a\u0004\u0018\u00010\u00052\u0016\u0010\u0012\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0013H\u0002\u00a2\u0006\u0002\u0010\u0014J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0005H\u0002\u00a8\u0006\u0019"}, d2={"Lnl/stokpop/memory/report/ReportAnalyser;", "", "()V", "createBytesDiffList", "", "", "histoLines", "Lnl/stokpop/memory/domain/HeapHistogramDumpLine;", "createBytesList", "createHeapHistogramDumpReport", "Lnl/stokpop/memory/domain/json/HeapHistogramDumpReport;", "classGrowthTrend", "Lnl/stokpop/memory/domain/ClassGrowthTrend;", "reportLimits", "Lnl/stokpop/memory/report/ReportLimits;", "createInstancesDiffList", "createInstancesList", "diffOrNull", "it", "Lkotlin/Pair;", "(Lkotlin/Pair;)Ljava/lang/Long;", "isLargerThanBytesInLastHisto", "", "Lnl/stokpop/memory/domain/ClassGrowth;", "minSizeInBytes", "memory-check"})
public final class ReportAnalyser {
    @NotNull
    public static final ReportAnalyser INSTANCE;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final HeapHistogramDumpReport createHeapHistogramDumpReport(@NotNull ClassGrowthTrend classGrowthTrend, @NotNull ReportLimits reportLimits) {
        void $this$groupByTo$iv$iv;
        AnalysisResult analysisResult;
        Intrinsics.checkNotNullParameter((Object)classGrowthTrend, (String)"classGrowthTrend");
        Intrinsics.checkNotNullParameter((Object)reportLimits, (String)"reportLimits");
        Map analysisResultToCount2 = MapsKt.toMap((Sequence)SequencesKt.map((Sequence)ArraysKt.asSequence((Object[])AnalysisResult.values()), (Function1)((Function1)new Function1<AnalysisResult, Pair<? extends AnalysisResult, ? extends Integer>>(classGrowthTrend, reportLimits){
            final /* synthetic */ ClassGrowthTrend $classGrowthTrend;
            final /* synthetic */ ReportLimits $reportLimits;

            @NotNull
            public final Pair<AnalysisResult, Integer> invoke(@NotNull AnalysisResult it) {
                Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                return TuplesKt.to((Object)((Object)it), (Object)this.$classGrowthTrend.statusCount(it, this.$reportLimits.getByteLimit()));
            }
            {
                this.$classGrowthTrend = classGrowthTrend;
                this.$reportLimits = reportLimits;
                super(1);
            }
        })));
        HeapHistogramDumpSummary heapHistogramDumpSummary = new HeapHistogramDumpSummary(analysisResultToCount2);
        Integer n = heapHistogramDumpSummary.getData().get((Object)AnalysisResult.GROW_CRITICAL);
        if ((n != null ? n : 0) > 0) {
            analysisResult = AnalysisResult.GROW_CRITICAL;
        } else {
            Integer n2 = heapHistogramDumpSummary.getData().get((Object)AnalysisResult.GROW_MINOR);
            if ((n2 != null ? n2 : 0) > 0) {
                analysisResult = AnalysisResult.GROW_MINOR;
            } else {
                Integer n3 = heapHistogramDumpSummary.getData().get((Object)AnalysisResult.GROW_SAFE);
                if ((n3 != null ? n3 : 0) > 0) {
                    analysisResult = AnalysisResult.GROW_SAFE;
                } else {
                    Integer n4 = heapHistogramDumpSummary.getData().get((Object)AnalysisResult.GROW_HICK_UPS);
                    if ((n4 != null ? n4 : 0) > 0) {
                        analysisResult = AnalysisResult.GROW_HICK_UPS;
                    } else {
                        Integer n5 = heapHistogramDumpSummary.getData().get((Object)AnalysisResult.SHRINK_AND_GROW);
                        if ((n5 != null ? n5 : 0) > 0) {
                            analysisResult = AnalysisResult.SHRINK_AND_GROW;
                        } else {
                            Integer n6 = heapHistogramDumpSummary.getData().get((Object)AnalysisResult.SHRINK);
                            if ((n6 != null ? n6 : 0) > 0) {
                                analysisResult = AnalysisResult.SHRINK;
                            } else {
                                Integer n7 = heapHistogramDumpSummary.getData().get((Object)AnalysisResult.STABLE);
                                analysisResult = (n7 != null ? n7 : 0) > 0 ? AnalysisResult.STABLE : AnalysisResult.UNKNOWN;
                            }
                        }
                    }
                }
            }
        }
        AnalysisResult leakResult = analysisResult;
        Function1 analysisFilter2 = (Function1)new Function1<Map.Entry<? extends ClassInfo, ? extends ClassGrowth>, Boolean>(reportLimits){
            final /* synthetic */ ReportLimits $reportLimits;

            public final boolean invoke(@NotNull Map.Entry<ClassInfo, ClassGrowth> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return this.$reportLimits.getDoReportGrowCritical() && it.getValue().getAnalysisResult() == AnalysisResult.GROW_CRITICAL || this.$reportLimits.getDoReportGrowMinor() && it.getValue().getAnalysisResult() == AnalysisResult.GROW_MINOR || this.$reportLimits.getDoReportGrowSafe() && it.getValue().getAnalysisResult() == AnalysisResult.GROW_SAFE || this.$reportLimits.getDoReportGrowHickUps() && it.getValue().getAnalysisResult() == AnalysisResult.GROW_HICK_UPS || this.$reportLimits.getDoReportShrinkAndGrow() && it.getValue().getAnalysisResult() == AnalysisResult.SHRINK_AND_GROW || this.$reportLimits.getDoReportShrinks() && it.getValue().getAnalysisResult() == AnalysisResult.SHRINK || this.$reportLimits.getDoReportStable() && it.getValue().getAnalysisResult() == AnalysisResult.STABLE || this.$reportLimits.getDoReportShrinkAndGrow() && it.getValue().getAnalysisResult() == AnalysisResult.SHRINK_AND_GROW;
            }
            {
                this.$reportLimits = reportLimits;
                super(1);
            }
        };
        Iterable $this$groupBy$iv = classGrowthTrend.getData().entrySet();
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            Map.Entry it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            Boolean key$iv$iv = ((ClassInfo)it.getKey()).isOnWatchList();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map classHistogramDetailsByWatchList = destination$iv$iv;
        List detailsNonWatchList = classHistogramDetailsByWatchList.getOrDefault(false, CollectionsKt.emptyList());
        List detailsWatchList = classHistogramDetailsByWatchList.getOrDefault(true, CollectionsKt.emptyList());
        List classHistogramDumpDetailsNonWatchList2 = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.take((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)detailsNonWatchList), (Function1)analysisFilter2), (Function1)((Function1)new Function1<Map.Entry<? extends ClassInfo, ? extends ClassGrowth>, Boolean>(reportLimits){
            final /* synthetic */ ReportLimits $reportLimits;

            public final boolean invoke(@NotNull Map.Entry<ClassInfo, ClassGrowth> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return ReportAnalyser.access$isLargerThanBytesInLastHisto(ReportAnalyser.INSTANCE, it.getValue(), this.$reportLimits.getByteLimit());
            }
            {
                this.$reportLimits = reportLimits;
                super(1);
            }
        })), (int)reportLimits.getClassLimit()), (Function1)createHeapHistogramDumpReport.classHistogramDumpDetailsNonWatchList.2.INSTANCE));
        List classHistogramDumpDetailsWatchList2 = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)detailsWatchList), (Function1)analysisFilter2), (Function1)createHeapHistogramDumpReport.classHistogramDumpDetailsWatchList.1.INSTANCE));
        Iterable $this$sortedByDescending$iv = CollectionsKt.plus((Collection)classHistogramDumpDetailsNonWatchList2, (Iterable)classHistogramDumpDetailsWatchList2);
        boolean $i$f$sortedByDescending = false;
        boolean bl = false;
        List totalDetailsToReport = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                ClassHistogramDetails it = (ClassHistogramDetails)b;
                boolean bl2 = false;
                Comparable comparable = (Long)CollectionsKt.last(it.getBytes());
                it = (ClassHistogramDetails)a;
                Comparable comparable2 = comparable;
                bl2 = false;
                Long l = (Long)CollectionsKt.last(it.getBytes());
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)l);
            }
        });
        HeapHistogramDumpDetails heapHistogramDumpDetails = new HeapHistogramDumpDetails(totalDetailsToReport, classGrowthTrend.getTimestamps());
        return new HeapHistogramDumpReport(reportLimits, leakResult, heapHistogramDumpSummary, heapHistogramDumpDetails);
    }

    private final boolean isLargerThanBytesInLastHisto(ClassGrowth it, long minSizeInBytes) {
        Long bytes = ((HeapHistogramDumpLine)CollectionsKt.last(it.getHistoLines())).getBytes();
        return bytes != null && bytes > minSizeInBytes;
    }

    private final List<Long> createInstancesList(List<HeapHistogramDumpLine> histoLines) {
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)histoLines), (Function1)createInstancesList.1.INSTANCE));
    }

    private final List<Long> createInstancesDiffList(List<HeapHistogramDumpLine> histoLines) {
        return CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)0L), (Iterable)SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.zipWithNext((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)histoLines), (Function1)createInstancesDiffList.1.INSTANCE)), (Function1)createInstancesDiffList.2.INSTANCE)));
    }

    private final List<Long> createBytesDiffList(List<HeapHistogramDumpLine> histoLines) {
        return CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)0L), (Iterable)SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.zipWithNext((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)histoLines), (Function1)createBytesDiffList.1.INSTANCE)), (Function1)createBytesDiffList.2.INSTANCE)));
    }

    private final List<Long> createBytesList(List<HeapHistogramDumpLine> histoLines) {
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)histoLines), (Function1)createBytesList.1.INSTANCE));
    }

    private final Long diffOrNull(Pair<Long, Long> it) {
        Long l;
        if (it.getFirst() == null || it.getSecond() == null) {
            l = null;
        } else {
            Object object = it.getSecond();
            Intrinsics.checkNotNull((Object)object);
            long l2 = ((Number)object).longValue();
            Object object2 = it.getFirst();
            Intrinsics.checkNotNull((Object)object2);
            l = l2 - ((Number)object2).longValue();
        }
        return l;
    }

    private ReportAnalyser() {
    }

    static {
        ReportAnalyser reportAnalyser;
        INSTANCE = reportAnalyser = new ReportAnalyser();
    }

    public static final /* synthetic */ boolean access$isLargerThanBytesInLastHisto(ReportAnalyser $this, ClassGrowth it, long minSizeInBytes) {
        return $this.isLargerThanBytesInLastHisto(it, minSizeInBytes);
    }

    public static final /* synthetic */ List access$createBytesList(ReportAnalyser $this, List histoLines) {
        return $this.createBytesList(histoLines);
    }

    public static final /* synthetic */ List access$createBytesDiffList(ReportAnalyser $this, List histoLines) {
        return $this.createBytesDiffList(histoLines);
    }

    public static final /* synthetic */ List access$createInstancesList(ReportAnalyser $this, List histoLines) {
        return $this.createInstancesList(histoLines);
    }

    public static final /* synthetic */ List access$createInstancesDiffList(ReportAnalyser $this, List histoLines) {
        return $this.createInstancesDiffList(histoLines);
    }

    public static final /* synthetic */ Long access$diffOrNull(ReportAnalyser $this, Pair it) {
        return $this.diffOrNull((Pair<Long, Long>)it);
    }
}

