/*
 * Decompiled with CFR 0.152.
 */
package nl.stokpop.memory.report;

import java.time.format.DateTimeFormatter;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import nl.stokpop.memory.domain.AnalysisResult;
import nl.stokpop.memory.domain.ClassInfo;
import nl.stokpop.memory.domain.HeapHistogramDump;
import nl.stokpop.memory.domain.json.ClassHistogramDetails;
import nl.stokpop.memory.domain.json.HeapHistogramDumpReport;
import nl.stokpop.memory.report.ReportConfig;
import nl.stokpop.memory.report.TextReport;
import nl.stokpop.memory.util.ConversionUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lnl/stokpop/memory/report/TextReport;", "", "()V", "report", "", "histos", "", "Lnl/stokpop/memory/domain/HeapHistogramDump;", "data", "Lnl/stokpop/memory/domain/json/HeapHistogramDumpReport;", "reportConfig", "Lnl/stokpop/memory/report/ReportConfig;", "reportLine", "details", "Lnl/stokpop/memory/domain/json/ClassHistogramDetails;", "memory-check"})
public final class TextReport {
    @NotNull
    public static final TextReport INSTANCE;

    /*
     * WARNING - void declaration
     */
    public final void report(@NotNull List<HeapHistogramDump> histos, @NotNull HeapHistogramDumpReport data, @NotNull ReportConfig reportConfig) {
        Iterator iterator;
        Object element$iv3;
        Intrinsics.checkNotNullParameter(histos, (String)"histos");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)reportConfig, (String)"reportConfig");
        long minSizeInBytes = data.getReportLimits().getByteLimit();
        String header = "Histogram report - " + reportConfig.getReportDateTime();
        String dashes2 = SequencesKt.joinToString$default((Sequence)SequencesKt.take((Sequence)SequencesKt.generateSequence((Function0)report.dashes.1.INSTANCE), (int)header.length()), (CharSequence)"", null, null, (int)0, null, (Function1)report.dashes.2.INSTANCE, (int)30, null);
        boolean bl = false;
        System.out.println((Object)dashes2);
        bl = false;
        System.out.println((Object)header);
        bl = false;
        System.out.println((Object)dashes2);
        bl = false;
        System.out.println();
        Object $this$forEach$iv = histos;
        boolean $i$f$forEach2 = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv2 = iterator2.next();
            HeapHistogramDump it = (HeapHistogramDump)element$iv2;
            boolean bl2 = false;
            String string = "File: '" + it.getHistoFile().getName() + "' with date " + it.getTimestamp().format(DateTimeFormatter.ISO_DATE_TIME);
            boolean bl3 = false;
            System.out.println((Object)string);
        }
        $this$forEach$iv = "\nBelow only results are printed that have remaining size of at least " + ConversionUtils.INSTANCE.humanReadableMemorySize(minSizeInBytes) + " in last histogram\n" + "or are on the watch list.";
        $i$f$forEach2 = false;
        System.out.println($this$forEach$iv);
        $this$forEach$iv = "\nNumber of GROW_CRITICAL " + data.getHeapHistogramDumpSummary().getData().get((Object)AnalysisResult.GROW_CRITICAL);
        $i$f$forEach2 = false;
        System.out.println($this$forEach$iv);
        $this$forEach$iv = "Number of GROW_MINOR " + data.getHeapHistogramDumpSummary().getData().get((Object)AnalysisResult.GROW_MINOR);
        $i$f$forEach2 = false;
        System.out.println($this$forEach$iv);
        $this$forEach$iv = "Number of GROW_SAFE " + data.getHeapHistogramDumpSummary().getData().get((Object)AnalysisResult.GROW_SAFE);
        $i$f$forEach2 = false;
        System.out.println($this$forEach$iv);
        $this$forEach$iv = "Number of GROW_HICK_UPS " + data.getHeapHistogramDumpSummary().getData().get((Object)AnalysisResult.GROW_HICK_UPS);
        $i$f$forEach2 = false;
        System.out.println($this$forEach$iv);
        $this$forEach$iv = "Number of SHRINK_AND_GROW " + data.getHeapHistogramDumpSummary().getData().get((Object)AnalysisResult.SHRINK_AND_GROW);
        $i$f$forEach2 = false;
        System.out.println($this$forEach$iv);
        $this$forEach$iv = "Number of STABLE " + data.getHeapHistogramDumpSummary().getData().get((Object)AnalysisResult.STABLE);
        $i$f$forEach2 = false;
        System.out.println($this$forEach$iv);
        $this$forEach$iv = "Number of SHRINK " + data.getHeapHistogramDumpSummary().getData().get((Object)AnalysisResult.SHRINK);
        $i$f$forEach2 = false;
        System.out.println($this$forEach$iv);
        Sequence details = CollectionsKt.asSequence((Iterable)data.getHeapHistogramDumpDetails().getClassHistogramDetails());
        if (data.getReportLimits().getDoReportGrowCritical()) {
            void $this$forEach$iv2;
            String $i$f$forEach2 = "\n\nFound critical memory leaks:";
            boolean bl4 = false;
            System.out.println((Object)$i$f$forEach2);
            $i$f$forEach2 = SequencesKt.filter((Sequence)details, (Function1)report.2.INSTANCE);
            boolean $i$f$forEach3 = false;
            for (Object element$iv3 : $this$forEach$iv2) {
                ClassHistogramDetails it = (ClassHistogramDetails)element$iv3;
                boolean bl5 = false;
                INSTANCE.reportLine(it);
            }
        }
        if (data.getReportLimits().getDoReportGrowMinor()) {
            String $this$forEach$iv2 = "\n\nFound minor memory leaks:";
            boolean $i$f$forEach3 = false;
            System.out.println((Object)$this$forEach$iv2);
            $this$forEach$iv2 = SequencesKt.filter((Sequence)details, (Function1)report.4.INSTANCE);
            $i$f$forEach3 = false;
            iterator = $this$forEach$iv2.iterator();
            while (iterator.hasNext()) {
                element$iv3 = iterator.next();
                ClassHistogramDetails it = (ClassHistogramDetails)element$iv3;
                boolean bl6 = false;
                INSTANCE.reportLine(it);
            }
        }
        if (data.getReportLimits().getDoReportGrowSafe()) {
            String $this$forEach$iv3 = "\n\nFound 'safe' memory leaks:";
            boolean $i$f$forEach4 = false;
            System.out.println((Object)$this$forEach$iv3);
            $this$forEach$iv3 = SequencesKt.filter((Sequence)details, (Function1)report.6.INSTANCE);
            $i$f$forEach4 = false;
            iterator = $this$forEach$iv3.iterator();
            while (iterator.hasNext()) {
                element$iv3 = iterator.next();
                ClassHistogramDetails it = (ClassHistogramDetails)element$iv3;
                boolean bl7 = false;
                INSTANCE.reportLine(it);
            }
        }
        if (data.getReportLimits().getDoReportGrowHickUps()) {
            String $this$forEach$iv4 = "\n\nFound grow hick ups:";
            boolean $i$f$forEach5 = false;
            System.out.println((Object)$this$forEach$iv4);
            $this$forEach$iv4 = SequencesKt.filter((Sequence)details, (Function1)report.8.INSTANCE);
            $i$f$forEach5 = false;
            iterator = $this$forEach$iv4.iterator();
            while (iterator.hasNext()) {
                element$iv3 = iterator.next();
                ClassHistogramDetails it = (ClassHistogramDetails)element$iv3;
                boolean bl8 = false;
                INSTANCE.reportLine(it);
            }
        }
        if (data.getReportLimits().getDoReportShrinkAndGrow()) {
            String $this$forEach$iv5 = "\n\nFound shrink and grow:";
            boolean $i$f$forEach6 = false;
            System.out.println((Object)$this$forEach$iv5);
            $this$forEach$iv5 = SequencesKt.filter((Sequence)details, (Function1)report.10.INSTANCE);
            $i$f$forEach6 = false;
            iterator = $this$forEach$iv5.iterator();
            while (iterator.hasNext()) {
                element$iv3 = iterator.next();
                ClassHistogramDetails it = (ClassHistogramDetails)element$iv3;
                boolean bl9 = false;
                INSTANCE.reportLine(it);
            }
        }
        if (data.getReportLimits().getDoReportShrinks()) {
            String $this$forEach$iv6 = "\n\nFound shrink:";
            boolean $i$f$forEach7 = false;
            System.out.println((Object)$this$forEach$iv6);
            $this$forEach$iv6 = SequencesKt.filter((Sequence)details, (Function1)report.12.INSTANCE);
            $i$f$forEach7 = false;
            iterator = $this$forEach$iv6.iterator();
            while (iterator.hasNext()) {
                element$iv3 = iterator.next();
                ClassHistogramDetails it = (ClassHistogramDetails)element$iv3;
                boolean bl10 = false;
                INSTANCE.reportLine(it);
            }
        }
        if (data.getReportLimits().getDoReportStable()) {
            String $this$forEach$iv7 = "\n\nFound stable:";
            boolean $i$f$forEach8 = false;
            System.out.println((Object)$this$forEach$iv7);
            $this$forEach$iv7 = SequencesKt.filter((Sequence)details, (Function1)report.14.INSTANCE);
            $i$f$forEach8 = false;
            iterator = $this$forEach$iv7.iterator();
            while (iterator.hasNext()) {
                element$iv3 = iterator.next();
                ClassHistogramDetails it = (ClassHistogramDetails)element$iv3;
                boolean bl11 = false;
                INSTANCE.reportLine(it);
            }
        }
        String string = "\n";
        boolean bl12 = false;
        System.out.println((Object)string);
    }

    private final void reportLine(ClassHistogramDetails details) {
        ClassInfo classInfo = details.getClassInfo();
        String string = ClassInfo.Companion.prefixWatchListAndSafeList(classInfo) + classInfo.getName() + ' ';
        boolean bl = false;
        System.out.print((Object)string);
    }

    private TextReport() {
    }

    static {
        TextReport textReport;
        INSTANCE = textReport = new TextReport();
    }
}

