/*
 * Decompiled with CFR 0.152.
 */
package nl.stokpop.memory;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import nl.stokpop.memory.HistoReader;
import nl.stokpop.memory.InvalidHistoLineException;
import nl.stokpop.memory.MemoryCheck;
import nl.stokpop.memory.domain.ClassInfo;
import nl.stokpop.memory.domain.HeapHistogramDump;
import nl.stokpop.memory.domain.HeapHistogramDumpLine;
import nl.stokpop.memory.domain.SafeList;
import nl.stokpop.memory.domain.WatchList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0014\u001a\u00020\tJ&\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u00162\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J*\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00162\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00110\u00162\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u001b\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\tH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lnl/stokpop/memory/HistoReader;", "", "()V", "isoDateRegex", "Lkotlin/text/Regex;", "spacesRegex", "createHistoLine", "Lnl/stokpop/memory/domain/HeapHistogramDumpLine;", "line", "", "safeList", "Lnl/stokpop/memory/domain/SafeList;", "watchList", "Lnl/stokpop/memory/domain/WatchList;", "dateForHistoFile", "Ljava/time/LocalDateTime;", "file", "Ljava/io/File;", "dateForHistoFileFromAttrinutes", "extractDate", "s", "readHisto", "", "readHistos", "Lnl/stokpop/memory/domain/HeapHistogramDump;", "histoFiles", "safeGrowList", "skipLastCharacter", "memory-check"})
public final class HistoReader {
    private static final Regex isoDateRegex;
    private static final Regex spacesRegex;
    @NotNull
    public static final HistoReader INSTANCE;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<HeapHistogramDump> readHistos(@NotNull List<? extends File> histoFiles, @NotNull SafeList safeGrowList, @NotNull WatchList watchList) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(histoFiles, (String)"histoFiles");
        Intrinsics.checkNotNullParameter((Object)safeGrowList, (String)"safeGrowList");
        Intrinsics.checkNotNullParameter((Object)watchList, (String)"watchList");
        Iterable iterable = histoFiles;
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File file = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            LocalDateTime dumpDate = INSTANCE.dateForHistoFile((File)it);
            HeapHistogramDump heapHistogramDump = new HeapHistogramDump((File)it, dumpDate, INSTANCE.readHisto((File)it, safeGrowList, watchList));
            collection.add(heapHistogramDump);
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    private final LocalDateTime dateForHistoFile(File file) {
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
        LocalDateTime localDateTime = this.extractDate(string);
        if (localDateTime == null) {
            localDateTime = this.dateForHistoFileFromAttrinutes(file);
        }
        return localDateTime;
    }

    private final LocalDateTime dateForHistoFileFromAttrinutes(File file) {
        Object object = "Unable to parse date time from filename: " + file.getName() + ", will now use file creation date.";
        boolean bl = false;
        System.out.println(object);
        try {
            BasicFileAttributes attr = Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
            FileTime fileTime = attr.creationTime();
            LocalDateTime localDateTime = LocalDateTime.ofInstant(fileTime.toInstant(), MemoryCheck.Companion.useZoneOffset());
            Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"LocalDateTime.ofInstant(\u2026oryCheck.useZoneOffset())");
            object = localDateTime;
        }
        catch (IOException ex) {
            System.err.println("Unable to get creation date for " + file + ", using last modified as work around.");
            LocalDateTime localDateTime = LocalDateTime.from(Instant.ofEpochMilli(file.lastModified()));
            Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"LocalDateTime.from(Insta\u2026lli(file.lastModified()))");
            object = localDateTime;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<HeapHistogramDumpLine> readHisto(File file, SafeList safeList, WatchList watchList) {
        File $this$useLines$iv = file;
        Charset charset$iv = Charsets.UTF_8;
        boolean $i$f$useLines = false;
        Object object = $this$useLines$iv;
        int n = 8192;
        boolean bl = false;
        Object object2 = object;
        boolean bl2 = false;
        Object object3 = object2;
        boolean bl3 = false;
        object3 = new FileInputStream((File)object3);
        bl3 = false;
        object2 = new InputStreamReader((InputStream)object3, charset$iv);
        bl2 = false;
        object = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
        n = 0;
        bl = false;
        Throwable throwable = null;
        try {
            BufferedReader it$iv = (BufferedReader)object;
            boolean bl4 = false;
            Sequence line = TextStreamsKt.lineSequence((BufferedReader)it$iv);
            boolean bl5 = false;
            object2 = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)line, (Function1)readHisto.1.1.INSTANCE), (Function1)readHisto.1.2.INSTANCE), (Function1)((Function1)new Function1<String, HeapHistogramDumpLine>(safeList, watchList){
                final /* synthetic */ SafeList $safeList$inlined;
                final /* synthetic */ WatchList $watchList$inlined;
                {
                    this.$safeList$inlined = safeList;
                    this.$watchList$inlined = watchList;
                    super(1);
                }

                @NotNull
                public final HeapHistogramDumpLine invoke(@NotNull String it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return HistoReader.access$createHistoLine(HistoReader.INSTANCE, it, this.$safeList$inlined, this.$watchList$inlined);
                }
            })));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        return object2;
    }

    private final HeapHistogramDumpLine createHistoLine(String line, SafeList safeList, WatchList watchList) {
        CharSequence charSequence = line;
        Regex regex = spacesRegex;
        int n = 0;
        boolean bl = false;
        List split = regex.split(charSequence, n);
        if (split.size() != 4 && split.size() != 5) {
            throw (Throwable)new InvalidHistoLineException("Cannot read histo line (" + split.size() + " elements, 4 or 5 expected): '" + line + "' and '" + split + '\'');
        }
        String lineNumber = this.skipLastCharacter((String)split.get(0));
        String instances = (String)split.get(1);
        String bytes = (String)split.get(2);
        String name = (String)split.get(3);
        String string = lineNumber;
        boolean bl2 = false;
        Long l = Long.parseLong(string);
        string = instances;
        bl2 = false;
        Long l2 = Long.parseLong(string);
        string = bytes;
        bl2 = false;
        return new HeapHistogramDumpLine(new ClassInfo(name, safeList.matches(name), watchList.matches(name)), l, l2, Long.parseLong(string));
    }

    private final String skipLastCharacter(String s) {
        String string = s;
        int n = 0;
        int n2 = s.length() - 1;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        return string3;
    }

    @Nullable
    public final LocalDateTime extractDate(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        if (isoDateRegex.containsMatchIn((CharSequence)s)) {
            MatchResult matchResult = Regex.find$default((Regex)isoDateRegex, (CharSequence)s, (int)0, (int)2, null);
            String dateString = matchResult != null ? matchResult.getValue() : null;
            return LocalDateTime.parse(dateString);
        }
        return null;
    }

    private HistoReader() {
    }

    static {
        HistoReader histoReader;
        INSTANCE = histoReader = new HistoReader();
        String string = "\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}(\\.\\d+)?";
        boolean bl = false;
        isoDateRegex = new Regex(string);
        string = "\\s+";
        bl = false;
        spacesRegex = new Regex(string);
    }

    public static final /* synthetic */ HeapHistogramDumpLine access$createHistoLine(HistoReader $this, String line, SafeList safeList, WatchList watchList) {
        return $this.createHistoLine(line, safeList, watchList);
    }
}

