/*
 * Decompiled with CFR 0.152.
 */
package nl.stokpop.memory;

import java.io.File;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import nl.stokpop.memory.HistoAnalyser;
import nl.stokpop.memory.HistoReader;
import nl.stokpop.memory.MemoryCheckException;
import nl.stokpop.memory.domain.ClassGrowthTrend;
import nl.stokpop.memory.domain.HeapHistogramDump;
import nl.stokpop.memory.domain.SafeList;
import nl.stokpop.memory.domain.WatchList;
import nl.stokpop.memory.domain.json.HeapHistogramDumpReport;
import nl.stokpop.memory.report.HtmlGraphCreator;
import nl.stokpop.memory.report.JsonReport;
import nl.stokpop.memory.report.ReportAnalyser;
import nl.stokpop.memory.report.ReportConfig;
import nl.stokpop.memory.report.ReportLimits;
import nl.stokpop.memory.report.TextReport;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\b"}, d2={"Lnl/stokpop/memory/MemoryCheck;", "", "()V", "processHistos", "", "reportConfig", "Lnl/stokpop/memory/report/ReportConfig;", "Companion", "memory-check"})
public final class MemoryCheck {
    @NotNull
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    public final void processHistos(@NotNull ReportConfig reportConfig) {
        Iterator $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)reportConfig, (String)"reportConfig");
        File dir = new File(reportConfig.getHistosDirectory());
        if (!dir.isDirectory()) {
            throw (Throwable)new MemoryCheckException("This is not a directory: " + dir.getAbsoluteFile());
        }
        File reportDir = new File(reportConfig.getReportDirectory());
        if (!reportDir.exists()) {
            String string = "Info: creating non-existent report directory: " + reportDir.getAbsoluteFile();
            boolean bl = false;
            System.out.println((Object)string);
            reportDir.mkdirs();
        }
        if (!reportDir.canWrite()) {
            throw (Throwable)new MemoryCheckException("Cannot write to report directory: " + reportDir.getAbsoluteFile());
        }
        Object[] objectArray = dir.listFiles();
        if (objectArray == null) {
            objectArray = new File[]{};
        }
        Iterable iterable = ArraysKt.asList((Object[])objectArray);
        boolean $i$f$filter = false;
        void var7_9 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv = iterator.next();
            File file = (File)element$iv$iv;
            boolean bl = false;
            File file2 = file;
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"file");
            if (!Intrinsics.areEqual((Object)FilesKt.getExtension((File)file2), (Object)reportConfig.getExtension())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List files = CollectionsKt.toList((Iterable)CollectionsKt.sorted((Iterable)((List)destination$iv$iv)));
        System.err.println("\nChecking files: ");
        Iterable $this$forEach$iv = files;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            System.err.println(it);
        }
        ReportLimits reportLimits = reportConfig.getReportLimits();
        List<HeapHistogramDump> readHistos = HistoReader.INSTANCE.readHistos(files, new SafeList(reportLimits.getSafeList()), new WatchList(reportLimits.getWatchList()));
        ClassGrowthTrend analysis = HistoAnalyser.INSTANCE.analyse(readHistos, reportConfig);
        HeapHistogramDumpReport reportData = ReportAnalyser.INSTANCE.createHeapHistogramDumpReport(analysis, reportLimits);
        TextReport.INSTANCE.report(readHistos, reportData, reportConfig);
        File jsonReportFile = JsonReport.INSTANCE.report(reportData, reportConfig);
        File htmlReportFile = HtmlGraphCreator.INSTANCE.writeHtmlGoogleGraphFile(reportData, reportConfig);
        String string = "json report: " + jsonReportFile.getAbsoluteFile();
        boolean bl = false;
        System.out.println((Object)string);
        string = "html report: " + htmlReportFile.getAbsoluteFile();
        bl = false;
        System.out.println((Object)string);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Lnl/stokpop/memory/MemoryCheck$Companion;", "", "()V", "useZoneOffset", "Ljava/time/ZoneId;", "memory-check"})
    public static final class Companion {
        @NotNull
        public final ZoneId useZoneOffset() {
            ZoneId zoneId = ZoneId.systemDefault();
            Intrinsics.checkNotNullExpressionValue((Object)zoneId, (String)"ZoneId.systemDefault()");
            return zoneId;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

