/*
 * Decompiled with CFR 0.152.
 */
package nl.stokpop.memory.report;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import nl.stokpop.memory.domain.AnalysisResult;
import nl.stokpop.memory.domain.ClassInfo;
import nl.stokpop.memory.domain.json.ClassHistogramDetails;
import nl.stokpop.memory.domain.json.HeapHistogramDumpReport;
import nl.stokpop.memory.report.HtmlGraphCreator;
import nl.stokpop.memory.report.HtmlGraphCreator$WhenMappings;
import nl.stokpop.memory.report.ReportConfig;
import nl.stokpop.memory.report.ReportLimits;
import nl.stokpop.memory.util.ConversionUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\f\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J6\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00042\u000e\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u00162\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00180\u00162\u0006\u0010\u0019\u001a\u00020\u0004H\u0002J6\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00042\u000e\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u00162\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00180\u00162\u0006\u0010\u0019\u001a\u00020\u0004H\u0002JB\u0010\u001b\u001a\u00020\u00042\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00180\u00162\u000e\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u00162\u001a\u0010\u001c\u001a\u0016\u0012\u0004\u0012\u00020\u0018\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u00160\u001dH\u0002J6\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00042\u000e\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u00162\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00180\u00162\u0006\u0010\u0019\u001a\u00020\u0004H\u0002J6\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00042\u000e\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u00162\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00180\u00162\u0006\u0010\u0019\u001a\u00020\u0004H\u0002J\u0010\u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020\u00062\u0006\u0010!\u001a\u00020\"H\u0002J\u0016\u0010$\u001a\u00020%2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lnl/stokpop/memory/report/HtmlGraphCreator;", "", "()V", "CHART_HTML_TEMPLATE", "", "arrowDown", "", "arrowFlat", "arrowGrowHickUps", "arrowUpCritical", "arrowUpDown", "arrowUpMinor", "arrowUpSafe", "nonBreakSpace", "analysisResultTable", "data", "Lnl/stokpop/memory/domain/json/HeapHistogramDumpReport;", "reportConfig", "Lnl/stokpop/memory/report/ReportConfig;", "createBytesTable", "title", "timestamps", "", "", "Lnl/stokpop/memory/domain/json/ClassHistogramDetails;", "template", "createBytesTableDiff", "createChartDataTable", "detailsMapper", "Lkotlin/Function1;", "createInstancesTable", "createInstancesTableDiff", "mapToColorUnicodeArrow", "analysis", "Lnl/stokpop/memory/domain/AnalysisResult;", "mapToUnicodeArrow", "writeHtmlGoogleGraphFile", "Ljava/io/File;", "memory-check"})
public final class HtmlGraphCreator {
    private static char arrowUpCritical;
    private static char arrowUpMinor;
    private static char arrowUpSafe;
    private static char arrowGrowHickUps;
    private static char arrowUpDown;
    private static char arrowDown;
    private static char arrowFlat;
    private static char nonBreakSpace;
    private static final String CHART_HTML_TEMPLATE = "\n<html>\n  <head>\n    <meta charset=\"UTF-8\">\n\n    <link rel=\"stylesheet\" href=\"https://fonts.googleapis.com/css?family=Roboto:300,300italic,700,700italic\">\n    <link rel=\"stylesheet\" href=\"https://cdnjs.cloudflare.com/ajax/libs/normalize/8.0.1/normalize.css\">\n    <link rel=\"stylesheet\" href=\"https://cdnjs.cloudflare.com/ajax/libs/milligram/1.4.0/milligram.css\">    \n\n    <script type=\"text/javascript\" src=\"https://www.google.com/jsapi\"></script>\n    <script type=\"text/javascript\">\n      google.load(\"visualization\", \"1\", {packages:[\"corechart\"]});\n      google.setOnLoadCallback(drawChart);\n      function drawChart() {\n        var date_formatter = new google.visualization.DateFormat({ pattern: \"HH:mm:ss.SSS\" });\n        \n        // CHART BYTES\n        \n        var dataBytes = google.visualization.arrayToDataTable([\n          ###TABLE_BYTES###\n        ]);\n        date_formatter.format(dataBytes, 0);\n\n        var optionsBytes = {\n          title: '###TITLE_BYTES###',\n          hAxis: {title: '###H_AXIS_TITLE_BYTES###',  titleTextStyle: {color: '#333'}, format: 'dd-MM HH:mm', minorGridlines: {count: 10, format: 'mm'} },\n          vAxis: {title: '###V_AXIS_TITLE_BYTES###', scaleType: 'log', viewWindow: {} },\n          chartArea: { left:'10%', width:'60%' }\n        };\n\n        var chartBytes = new google.visualization.LineChart(document.getElementById('chart_div_bytes'));\n        chartBytes.draw(dataBytes, optionsBytes);\n\n        // CHART BYTES DIFF\n        \n        var dataBytesDiff = google.visualization.arrayToDataTable([\n          ###TABLE_BYTES_DIFF###\n        ]);\n        date_formatter.format(dataBytesDiff, 0);\n        \n        var optionsBytesDiff = {\n          title: '###TITLE_BYTES_DIFF###',\n          hAxis: {title: '###H_AXIS_TITLE_BYTES_DIFF###',  titleTextStyle: {color: '#333'}, format: 'dd-MM HH:mm', minorGridlines: {count: 10, format: 'mm'} },\n          vAxis: {title: '###V_AXIS_TITLE_BYTES_DIFF###', scaleType: 'mirrorLog', viewWindow: {} },\n          chartArea: { left:'10%', width:'60%' }\n        };\n\n        var chartBytesDiff = new google.visualization.LineChart(document.getElementById('chart_div_bytes_diff'));\n        chartBytesDiff.draw(dataBytesDiff, optionsBytesDiff);\n\n        // CHART INSTANCES\n        \n        var dataInstances = google.visualization.arrayToDataTable([\n          ###TABLE_INSTANCES###\n        ]);\n        date_formatter.format(dataInstances, 0);\n\n        var optionsInstances = {\n          title: '###TITLE_INSTANCES###',\n          hAxis: {title: '###H_AXIS_TITLE_INSTANCES###',  titleTextStyle: {color: '#333'}, format: 'dd-MM HH:mm', minorGridlines: {count: 10, format: 'mm'} },\n          vAxis: {title: '###V_AXIS_TITLE_INSTANCES###', scaleType: 'log', viewWindow: {} },\n          chartArea: { left:'10%', width:'60%' }\n        };\n\n        var chartInstances = new google.visualization.LineChart(document.getElementById('chart_div_instances'));\n        chartInstances.draw(dataInstances, optionsInstances);\n\n        // CHART INSTANCES DIFF\n        \n        var dataInstancesDiff = google.visualization.arrayToDataTable([\n          ###TABLE_INSTANCES_DIFF###\n        ]);\n        date_formatter.format(dataInstancesDiff, 0);\n\n        var optionsInstancesDiff = {\n          title: '###TITLE_INSTANCES_DIFF###',\n          hAxis: {title: '###H_AXIS_TITLE_INSTANCES_DIFF###',  titleTextStyle: {color: '#333'}, format: 'dd-MM HH:mm', minorGridlines: {count: 10, format: 'mm'} },\n          vAxis: {title: '###V_AXIS_TITLE_INSTANCES_DIFF###', scaleType: 'mirrorLog', viewWindow: {} },\n          chartArea: { left:'10%', width:'60%' }\n        };\n\n        var chartBytesDiff = new google.visualization.LineChart(document.getElementById('chart_div_instances_diff'));\n        chartBytesDiff.draw(dataInstancesDiff, optionsInstancesDiff);\n\n    }\n    </script>\n  </head>\n  <body>\n    <div style=\"margin: 5%\">\n    <h1>Stokpop Memory Check</h2>\n    <h2>Heap Histogram Dumps Analysis</h2>\n    ###ANALYSIS-RESULT-SUMMARY###\n    <h2>Heap Histogram Dumps Charts</h2>\n    </div>\n    <div id=\"chart_div_bytes\" style=\"width: 96%; min-height: 800px; height: 50%; margin-left: auto; margin-right: auto\"></div>\n    <div id=\"chart_div_bytes_diff\" style=\"width: 96%; min-height: 800px; height: 50%; margin-left: auto; margin-right: auto\"></div>\n    <div id=\"chart_div_instances\" style=\"width: 96%; min-height: 800px; height: 50%; margin-left: auto; margin-right: auto\"></div>\n    <div id=\"chart_div_instances_diff\" style=\"width: 96%; min-height: 800px; height: 50%; margin-left: auto; margin-right: auto\"></div>\n  </body>\n</html>";
    @NotNull
    public static final HtmlGraphCreator INSTANCE;

    @NotNull
    public final File writeHtmlGoogleGraphFile(@NotNull HeapHistogramDumpReport data, @NotNull ReportConfig reportConfig) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)reportConfig, (String)"reportConfig");
        String title = reportConfig.getIdentifier();
        List<Long> timestamps = data.getHeapHistogramDumpDetails().getTimestamps();
        String template = CHART_HTML_TEMPLATE;
        int size = timestamps.size();
        if (size < 3) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "Not enough points ([%d]<3) to create html graph for [%s].";
            Object[] objectArray = new Object[]{size, title};
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
            String message = string2;
            boolean bl2 = false;
            System.out.println((Object)message);
            template = "<p>" + message + "<p>";
        } else {
            template = StringsKt.replace$default((String)template, (String)"###ANALYSIS-RESULT-SUMMARY###", (String)this.analysisResultTable(data, reportConfig), (boolean)false, (int)4, null);
            List<ClassHistogramDetails> details = data.getHeapHistogramDumpDetails().getClassHistogramDetails();
            template = this.createBytesTable(title, timestamps, details, template);
            template = this.createBytesTableDiff(title, timestamps, details, template);
            template = this.createInstancesTable(title, timestamps, details, template);
            template = this.createInstancesTableDiff(title, timestamps, details, template);
        }
        File file = new File(reportConfig.getReportDirectory(), "heapHistogramDumpReport-" + title + ".html");
        FilesKt.writeText$default((File)file, (String)template, null, (int)2, null);
        return file;
    }

    /*
     * WARNING - void declaration
     */
    private final String analysisResultTable(HeapHistogramDumpReport data, ReportConfig reportConfig) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        StringBuilder html = new StringBuilder(2048);
        ReportLimits reportLimits = data.getReportLimits();
        html.append("<table>");
        html.append("<tr><th>key</th><th>value</th></tr>");
        html.append("<tr><td>Test run id</td><td><b>" + reportConfig.getIdentifier() + "</b></td></tr>").append("\n");
        html.append("<tr><td>Report date</td><td><b>" + reportConfig.getReportDateTime() + "</b></td></tr>").append("\n");
        html.append("<tr><td>Overall analysis result</td><td><b>" + (Object)((Object)data.getLeakResult()) + "</b></td></tr>").append("\n");
        html.append("<tr><td>Report settings</td><td><b>" + reportConfig.getSettings() + "</b></td></tr>").append("\n");
        html.append("<tr><td>Report class limit</td><td><b>" + reportLimits.getClassLimit() + "</b></td></tr>").append("\n");
        html.append("<tr><td>Report byte limit</td><td><b>" + ConversionUtils.INSTANCE.humanReadableMemorySize(reportLimits.getByteLimit()) + "</b></td></tr>").append("\n");
        html.append("<tr><td>Maximum allowed growth percentage</td><td><b>" + reportLimits.getMaxGrowthPercentage() + " %</b></td></tr>").append("\n");
        html.append("<tr><td>Minimum growth points percentage</td><td><b>" + reportLimits.getMinGrowthPointsPercentage() + " %</b></td></tr>").append("\n");
        html.append("<tr><td>Safe list</td><td><b>" + reportLimits.getSafeList() + "</b></td></tr>").append("\n");
        html.append("<tr><td>Watch list</td><td><b>" + reportLimits.getWatchList() + "</b></td></tr>").append("\n");
        html.append("<table>");
        html.append("<table>").append("\n");
        html.append("<tr><th>analysis result</th><th>count</th><th>icon</th><th>description</th></tr>");
        Map<AnalysisResult, Integer> map = data.getHeapHistogramDumpSummary().getData();
        StringBuilder stringBuilder = html;
        boolean $i$f$map = false;
        void var7_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        void var10_11 = $this$mapTo$iv$iv;
        boolean bl = false;
        Iterator iterator = var10_11.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            collection = destination$iv$iv;
            boolean bl2 = false;
            String string = "<tr><td>" + (Object)((Object)((AnalysisResult)((Object)it.getKey()))) + "</td><td>" + ((Number)it.getValue()).intValue() + "</td><td>" + INSTANCE.mapToUnicodeArrow((AnalysisResult)((Object)it.getKey())) + "</td><td>" + ((AnalysisResult)((Object)it.getKey())).getDescription() + "</td></tr>";
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        stringBuilder.append(CollectionsKt.joinToString$default((Iterable)collection, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
        html.append("</table>");
        String string = html.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"html.toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final String createChartDataTable(List<ClassHistogramDetails> data, List<Long> timestamps, Function1<? super ClassHistogramDetails, ? extends List<Long>> detailsMapper2) {
        void $this$mapTo$iv$iv;
        Object object;
        Collection collection;
        void $this$mapTo$iv$iv2;
        StringBuilder table = new StringBuilder(2048);
        Iterable $this$map$iv = data;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            ClassHistogramDetails classHistogramDetails = (ClassHistogramDetails)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            object = "" + INSTANCE.mapToUnicodeArrow(it.getAnalysis()) + nonBreakSpace + ClassInfo.Companion.prefixWatchListAndSafeList(it.getClassInfo()) + it.getClassInfo().getName();
            collection.add(object);
        }
        List classNames = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        Iterable $this$map$iv2 = data;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            destination$iv$iv2.add(detailsMapper2.invoke(item$iv$iv));
        }
        List detailsList = CollectionsKt.toList((Iterable)((List)destination$iv$iv2));
        table.append("['Time'");
        $this$map$iv2 = classNames;
        $i$f$map2 = false;
        if (!$this$map$iv2.isEmpty()) {
            void $this$mapTo$iv$iv3;
            Iterable $this$map$iv3 = classNames;
            boolean $i$f$map3 = false;
            destination$iv$iv2 = $this$map$iv3;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                void it;
                String string = (String)item$iv$iv;
                collection = destination$iv$iv3;
                boolean bl = false;
                object = '\'' + (String)it + '\'';
                collection.add(object);
            }
            String classNamesList = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv3), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
            table.append(", ").append(classNamesList);
        } else {
            table.append(", 'No Data'");
        }
        table.append("],\n");
        int i = 0;
        for (Long timestamp : timestamps) {
            table.append("[ new Date(").append(timestamp).append(")");
            Collection $this$mapTo$iv$iv3 = detailsList;
            boolean destination$iv$iv3 = false;
            if (!$this$mapTo$iv$iv3.isEmpty()) {
                void $this$mapTo$iv$iv4;
                Object item$iv$iv;
                table.append(", ");
                Iterable $this$map$iv4 = detailsList;
                boolean $i$f$map4 = false;
                item$iv$iv = $this$map$iv4;
                Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv4, (int)10));
                boolean $i$f$mapTo4 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv4) {
                    void it;
                    List list = (List)item$iv$iv2;
                    collection = destination$iv$iv4;
                    boolean bl = false;
                    Long l = (Long)it.get(i);
                    object = l != null ? l : 0L;
                    collection.add(object);
                }
                String bytesForTimestamp = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv4), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
                table.append(bytesForTimestamp);
            } else {
                table.append(", 0");
            }
            table.append("]").append(",").append("\n");
            int n = i;
            i = n + 1;
        }
        table.deleteCharAt(table.length() - 2);
        String string = table.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"table.toString()");
        return string;
    }

    private final char mapToUnicodeArrow(AnalysisResult analysis) {
        char c;
        switch (HtmlGraphCreator$WhenMappings.$EnumSwitchMapping$0[analysis.ordinal()]) {
            case 1: {
                c = arrowUpCritical;
                break;
            }
            case 2: {
                c = arrowUpMinor;
                break;
            }
            case 3: {
                c = arrowUpSafe;
                break;
            }
            case 4: {
                c = arrowGrowHickUps;
                break;
            }
            case 5: {
                c = arrowUpDown;
                break;
            }
            case 6: {
                c = arrowDown;
                break;
            }
            case 7: {
                c = arrowFlat;
                break;
            }
            case 8: {
                c = '?';
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return c;
    }

    private final String mapToColorUnicodeArrow(AnalysisResult analysis) {
        String string;
        switch (HtmlGraphCreator$WhenMappings.$EnumSwitchMapping$1[analysis.ordinal()]) {
            case 1: {
                string = "red";
                break;
            }
            case 2: {
                string = "orange";
                break;
            }
            case 3: {
                string = "green";
                break;
            }
            case 4: {
                string = "purple";
                break;
            }
            case 5: {
                string = "magenta";
                break;
            }
            case 6: {
                string = "dark-gray";
                break;
            }
            case 7: {
                string = "black";
                break;
            }
            case 8: {
                string = "light-gray";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        String color = string;
        return "<div style='color:" + color + "'>" + this.mapToUnicodeArrow(analysis) + "</div>";
    }

    private final String createBytesTable(String title, List<Long> timestamps, List<ClassHistogramDetails> data, String template) {
        String newTemplate = template;
        Function1 detailsMapper2 = createBytesTable.detailsMapper.1.INSTANCE;
        String table = this.createChartDataTable(data, timestamps, (Function1<? super ClassHistogramDetails, ? extends List<Long>>)detailsMapper2);
        newTemplate = StringsKt.replace$default((String)newTemplate, (String)"###TABLE_BYTES###", (String)table, (boolean)false, (int)4, null);
        newTemplate = StringsKt.replace$default((String)newTemplate, (String)"###TITLE_BYTES###", (String)("bytes in heap - " + title), (boolean)false, (int)4, null);
        newTemplate = StringsKt.replace$default((String)newTemplate, (String)"###H_AXIS_TITLE_BYTES###", (String)"time", (boolean)false, (int)4, null);
        newTemplate = StringsKt.replace$default((String)newTemplate, (String)"###V_AXIS_TITLE_BYTES###", (String)"bytes", (boolean)false, (int)4, null);
        newTemplate = StringsKt.replace$default((String)newTemplate, (String)"###BASE_UNIT_FULL_BYTES###", (String)"bytes", (boolean)false, (int)4, null);
        newTemplate = StringsKt.replace$default((String)newTemplate, (String)"###BASE_UNIT_SHORT_BYTES###", (String)"B", (boolean)false, (int)4, null);
        return newTemplate;
    }

    private final String createBytesTableDiff(String title, List<Long> timestamps, List<ClassHistogramDetails> data, String template) {
        String newTemplate = template;
        Function1 detailsMapper2 = createBytesTableDiff.detailsMapper.1.INSTANCE;
        String table = this.createChartDataTable(data, timestamps, (Function1<? super ClassHistogramDetails, ? extends List<Long>>)detailsMapper2);
        newTemplate = StringsKt.replace$default((String)newTemplate, (String)"###TABLE_BYTES_DIFF###", (String)table, (boolean)false, (int)4, null);
        newTemplate = StringsKt.replace$default((String)newTemplate, (String)"###TITLE_BYTES_DIFF###", (String)("bytes diff in heap - " + title), (boolean)false, (int)4, null);
        newTemplate = StringsKt.replace$default((String)newTemplate, (String)"###H_AXIS_TITLE_BYTES_DIFF###", (String)"time", (boolean)false, (int)4, null);
        newTemplate = StringsKt.replace$default((String)newTemplate, (String)"###V_AXIS_TITLE_BYTES_DIFF###", (String)"bytes diff", (boolean)false, (int)4, null);
        newTemplate = StringsKt.replace$default((String)newTemplate, (String)"###BASE_UNIT_FULL_BYTES_DIFF###", (String)"bytes", (boolean)false, (int)4, null);
        newTemplate = StringsKt.replace$default((String)newTemplate, (String)"###BASE_UNIT_SHORT_BYTES_DIFF###", (String)"B", (boolean)false, (int)4, null);
        return newTemplate;
    }

    private final String createInstancesTable(String title, List<Long> timestamps, List<ClassHistogramDetails> data, String template) {
        String newTemplate = template;
        Function1 detailsMapper2 = createInstancesTable.detailsMapper.1.INSTANCE;
        String table = this.createChartDataTable(data, timestamps, (Function1<? super ClassHistogramDetails, ? extends List<Long>>)detailsMapper2);
        newTemplate = StringsKt.replace$default((String)newTemplate, (String)"###TABLE_INSTANCES###", (String)table, (boolean)false, (int)4, null);
        newTemplate = StringsKt.replace$default((String)newTemplate, (String)"###TITLE_INSTANCES###", (String)("instances in heap - " + title), (boolean)false, (int)4, null);
        newTemplate = StringsKt.replace$default((String)newTemplate, (String)"###H_AXIS_TITLE_INSTANCES###", (String)"time", (boolean)false, (int)4, null);
        newTemplate = StringsKt.replace$default((String)newTemplate, (String)"###V_AXIS_TITLE_INSTANCES###", (String)"instances", (boolean)false, (int)4, null);
        newTemplate = StringsKt.replace$default((String)newTemplate, (String)"###BASE_UNIT_FULL_INSTANCES###", (String)"instances", (boolean)false, (int)4, null);
        newTemplate = StringsKt.replace$default((String)newTemplate, (String)"###BASE_UNIT_SHORT_INSTANCES###", (String)"#", (boolean)false, (int)4, null);
        return newTemplate;
    }

    private final String createInstancesTableDiff(String title, List<Long> timestamps, List<ClassHistogramDetails> data, String template) {
        String newTemplate = template;
        Function1 detailsMapper2 = createInstancesTableDiff.detailsMapper.1.INSTANCE;
        String table = this.createChartDataTable(data, timestamps, (Function1<? super ClassHistogramDetails, ? extends List<Long>>)detailsMapper2);
        newTemplate = StringsKt.replace$default((String)newTemplate, (String)"###TABLE_INSTANCES_DIFF###", (String)table, (boolean)false, (int)4, null);
        newTemplate = StringsKt.replace$default((String)newTemplate, (String)"###TITLE_INSTANCES_DIFF###", (String)("instances diff in heap - " + title), (boolean)false, (int)4, null);
        newTemplate = StringsKt.replace$default((String)newTemplate, (String)"###H_AXIS_TITLE_INSTANCES_DIFF###", (String)"time", (boolean)false, (int)4, null);
        newTemplate = StringsKt.replace$default((String)newTemplate, (String)"###V_AXIS_TITLE_INSTANCES_DIFF###", (String)"instances diff", (boolean)false, (int)4, null);
        newTemplate = StringsKt.replace$default((String)newTemplate, (String)"###BASE_UNIT_FULL_INSTANCES_DIFF###", (String)"instances", (boolean)false, (int)4, null);
        newTemplate = StringsKt.replace$default((String)newTemplate, (String)"###BASE_UNIT_SHORT_INSTANCES_DIFF###", (String)"#", (boolean)false, (int)4, null);
        return newTemplate;
    }

    private HtmlGraphCreator() {
    }

    static {
        HtmlGraphCreator htmlGraphCreator;
        INSTANCE = htmlGraphCreator = new HtmlGraphCreator();
        arrowUpCritical = (char)9650;
        arrowUpMinor = (char)8679;
        arrowUpSafe = (char)8593;
        arrowGrowHickUps = (char)10595;
        arrowUpDown = (char)8597;
        arrowDown = (char)8595;
        arrowFlat = (char)8596;
        nonBreakSpace = (char)160;
    }
}

